/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstalledIUGroup;
import org.eclipse.equinox.internal.p2.ui.model.ProfileSnapshots;
import org.eclipse.equinox.internal.p2.ui.model.RollbackProfileElement;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementLabelProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.operations.ProfileModificationJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.ui.ICopyable;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.about.InstallationPage;
import org.eclipse.ui.menus.AbstractContributionFactory;

public class RevertProfilePage
extends InstallationPage
implements ICopyable {
    private static final int REVERT_ID = 1024;
    private static final int DELETE_ID = 1025;
    TableViewer configsViewer;
    TreeViewer configContentsViewer;
    IUDetailsLabelProvider labelProvider;
    IAction revertAction;
    Button revertButton;
    Button deleteButton;
    String profileId;
    AbstractContributionFactory factory;
    Text detailsArea;
    InstalledIUGroup installedIUGroup;
    ProvisioningUI ui;

    public void createPageButtons(Composite parent) {
        if (this.profileId == null) {
            return;
        }
        this.deleteButton = this.createButton(parent, 1025, ProvUIMessages.RevertProfilePage_Delete);
        this.deleteButton.setToolTipText(ProvUIMessages.RevertProfilePage_DeleteTooltip);
        this.deleteButton.setEnabled(this.computeDeleteEnablement());
        this.revertButton = this.createButton(parent, 1024, this.revertAction.getText());
        this.revertButton.setToolTipText(this.revertAction.getToolTipText());
        this.revertButton.setEnabled(this.revertAction.isEnabled());
    }

    public void createControl(Composite parent) {
        this.ui = ProvisioningUI.getDefaultUI();
        this.profileId = this.ui.getProfileId();
        if (this.profileId == null) {
            IStatus status = this.ui.getPolicy().getNoProfileChosenStatus();
            if (status != null) {
                ProvUI.reportStatus(status, 1);
            }
            Text text = new Text(parent, 72);
            text.setLayoutData((Object)new GridData(4, 4, true, true));
            text.setText(ProvUIMessages.RevertProfilePage_NoProfile);
            this.setControl((Control)text);
            return;
        }
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.equinox.p2.ui.revert_configuration_wizard_context");
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gd);
        this.createConfigurationsSection((Composite)sashForm);
        this.createContentsSection((Composite)sashForm);
        this.setControl((Control)sashForm);
        this.createRevertAction();
    }

    private void createConfigurationsSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.RevertDialog_ConfigsLabel);
        this.configsViewer = new TableViewer(composite, 2818);
        ProvElementContentProvider provider = new ProvElementContentProvider(){

            protected void finishedFetchingElements(Object o) {
                Object element = RevertProfilePage.this.configsViewer.getElementAt(0);
                if (element != null) {
                    RevertProfilePage.this.configsViewer.setSelection((ISelection)new StructuredSelection(element));
                }
            }
        };
        provider.setFetchInBackground(true);
        this.configsViewer.setContentProvider((IContentProvider)provider);
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new ProvElementLabelProvider());
        this.configsViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (o1 instanceof RollbackProfileElement && o2 instanceof RollbackProfileElement) {
                    long timestamp2;
                    long timestamp1 = ((RollbackProfileElement)o1).getTimestamp();
                    if (timestamp1 > (timestamp2 = ((RollbackProfileElement)o2).getTimestamp())) {
                        return -1;
                    }
                    return 1;
                }
                return o2.toString().compareTo(o1.toString());
            }
        });
        this.configsViewer.setInput(this.getInput());
        this.configsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RevertProfilePage.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        CopyUtils.activateCopy(this, this.configsViewer.getControl());
        gd = new GridData(4, 4, true, true);
        this.configsViewer.getControl().setLayoutData((Object)gd);
    }

    private void createContentsSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.RevertDialog_ConfigContentsLabel);
        this.configContentsViewer = new TreeViewer(composite, 68354);
        IUComparator comparator = new IUComparator(0);
        comparator.useColumnConfig(ProvUI.getIUColumnConfig());
        this.configContentsViewer.setComparator((ViewerComparator)comparator);
        this.configContentsViewer.setComparer((IElementComparer)new ProvElementComparer());
        this.configContentsViewer.setContentProvider((IContentProvider)new DeferredQueryContentProvider());
        this.setTreeColumns(this.configContentsViewer.getTree());
        this.labelProvider = new IUDetailsLabelProvider();
        this.configContentsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        gd = new GridData(1808);
        this.configContentsViewer.getControl().setLayoutData((Object)gd);
        CopyUtils.activateCopy(this, this.configContentsViewer.getControl());
    }

    private void createRevertAction() {
        this.revertAction = new Action(){

            public void run() {
                boolean result = MessageDialog.openQuestion((Shell)RevertProfilePage.this.getShell(), (String)ProvUIMessages.RevertDialog_Title, (String)ProvUIMessages.RevertDialog_ConfirmRestartMessage);
                if (!result) {
                    return;
                }
                boolean finish = RevertProfilePage.this.revert();
                if (finish) {
                    RevertProfilePage.this.getPageContainer().closeModalContainers();
                }
            }
        };
        this.revertAction.setText(ProvUIMessages.RevertProfilePage_RevertLabel);
        this.revertAction.setToolTipText(ProvUIMessages.RevertProfilePage_RevertTooltip);
    }

    private Object getInput() {
        ProfileSnapshots element = new ProfileSnapshots(this.profileId);
        return element;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                this.revertAction.run();
                break;
            }
            case 1025: {
                this.deleteSelectedSnapshots();
            }
        }
    }

    protected void handleSelectionChanged(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            if (selection.size() == 1) {
                Object selected = selection.getFirstElement();
                if (selected instanceof RollbackProfileElement) {
                    Object[] elements = this.configContentsViewer.getExpandedElements();
                    this.configContentsViewer.getTree().setRedraw(false);
                    this.configContentsViewer.setInput(selected);
                    this.configContentsViewer.setExpandedElements(elements);
                    this.configContentsViewer.getTree().setRedraw(true);
                    boolean isNotCurrentProfile = !((RollbackProfileElement)selected).isCurrentProfile();
                    this.revertAction.setEnabled(isNotCurrentProfile);
                    if (this.revertButton != null) {
                        this.revertButton.setEnabled(isNotCurrentProfile);
                    }
                    if (this.deleteButton != null) {
                        this.deleteButton.setEnabled(isNotCurrentProfile);
                    }
                    return;
                }
            } else {
                this.revertAction.setEnabled(false);
                if (this.revertButton != null) {
                    this.revertButton.setEnabled(false);
                }
                this.configContentsViewer.setInput(null);
                this.deleteButton.setEnabled(this.computeDeleteEnablement());
                return;
            }
        }
        this.configContentsViewer.setInput(null);
        this.revertAction.setEnabled(false);
        if (this.revertButton != null) {
            this.revertButton.setEnabled(false);
        }
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(this.computeDeleteEnablement());
        }
    }

    boolean computeDeleteEnablement() {
        boolean okToDelete = true;
        Iterator iter = ((IStructuredSelection)this.configsViewer.getSelection()).iterator();
        while (iter.hasNext()) {
            Object selected = iter.next();
            if (selected instanceof RollbackProfileElement && !((RollbackProfileElement)selected).isCurrentProfile()) continue;
            okToDelete = false;
            break;
        }
        return okToDelete;
    }

    private void setTreeColumns(Tree tree) {
        IUColumnConfig[] columns = ProvUI.getIUColumnConfig();
        tree.setHeaderVisible(true);
        int i = 0;
        while (i < columns.length) {
            TreeColumn tc = new TreeColumn(tree, 0, i);
            tc.setResizable(true);
            tc.setText(columns[i].getColumnTitle());
            tc.setWidth(columns[i].getWidthInPixels((Control)tree));
            ++i;
        }
    }

    private IProfile getSelectedSnapshot() {
        Object selected = ((IStructuredSelection)this.configsViewer.getSelection()).getFirstElement();
        if (selected != null && selected instanceof RollbackProfileElement) {
            return ((RollbackProfileElement)selected).getProfileSnapshot((IProgressMonitor)new NullProgressMonitor());
        }
        return null;
    }

    boolean revert() {
        final IProfile snapshot = this.getSelectedSnapshot();
        if (snapshot == null) {
            return false;
        }
        final IProvisioningPlan[] plan = new IProvisioningPlan[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IProfileRegistry registry = ProvUI.getProfileRegistry(RevertProfilePage.this.getSession());
                IPlanner planner = (IPlanner)RevertProfilePage.this.getSession().getProvisioningAgent().getService(IPlanner.SERVICE_NAME);
                IProfile currentProfile = registry.getProfile(RevertProfilePage.this.profileId);
                plan[0] = planner.getDiffPlan(currentProfile, snapshot, monitor);
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ProvUI.handleException(e.getCause(), null, 3);
        }
        catch (InterruptedException interruptedException) {}
        if (dialog.getProgressMonitor().isCanceled()) {
            return false;
        }
        boolean reverted = false;
        if (plan[0] != null) {
            if (plan[0].getStatus().isOK()) {
                ProfileModificationJob op = new ProfileModificationJob(ProvUIMessages.RevertDialog_RevertOperationLabel, this.getSession(), this.profileId, plan[0], new ProvisioningContext(this.getSession().getProvisioningAgent()));
                op.setRestartPolicy(3);
                this.ui.schedule((ProvisioningJob)op, 3);
                reverted = true;
            } else if (plan[0].getStatus().getSeverity() != 8) {
                ProvUI.reportStatus(plan[0].getStatus(), 3);
            }
        }
        return reverted;
    }

    public void copyToClipboard(Control activeControl) {
        String text = "";
        if (activeControl == this.configContentsViewer.getControl()) {
            text = CopyUtils.getIndentedClipboardText(((IStructuredSelection)this.configContentsViewer.getSelection()).toArray(), this.labelProvider);
        } else if (activeControl == this.configsViewer.getControl()) {
            Object[] elements = ((IStructuredSelection)this.configsViewer.getSelection()).toArray();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof RollbackProfileElement) {
                    if (i > 0) {
                        buffer.append(CopyUtils.NEWLINE);
                    }
                    buffer.append(((RollbackProfileElement)elements[i]).getLabel(elements[i]));
                }
                ++i;
            }
            text = buffer.toString();
        } else {
            return;
        }
        if (text.length() == 0) {
            return;
        }
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    void deleteSelectedSnapshots() {
        String confirmMessage;
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        String title = selection.size() == 1 ? ProvUIMessages.RevertProfilePage_DeleteSingleConfigurationTitle : ProvUIMessages.RevertProfilePage_DeleteMultipleConfigurationsTitle;
        String string = confirmMessage = selection.size() == 1 ? ProvUIMessages.RevertProfilePage_ConfirmDeleteSingleConfig : ProvUIMessages.RevertProfilePage_ConfirmDeleteMultipleConfigs;
        if (MessageDialog.openConfirm((Shell)this.configsViewer.getControl().getShell(), (String)title, (String)confirmMessage)) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object selected = iter.next();
                if (!(selected instanceof RollbackProfileElement) || ((RollbackProfileElement)selected).isCurrentProfile()) continue;
                RollbackProfileElement snapshot = (RollbackProfileElement)selected;
                IProfileRegistry registry = ProvUI.getProfileRegistry(this.getSession());
                if (registry == null) continue;
                try {
                    registry.removeProfile(this.profileId, snapshot.getTimestamp());
                    this.configsViewer.refresh();
                }
                catch (ProvisionException e) {
                    ProvUI.handleException(e, null, 3);
                }
            }
        }
    }

    ProvisioningSession getSession() {
        return this.getProvisioningUI().getSession();
    }

    ProvisioningUI getProvisioningUI() {
        return ProvisioningUI.getDefaultUI();
    }

    protected IStructuredSelection getSelection() {
        return (IStructuredSelection)this.configsViewer.getSelection();
    }
}

