/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Ray;

public class Straight {
    private Ray p;
    private Ray a;

    public Straight(Ray position, Ray direction) {
        this.p = position;
        this.a = direction;
    }

    public Straight(Point point1, Point point2) {
        this(new Ray(point1), new Ray(point1, point2));
    }

    public Ray getPosition() {
        return this.p;
    }

    public Ray getDirection() {
        return this.a;
    }

    public boolean intersects(Straight g2) {
        return this.a.dotProduct(g2.getDirection().getOrthogonalComplement()) != 0;
    }

    public Ray getIntersection(Straight g2) {
        if (!this.intersects(g2)) {
            return null;
        }
        Ray q = g2.getPosition();
        Ray b = g2.getDirection();
        Ray aOC = this.a.getOrthogonalComplement();
        Ray bOC = b.getOrthogonalComplement();
        int[] intersection = new int[]{(q.dotProduct(bOC) * this.a.x - this.p.dotProduct(aOC) * b.x) / this.a.dotProduct(bOC), (q.dotProduct(bOC) * this.a.y - this.p.dotProduct(aOC) * b.y) / this.a.dotProduct(bOC)};
        return new Ray(intersection[0], intersection[1]);
    }

    public double getAngle(Straight g2) {
        return this.a.getAngle(g2.getDirection());
    }

    public Ray getProjection(Ray q) {
        Ray s = this.getIntersection(new Straight(q, this.a.getOrthogonalComplement()));
        return s;
    }

    public double getDistance(Ray q) {
        Ray s = this.getProjection(q);
        return s.getSubtracted(q).length();
    }

    public boolean contains(Ray q) {
        return this.getDistance(q) == 0.0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Straight)) {
            return false;
        }
        Straight otherLine = (Straight)other;
        return this.contains(otherLine.getPosition()) && this.a.getOrthogonalComplement().dotProduct(otherLine.getDirection()) == 0;
    }
}

