/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator.resources;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IAggregateWorkingSet;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.framelist.Frame;
import org.eclipse.ui.internal.navigator.framelist.FrameList;
import org.eclipse.ui.internal.navigator.framelist.TreeFrame;
import org.eclipse.ui.internal.navigator.resources.ResourceToItemsMapper;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonViewerMapper;

public final class ProjectExplorer
extends CommonNavigator {
    public static final String VIEW_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    public static final int WORKING_SETS = 0;
    public static final int PROJECTS = 1;
    private int rootMode;
    private String workingSetLabel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.getCommonViewer().setMapper((ICommonViewerMapper)new ResourceToItemsMapper(this.getCommonViewer()));
    }

    public void updateTitle() {
        super.updateTitle();
        Object input = this.getCommonViewer().getInput();
        if (input == null || input instanceof IAggregateWorkingSet) {
            this.setContentDescription("");
            return;
        }
        if (!(input instanceof IResource)) {
            if (input instanceof IAdaptable) {
                IWorkbenchAdapter wbadapter;
                IAdaptable iAdaptable = (IAdaptable)input;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((wbadapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                    this.setContentDescription(wbadapter.getLabel(input));
                    return;
                }
            }
            this.setContentDescription(input.toString());
            return;
        }
        IResource res = (IResource)input;
        this.setContentDescription(res.getName());
    }

    public String getFrameToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof IAggregateWorkingSet ? WorkbenchNavigatorMessages.ProjectExplorerPart_workingSetModel : (element instanceof IWorkingSet ? ((IWorkingSet)element).getLabel() : super.getFrameToolTipText(element))) : ((path = ((IResource)element).getFullPath()).isRoot() ? WorkbenchNavigatorMessages.ProjectExplorerPart_workspace : path.makeRelative().toString());
        if (this.rootMode == 1) {
            if (this.workingSetLabel == null) {
                return result;
            }
            if (result.length() == 0) {
                return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip, (Object[])new String[]{this.workingSetLabel});
            }
            return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip2, (Object[])new String[]{result, this.workingSetLabel});
        }
        if (element != null && !(element instanceof IWorkingSet) && this.getCommonViewer() != null) {
            FrameList frameList = this.getCommonViewer().getFrameList();
            if (frameList == null) {
                return result;
            }
            int index = frameList.getCurrentIndex();
            IWorkingSet ws = null;
            while (index >= 0) {
                Object input;
                Frame frame = frameList.getFrame(index);
                if (frame instanceof TreeFrame && (input = ((TreeFrame)frame).getInput()) instanceof IWorkingSet && !(input instanceof IAggregateWorkingSet)) {
                    ws = (IWorkingSet)input;
                    break;
                }
                --index;
            }
            if (ws != null) {
                return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip3, (Object[])new String[]{ws.getLabel(), result});
            }
            return result;
        }
        return result;
    }

    public void setRootMode(int mode) {
        this.rootMode = mode;
    }

    public int getRootMode() {
        return this.rootMode;
    }

    public void setWorkingSetLabel(String label) {
        this.workingSetLabel = label;
    }

    public String getWorkingSetLabel() {
        return this.workingSetLabel;
    }

    public void selectReveal(ISelection selection) {
        if (this.getCommonViewer() != null) {
            this.getCommonViewer().setSelection(this.convertSelection(selection), true);
        }
    }

    private ISelection convertSelection(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return s;
        }
        Object[] elements = ((IStructuredSelection)s).toArray();
        boolean changed = false;
        int i = 0;
        while (i < elements.length) {
            Object convertedElement = this.convertElement(elements[i]);
            changed = changed || convertedElement != elements[i];
            elements[i] = convertedElement;
            ++i;
        }
        if (changed) {
            return new StructuredSelection(elements);
        }
        return s;
    }

    private Object convertElement(Object original) {
        NavigatorContentService ncs = (NavigatorContentService)this.getNavigatorContentService();
        Object found = ncs.getViewerElementData(original);
        if (found != null) {
            return original;
        }
        if (original instanceof IAdaptable) {
            IWorkbenchAdapter wba;
            IAdaptable adaptable = (IAdaptable)original;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((found = adaptable.getAdapter((Class)clazz)) != null) {
                return found;
            }
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((found = (wba = (IWorkbenchAdapter)adaptable.getAdapter((Class)clazz2)).getParent(original)) != null) {
                return this.convertElement(found);
            }
        }
        return original;
    }
}

