/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.debug.internal.ui.ImageDescriptorRegistry;
import org.osgi.framework.Bundle;

public final class JavaScriptImageRegistry {
    private static ImageRegistry imageRegistry;
    private static ImageDescriptorRegistry descRegistry;
    private static String ICONS_PATH;
    private static final String ELCL;
    private static final String OVR;
    private static final String DLCL;

    static {
        ICONS_PATH = "$nl$/icons/";
        ELCL = String.valueOf(ICONS_PATH) + "elcl16/";
        OVR = String.valueOf(ICONS_PATH) + "ovr16/";
        DLCL = String.valueOf(ICONS_PATH) + "dlcl16/";
    }

    private static void declareImages() {
        JavaScriptImageRegistry.declareRegistryImage("IMG_SCRIPT", String.valueOf(ELCL) + "script.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_SCRIPT_GRP", String.valueOf(ELCL) + "script_grp.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_LOCAL_VAR", String.valueOf(ELCL) + "localvariable.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_CONNECT", String.valueOf(ELCL) + "connect.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_BRKP", String.valueOf(ELCL) + "brkp_obj.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_SCRIPTBRKP", String.valueOf(ELCL) + "scriptbrkp_obj.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_BRKP_DISABLED", String.valueOf(DLCL) + "brkpd_obj.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_OVR_CONDITIONAL", String.valueOf(OVR) + "conditional_ovr.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_OVR_CONDITIONAL_DISABLED", String.valueOf(OVR) + "conditional_ovr_disabled.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_OVR_ENTRY", String.valueOf(OVR) + "entry_ovr.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_OVR_ENTRY_DISABLED", String.valueOf(OVR) + "entry_ovr_disabled.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_OVR_EXIT", String.valueOf(OVR) + "exit_ovr.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_OVR_EXIT_DISABLED", String.valueOf(OVR) + "exit_ovr_disabled.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_OVR_INSTALLED", String.valueOf(OVR) + "installed_ovr.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_OVR_INSTALLED_DISABLED", String.valueOf(OVR) + "installed_ovr_disabled.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_OVR_SCOPED", String.valueOf(OVR) + "scoped_ovr.gif");
        JavaScriptImageRegistry.declareRegistryImage("IMG_OVR_SCOPED_DISABLED", String.valueOf(OVR) + "scoped_ovr_disabled.gif");
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.jsdt.debug.ui");
        URL url = null;
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null)) != null) {
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        imageRegistry.put(key, desc);
    }

    public static Image getSharedImage(String key) {
        if (imageRegistry == null) {
            JavaScriptImageRegistry.initializeImageRegistry();
        }
        return imageRegistry.get(key);
    }

    private static synchronized ImageRegistry initializeImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
            JavaScriptImageRegistry.declareImages();
        }
        return imageRegistry;
    }

    public static Image getImage(ImageDescriptor descriptor) {
        if (descRegistry == null) {
            descRegistry = new ImageDescriptorRegistry();
        }
        return descRegistry.get(descriptor);
    }

    public static void dispose() {
        if (imageRegistry != null) {
            imageRegistry.dispose();
        }
        if (descRegistry != null) {
            descRegistry.dispose();
        }
    }

    private JavaScriptImageRegistry() {
    }
}

