/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request;

import java.util.Map;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.BreakpointRequest;
import org.eclipse.wst.jsdt.debug.internal.rhino.RhinoDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ScriptReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.EventRequestImpl;
import org.eclipse.wst.jsdt.debug.rhino.transport.DisconnectedException;
import org.eclipse.wst.jsdt.debug.rhino.transport.Request;
import org.eclipse.wst.jsdt.debug.rhino.transport.Response;
import org.eclipse.wst.jsdt.debug.rhino.transport.TimeoutException;

public class BreakpointRequestImpl
extends EventRequestImpl
implements BreakpointRequest {
    private final Location location;
    private ThreadReference thread;
    private String condition;
    private Long breakpointId;
    private int hitcount = 0;

    public BreakpointRequestImpl(VirtualMachineImpl vm, Location location) {
        super(vm);
        this.location = location;
    }

    public synchronized void addThreadFilter(ThreadReference thread) {
        this.checkDeleted();
        this.thread = thread;
    }

    public synchronized ThreadReference thread() {
        return this.thread;
    }

    public synchronized void addConditionFilter(String condition) {
        this.checkDeleted();
        this.condition = condition;
    }

    public void addHitCountFilter(int hitcount) {
        this.checkDeleted();
        this.hitcount = hitcount;
    }

    public synchronized String condition() {
        return this.condition;
    }

    public synchronized int hitcount() {
        return this.hitcount;
    }

    public Location location() {
        return this.location;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.checkDeleted();
        if (this.enabled == enabled) {
            return;
        }
        if (enabled) {
            ScriptReferenceImpl scriptReferenceImpl = (ScriptReferenceImpl)this.location.scriptReference();
            Long scriptId = scriptReferenceImpl.getScriptId();
            Request request = new Request("setbreakpoint");
            request.getArguments().put("scriptId", scriptId);
            request.getArguments().put("condition", this.condition);
            if (this.location.functionName() != null) {
                request.getArguments().put("function", this.location.functionName());
            } else {
                request.getArguments().put("line", new Integer(this.location.lineNumber()));
            }
            try {
                Response response = this.vm.sendRequest(request);
                Map body = (Map)response.getBody().get("breakpoint");
                Number id = (Number)body.get("breakpointId");
                this.breakpointId = new Long(id.longValue());
            }
            catch (TimeoutException e) {
                RhinoDebugPlugin.log(e);
            }
            catch (DisconnectedException e) {
                RhinoDebugPlugin.log(e);
            }
        } else {
            Request request = new Request("clearbreakpoint");
            request.getArguments().put("breakpointId", this.breakpointId);
            try {
                this.vm.sendRequest(request);
            }
            catch (TimeoutException e) {
                RhinoDebugPlugin.log(e);
            }
            catch (DisconnectedException disconnectedException) {}
            this.breakpointId = null;
        }
        this.enabled = enabled;
    }

    public Long breakpointId() {
        return this.breakpointId;
    }
}

