/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.launcher.PluginStatusDialog;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.pde.internal.ui.shared.FilteredCheckboxTree;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.ui.launcher.PluginsTab;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PatternFilter;

public class FeatureBlock {
    private static final int COLUMN_FEATURE_NAME = 0;
    private static final int COLUMN_PLUGIN_RESOLUTION = 1;
    private static final String COLUMN_ID = "columnID";
    private static final String PROPERTY_RESOLUTION = "resolution";
    private Button fAddRequiredFeaturesButton;
    private Button fDefaultsButton;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Button fWorkspacePluginButton;
    private Button fExternalPluginButton;
    private Label fCounter;
    private Button fFeatureWorkspaceButton;
    private Button fAutoValidate;
    private Button fValidateButton;
    private ILaunchConfiguration fLaunchConfig;
    private ButtonSelectionListener fListener;
    private AbstractLauncherTab fTab;
    private CachedCheckboxTreeViewer fTree;
    private LaunchValidationOperation fOperation;
    private Map fFeatureModels;

    public FeatureBlock(PluginsTab pluginsTab) {
        Assert.isNotNull((Object)((Object)pluginsTab));
        this.fTab = pluginsTab;
        PDEPlugin.getDefault().getLabelProvider().connect(this);
    }

    public void createControl(Composite parent, int span, int indent) {
        this.fListener = new ButtonSelectionListener();
        Composite composite = SWTFactory.createComposite(parent, 1, span, 1808, 0, 0);
        Composite treeGroup = SWTFactory.createComposite(composite, 2, 1, 1808, 0, 0);
        SWTFactory.createLabel(treeGroup, PDEUIMessages.FeatureBlock_FeatureGroupDescription, 2);
        this.createCheckBoxTree(treeGroup);
        this.createButtonContainer(treeGroup, 10);
        this.fFeatureWorkspaceButton = SWTFactory.createCheckButton(treeGroup, PDEUIMessages.FeatureBlock_UseWorkspaceFeatures, null, true, 2);
        this.fFeatureWorkspaceButton.addSelectionListener((SelectionListener)this.fListener);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        Composite validatecomp = SWTFactory.createComposite(composite, 2, 1, 768, 0, 0);
        this.fAutoValidate = SWTFactory.createCheckButton(validatecomp, NLS.bind((String)PDEUIMessages.PluginsTabToolBar_auto_validate, (Object)this.fTab.getName().replaceAll("&", "").toLowerCase(Locale.ENGLISH)), null, false, 1);
        this.fAutoValidate.addSelectionListener((SelectionListener)this.fListener);
        Composite rightAlignComp = SWTFactory.createComposite(validatecomp, 1, 1, 0, 0, 0);
        rightAlignComp.setLayoutData((Object)new GridData(131072, 1024, true, true));
        this.fValidateButton = SWTFactory.createPushButton(rightAlignComp, NLS.bind((String)PDEUIMessages.PluginsTabToolBar_validate, (Object)this.fTab.getName().replaceAll("&", "")), null);
        this.fValidateButton.addSelectionListener((SelectionListener)this.fListener);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    private void createCheckBoxTree(Composite parent) {
        PatternFilter filter = new PatternFilter(){

            public boolean isElementVisible(Viewer viewer, Object element) {
                if (element instanceof FeatureLaunchModel) {
                    return super.isElementVisible(viewer, (Object)((FeatureLaunchModel)element).getId());
                }
                return super.isElementVisible(viewer, element);
            }
        };
        filter.setIncludeLeadingWildcard(true);
        FilteredCheckboxTree tree = new FilteredCheckboxTree(parent, null, 65536, filter);
        GridData gd = new GridData(1808);
        tree.setLayoutData(gd);
        this.fTree = tree.getCheckboxTreeViewer();
        TreeColumn column1 = new TreeColumn(this.fTree.getTree(), 16384);
        column1.setText(PDEUIMessages.FeatureBlock_features);
        column1.setWidth(400);
        column1.addSelectionListener((SelectionListener)this.fListener);
        column1.setData(COLUMN_ID, (Object)new Integer(0));
        TreeColumn column2 = new TreeColumn(this.fTree.getTree(), 0x1000000);
        column2.setText(PDEUIMessages.FeatureBlock_pluginResolution);
        column2.setWidth(100);
        column2.addSelectionListener((SelectionListener)this.fListener);
        column2.setData(COLUMN_ID, (Object)new Integer(1));
        this.fTree.getTree().setHeaderVisible(true);
        this.fTree.setLabelProvider((IBaseLabelProvider)new FeatureTreeLabelProvider());
        this.fTree.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FeatureBlock.this.updateCounter();
                FeatureBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        String[] items = new String[]{PDEUIMessages.FeatureBlock_default, PDEUIMessages.FeatureBlock_workspaceBefore, PDEUIMessages.FeatureBlock_externalBefore};
        ComboBoxCellEditor cellEditor = new ComboBoxCellEditor((Composite)this.fTree.getTree(), items);
        cellEditor.getControl().pack();
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = cellEditor;
        this.fTree.setCellEditors(cellEditorArray);
        String[] stringArray = new String[2];
        stringArray[1] = PROPERTY_RESOLUTION;
        this.fTree.setColumnProperties(stringArray);
        this.fTree.setCellModifier(new LocationCellModifier());
        this.fTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                Object element = ((IStructuredSelection)selection).getFirstElement();
                FeatureBlock.this.fTree.setChecked(element, !FeatureBlock.this.fTree.getChecked(element));
                FeatureBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createButtonContainer(Composite parent, int vOffset) {
        Composite buttonComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = vOffset;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.fSelectAllButton = SWTFactory.createPushButton(buttonComp, PDEUIMessages.AdvancedLauncherTab_selectAll, null);
        this.fSelectAllButton.addSelectionListener((SelectionListener)this.fListener);
        this.fDeselectAllButton = SWTFactory.createPushButton(buttonComp, PDEUIMessages.AdvancedLauncherTab_deselectAll, null);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)this.fListener);
        this.fAddRequiredFeaturesButton = SWTFactory.createPushButton(buttonComp, PDEUIMessages.FeatureBlock_addRequiredFeatues, null);
        this.fAddRequiredFeaturesButton.addSelectionListener((SelectionListener)this.fListener);
        this.fDefaultsButton = SWTFactory.createPushButton(buttonComp, PDEUIMessages.AdvancedLauncherTab_defaults, null);
        this.fDefaultsButton.addSelectionListener((SelectionListener)this.fListener);
        SWTFactory.createHorizontalSpacer(buttonComp, 1);
        SWTFactory.createLabel(buttonComp, PDEUIMessages.FeatureBlock_defaultPluginResolution, 1);
        this.fWorkspacePluginButton = SWTFactory.createRadioButton(buttonComp, PDEUIMessages.FeatureBlock_workspaceBefore);
        this.fWorkspacePluginButton.addSelectionListener((SelectionListener)this.fListener);
        this.fExternalPluginButton = SWTFactory.createRadioButton(buttonComp, PDEUIMessages.FeatureBlock_externalBefore);
        this.fExternalPluginButton.addSelectionListener((SelectionListener)this.fListener);
        Composite countComp = SWTFactory.createComposite(buttonComp, 1, 1, 0, 0, 0);
        countComp.setLayoutData((Object)new GridData(16384, 1024, true, true));
        this.fCounter = new Label(countComp, 0);
    }

    public void initialize() throws CoreException {
        this.initializeFrom(this.fLaunchConfig);
    }

    public void initializeFrom(ILaunchConfiguration config) throws CoreException {
        if (this.fLaunchConfig != null && this.fLaunchConfig.equals(config)) {
            return;
        }
        this.fLaunchConfig = config;
        this.setInput(config, (CheckboxTreeViewer)this.fTree);
        this.updateCounter();
        String pluginResolution = config.getAttribute("featurePluginResolution", "workspace");
        if (pluginResolution.equalsIgnoreCase("workspace")) {
            this.fWorkspacePluginButton.setSelection(true);
            this.fExternalPluginButton.setSelection(false);
        } else {
            this.fWorkspacePluginButton.setSelection(false);
            this.fExternalPluginButton.setSelection(true);
        }
        String featureLocation = config.getAttribute("featureDefaultLocation", "workspace");
        this.fFeatureWorkspaceButton.setSelection(featureLocation.equalsIgnoreCase("workspace"));
        this.fAutoValidate.setSelection(config.getAttribute("automaticValidate", false));
        if (this.fLaunchConfig.isWorkingCopy()) {
            this.savePluginState((ILaunchConfigurationWorkingCopy)this.fLaunchConfig);
        }
        this.fTab.updateLaunchConfigurationDialog();
        PDEPreferencesManager prefs = new PDEPreferencesManager("org.eclipse.pde.ui");
        int index = prefs.getInt("Preferences.RunConfigs.Feature.SortColumn");
        TreeColumn column = this.fTree.getTree().getColumn(index == 0 ? 0 : index - 1);
        this.fListener.handleColumn(column, prefs.getInt("Preferences.RunConfigs.Feature.SortOrder"));
        this.fTree.refresh(true);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("show_selected_only", false);
        config.setAttribute("featureDefaultLocation", this.fFeatureWorkspaceButton.getSelection() ? "workspace" : "external");
        config.setAttribute("featurePluginResolution", this.fWorkspacePluginButton.getSelection() ? "workspace" : "external");
        config.setAttribute("automaticValidate", this.fAutoValidate.getSelection());
        this.savePluginState(config);
        this.saveSortOrder();
        this.updateCounter();
    }

    private void savePluginState(ILaunchConfigurationWorkingCopy config) {
        HashSet<String> featuresEntry = new HashSet<String>();
        Object[] checked = this.fTree.getCheckedElements();
        int i = 0;
        while (i < checked.length) {
            FeatureLaunchModel model = (FeatureLaunchModel)checked[i];
            StringBuffer buffer = new StringBuffer();
            buffer.append(model.getId());
            buffer.append(':');
            buffer.append(model.getResolutionValue());
            featuresEntry.add(buffer.toString());
            ++i;
        }
        config.setAttribute("selected_features", featuresEntry);
    }

    private void saveSortOrder() {
        PDEPreferencesManager prefs = new PDEPreferencesManager("org.eclipse.pde.ui");
        Tree tree = this.fTree.getTree();
        TreeColumn column = tree.getSortColumn();
        int index = column == null ? 0 : (Integer)tree.getSortColumn().getData(COLUMN_ID);
        prefs.setValue("Preferences.RunConfigs.Feature.SortColumn", index + 1);
        int sortOrder = column == null ? 0 : tree.getSortDirection();
        prefs.setValue("Preferences.RunConfigs.Feature.SortOrder", sortOrder);
        prefs.savePluginPreferences();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("show_selected_only", false);
        config.setAttribute("featureDefaultLocation", "workspace");
        config.setAttribute("featurePluginResolution", "workspace");
        config.setAttribute("automaticValidate", false);
    }

    private void updateCounter() {
        if (this.fCounter != null) {
            int checked = this.fTree.getCheckedLeafCount();
            int total = this.fFeatureModels.values().size();
            this.fCounter.setText(NLS.bind((String)PDEUIMessages.AbstractPluginBlock_counter, (Object)new Integer(checked), (Object)new Integer(total)));
        }
    }

    protected void setInput(ILaunchConfiguration config, CheckboxTreeViewer tree) {
        HashMap<String, FeatureLaunchModel> featureModels = new HashMap<String, FeatureLaunchModel>();
        FeatureModelManager fmm = new FeatureModelManager();
        IFeatureModel[] workspaceModels = fmm.getWorkspaceModels();
        int i = 0;
        while (i < workspaceModels.length) {
            String id = workspaceModels[i].getFeature().getId();
            featureModels.put(id, new FeatureLaunchModel(workspaceModels[i], null));
            ++i;
        }
        fmm.shutdown();
        ExternalFeatureModelManager efmm = new ExternalFeatureModelManager();
        efmm.startup();
        IFeatureModel[] externalModels = efmm.getModels();
        int i2 = 0;
        while (i2 < externalModels.length) {
            String id = externalModels[i2].getFeature().getId();
            if (featureModels.containsKey(id)) {
                FeatureLaunchModel launchModel = (FeatureLaunchModel)featureModels.get(id);
                launchModel.setTargetModel(externalModels[i2]);
            } else {
                featureModels.put(id, new FeatureLaunchModel(null, externalModels[i2]));
            }
            ++i2;
        }
        efmm.shutdown();
        this.fFeatureModels = featureModels;
        tree.setInput(this.fFeatureModels.values());
        try {
            Set selected = config.getAttribute("selected_features", null);
            if (selected == null) {
                tree.setCheckedElements(this.fFeatureModels.values().toArray());
            } else {
                ArrayList<FeatureLaunchModel> selectedFeatureList = new ArrayList<FeatureLaunchModel>();
                Iterator iterator = selected.iterator();
                while (iterator.hasNext()) {
                    String id;
                    FeatureLaunchModel model;
                    String currentSelected = (String)iterator.next();
                    String[] attributes = currentSelected.split(":");
                    if (attributes.length <= 0 || (model = (FeatureLaunchModel)this.fFeatureModels.get(id = attributes[0])) == null) continue;
                    selectedFeatureList.add(model);
                    if (attributes.length <= 1) continue;
                    model.setPluginResolution(attributes[1]);
                }
                tree.setCheckedElements(selectedFeatureList.toArray());
            }
        }
        catch (CoreException e) {
            PDELaunchingPlugin.log((Throwable)e);
        }
        this.updateCounter();
    }

    class ButtonSelectionListener
    extends SelectionAdapter {
        ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == FeatureBlock.this.fSelectAllButton) {
                this.handleSelectAll(true);
            } else if (source == FeatureBlock.this.fDeselectAllButton) {
                this.handleSelectAll(false);
            } else if (source == FeatureBlock.this.fAddRequiredFeaturesButton) {
                this.handleAddRequired();
            } else if (source == FeatureBlock.this.fDefaultsButton) {
                this.handleRestoreDefaults();
            } else if (source == FeatureBlock.this.fValidateButton) {
                this.handleValidate();
            } else if (source instanceof TreeColumn) {
                this.handleColumn((TreeColumn)source, 0);
            }
            FeatureBlock.this.fTab.updateLaunchConfigurationDialog();
        }

        private void handleValidate() {
            if (FeatureBlock.this.fOperation == null) {
                FeatureBlock.this.fOperation = (LaunchValidationOperation)new EclipsePluginValidationOperation(FeatureBlock.this.fLaunchConfig);
            }
            try {
                FeatureBlock.this.fOperation.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
            if (FeatureBlock.this.fOperation.hasErrors()) {
                PluginStatusDialog dialog = new PluginStatusDialog(this.getShell(), 67696);
                dialog.setInput(FeatureBlock.this.fOperation.getInput());
                dialog.open();
                dialog = null;
            } else if (FeatureBlock.this.fOperation.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)NLS.bind((String)PDEUIMessages.AbstractLauncherToolbar_noSelection, (Object)FeatureBlock.this.fTab.getName().toLowerCase(Locale.ENGLISH)));
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noProblems);
            }
        }

        private Shell getShell() {
            try {
                Control c = FeatureBlock.this.fTab.getControl();
                if (!c.isDisposed()) {
                    return c.getShell();
                }
            }
            catch (SWTException sWTException) {}
            return PDEPlugin.getActiveWorkbenchShell();
        }

        private void handleAddRequired() {
            if (FeatureBlock.this.fTree.getCheckedElements() != null && FeatureBlock.this.fTree.getCheckedElements().length > 0) {
                Object[] features = FeatureBlock.this.fTree.getCheckedElements();
                HashSet<String> requiredFeatureIDs = new HashSet<String>();
                int i = 0;
                while (i < features.length) {
                    requiredFeatureIDs.add(((FeatureLaunchModel)features[i]).getId());
                    this.getFeatureDependencies(((FeatureLaunchModel)features[i]).getModel(FeatureBlock.this.fFeatureWorkspaceButton.getSelection()), requiredFeatureIDs);
                    ++i;
                }
                HashSet toCheck = new HashSet();
                Iterator iterator = requiredFeatureIDs.iterator();
                while (iterator.hasNext()) {
                    Object featureModel = FeatureBlock.this.fFeatureModels.get(iterator.next());
                    if (featureModel == null) continue;
                    toCheck.add(featureModel);
                }
                FeatureBlock.this.fTree.setCheckedElements(toCheck.toArray());
            }
        }

        private void getFeatureDependencies(IFeatureModel model, Set requiredFeatureIDs) {
            IFeature feature = model.getFeature();
            IFeatureImport[] featureImports = feature.getImports();
            int i = 0;
            while (i < featureImports.length) {
                if (featureImports[i].getType() == 1) {
                    this.addFeature(requiredFeatureIDs, featureImports[i].getId());
                }
                ++i;
            }
            IFeatureChild[] featureIncludes = feature.getIncludedFeatures();
            int i2 = 0;
            while (i2 < featureIncludes.length) {
                this.addFeature(requiredFeatureIDs, featureIncludes[i2].getId());
                ++i2;
            }
        }

        private void addFeature(Set requiredFeatureIDs, String id) {
            FeatureLaunchModel model;
            if (!requiredFeatureIDs.contains(id) && (model = (FeatureLaunchModel)FeatureBlock.this.fFeatureModels.get(id)) != null) {
                requiredFeatureIDs.add(id);
                this.getFeatureDependencies(model.getModel(FeatureBlock.this.fFeatureWorkspaceButton.getSelection()), requiredFeatureIDs);
            }
        }

        private void handleColumn(TreeColumn tc, int sortDirn) {
            Tree tree = FeatureBlock.this.fTree.getTree();
            tree.setSortColumn(tc);
            if (sortDirn == 0) {
                switch (tree.getSortDirection()) {
                    case 1024: {
                        sortDirn = 128;
                        break;
                    }
                    default: {
                        sortDirn = 1024;
                    }
                }
            }
            tree.setSortDirection(sortDirn);
            int sortOrder = sortDirn == 128 ? 1 : -1;
            int sortColumn = (Integer)tc.getData(FeatureBlock.COLUMN_ID);
            FeatureBlock.this.fTree.setSorter(new TreeSorter(sortColumn, sortOrder));
            FeatureBlock.this.saveSortOrder();
        }

        private void handleRestoreDefaults() {
            FeatureBlock.this.fWorkspacePluginButton.setSelection(true);
            FeatureBlock.this.fExternalPluginButton.setSelection(false);
            Iterator iterator = FeatureBlock.this.fFeatureModels.values().iterator();
            while (iterator.hasNext()) {
                FeatureLaunchModel model = (FeatureLaunchModel)iterator.next();
                model.setPluginResolution("default");
            }
            FeatureBlock.this.fTree.setAllChecked(true);
            FeatureBlock.this.fTree.refresh();
            FeatureBlock.this.updateCounter();
        }

        private void handleSelectAll(boolean state) {
            FeatureBlock.this.fTree.setAllChecked(state);
            FeatureBlock.this.updateCounter();
        }
    }

    class FeatureLaunchModel {
        public IFeatureModel fWorkspaceModel;
        public IFeatureModel fTargetModel;
        public String fPluginResolution;

        public FeatureLaunchModel(IFeatureModel workspaceModel, IFeatureModel targetModel) {
            this.fWorkspaceModel = workspaceModel;
            this.fTargetModel = targetModel;
            this.fPluginResolution = "default";
        }

        public void setWorkspaceModel(IFeatureModel workspaceModel) {
            this.fWorkspaceModel = workspaceModel;
        }

        public void setTargetModel(IFeatureModel targetModel) {
            this.fTargetModel = targetModel;
        }

        public void setPluginResolution(String resolution) {
            this.fPluginResolution = resolution;
        }

        public String getId() {
            if (this.fWorkspaceModel != null) {
                return this.fWorkspaceModel.getFeature().getId();
            }
            if (this.fTargetModel != null) {
                return this.fTargetModel.getFeature().getId();
            }
            return "";
        }

        public String getVersion() {
            if (this.fWorkspaceModel != null) {
                return this.fWorkspaceModel.getFeature().getVersion();
            }
            if (this.fTargetModel != null) {
                return this.fTargetModel.getFeature().getVersion();
            }
            return "";
        }

        public IFeatureModel getModel(boolean workspaceFirst) {
            if (this.fWorkspaceModel == null) {
                return this.fTargetModel;
            }
            if (this.fTargetModel == null) {
                return this.fWorkspaceModel;
            }
            if (workspaceFirst) {
                return this.fWorkspaceModel;
            }
            return this.fTargetModel;
        }

        public String getResolutionLabel() {
            if (this.fPluginResolution.equalsIgnoreCase("default")) {
                return PDEUIMessages.FeatureBlock_default;
            }
            if (this.fPluginResolution.equalsIgnoreCase("workspace")) {
                return PDEUIMessages.FeatureBlock_workspaceBefore;
            }
            if (this.fPluginResolution.equalsIgnoreCase("external")) {
                return PDEUIMessages.FeatureBlock_externalBefore;
            }
            return "";
        }

        public String getResolutionValue() {
            return this.fPluginResolution;
        }
    }

    class FeatureTreeLabelProvider
    extends StyledCellLabelProvider {
        PDELabelProvider pdeLabelProvider = new PDELabelProvider();

        FeatureTreeLabelProvider() {
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                FeatureLaunchModel model = (FeatureLaunchModel)obj;
                return this.pdeLabelProvider.getImage(model.getModel(true));
            }
            return null;
        }

        public String getColumnText(Object obj, int index) {
            FeatureLaunchModel model = (FeatureLaunchModel)obj;
            switch (index) {
                case 0: {
                    return model.getId();
                }
                case 1: {
                    return model.getResolutionLabel();
                }
            }
            return "";
        }

        public void update(ViewerCell cell) {
            switch (cell.getColumnIndex()) {
                case 0: {
                    StyledString label = this.getStyledText(cell.getElement());
                    cell.setStyleRanges(label.getStyleRanges());
                    cell.setText(label.toString());
                    cell.setImage(this.getColumnImage(cell.getElement(), 0));
                    break;
                }
                case 1: {
                    cell.setText(this.getColumnText(cell.getElement(), 1));
                }
            }
            super.update(cell);
        }

        private StyledString getStyledText(Object element) {
            FeatureLaunchModel model = (FeatureLaunchModel)element;
            StyledString styledString = new StyledString(this.getColumnText(element, 0));
            styledString.append(" (", StyledString.QUALIFIER_STYLER);
            String version = model.getVersion();
            int index = version.indexOf(45);
            if (index > -1) {
                version = version.substring(0, index);
            }
            styledString.append(version, StyledString.QUALIFIER_STYLER);
            styledString.append(")", StyledString.QUALIFIER_STYLER);
            return styledString;
        }
    }

    class LocationCellModifier
    implements ICellModifier {
        LocationCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return FeatureBlock.this.fTree.getChecked(element);
        }

        public Object getValue(Object element, String property) {
            if (property == FeatureBlock.PROPERTY_RESOLUTION) {
                String location = ((FeatureLaunchModel)element).getResolutionValue();
                if (location.equalsIgnoreCase("default")) {
                    return new Integer(0);
                }
                if (location.equalsIgnoreCase("workspace")) {
                    return new Integer(1);
                }
                if (location.equalsIgnoreCase("external")) {
                    return new Integer(2);
                }
            }
            return null;
        }

        public void modify(Object item, String property, Object value) {
            if (property == FeatureBlock.PROPERTY_RESOLUTION) {
                FeatureLaunchModel model = (FeatureLaunchModel)((TreeItem)item).getData();
                int comboIndex = (Integer)value;
                String location = null;
                switch (comboIndex) {
                    case 0: {
                        location = "default";
                        break;
                    }
                    case 1: {
                        location = "workspace";
                        break;
                    }
                    case 2: {
                        location = "external";
                    }
                }
                model.setPluginResolution(location);
                FeatureBlock.this.fTree.refresh(model, true);
                FeatureBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        }
    }

    class PluginContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof Collection) {
                return ((Collection)input).toArray();
            }
            if (input instanceof Object[]) {
                return (Object[])input;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class TreeSorter
    extends ViewerSorter {
        int sortColumn;
        int sortOrder;

        public TreeSorter(int sortColumn, int sortOrder) {
            this.sortColumn = sortColumn;
            this.sortOrder = sortOrder;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            FeatureTreeLabelProvider labelProvider = (FeatureTreeLabelProvider)FeatureBlock.this.fTree.getLabelProvider();
            return this.sortOrder * super.compare(viewer, (Object)labelProvider.getColumnText(e1, this.sortColumn), (Object)labelProvider.getColumnText(e2, this.sortColumn));
        }
    }
}

