/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.launcher.OSGiFrameworkManager;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class OSGiFrameworkBlock {
    private Combo fDefaultAutoStart;
    private Spinner fDefaultStartLevel;
    private IConfigurationElement[] fConfigElements;
    private Combo fLauncherCombo;
    private Listener fListener;
    private AbstractLauncherTab fTab;

    public OSGiFrameworkBlock(AbstractLauncherTab tab) {
        this.fTab = tab;
        this.fConfigElements = PDELaunchingPlugin.getDefault().getOSGiFrameworkManager().getSortedFrameworks();
        this.fListener = new Listener();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(6, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(PDEUIMessages.OSGiBundlesTab_frameworkLabel);
        gd = new GridData();
        gd.horizontalIndent = 5;
        label.setLayoutData((Object)gd);
        this.fLauncherCombo = new Combo(composite, 8);
        int i = 0;
        while (i < this.fConfigElements.length) {
            this.fLauncherCombo.add(this.fConfigElements[i].getAttribute("name"));
            ++i;
        }
        this.fLauncherCombo.addSelectionListener((SelectionListener)this.fListener);
        label = new Label(composite, 0);
        gd = new GridData();
        gd.horizontalIndent = 20;
        label.setLayoutData((Object)gd);
        label.setText(PDEUIMessages.EquinoxPluginsTab_defaultStart);
        this.fDefaultStartLevel = new Spinner(composite, 2048);
        this.fDefaultStartLevel.setMinimum(1);
        this.fDefaultStartLevel.addModifyListener((ModifyListener)this.fListener);
        label = new Label(composite, 0);
        gd = new GridData();
        gd.horizontalIndent = 20;
        label.setLayoutData((Object)gd);
        label.setText(PDEUIMessages.EquinoxPluginsTab_defaultAuto);
        this.fDefaultAutoStart = new Combo(composite, 2056);
        this.fDefaultAutoStart.setItems(new String[]{Boolean.toString(true), Boolean.toString(false)});
        this.fDefaultAutoStart.select(0);
        this.fDefaultAutoStart.addSelectionListener((SelectionListener)this.fListener);
        label = new Label(composite, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 6;
        label.setLayoutData((Object)gd);
    }

    public void initializeFrom(ILaunchConfiguration config) throws CoreException {
        this.initializeFramework(config);
        boolean auto = config.getAttribute("default_auto_start", true);
        this.fDefaultAutoStart.setText(Boolean.toString(auto));
        int level = config.getAttribute("default_start_level", 4);
        this.fDefaultStartLevel.setSelection(level);
    }

    private void initializeFramework(ILaunchConfiguration config) throws CoreException {
        OSGiFrameworkManager manager = PDELaunchingPlugin.getDefault().getOSGiFrameworkManager();
        String id = config.getAttribute("osgi_framework_id", manager.getDefaultFramework());
        int i = 0;
        while (i < this.fConfigElements.length) {
            if (id.equals(this.fConfigElements[i].getAttribute("id"))) {
                this.fLauncherCombo.select(i);
                return;
            }
            ++i;
        }
        if (this.fLauncherCombo.getItemCount() > 0) {
            this.fLauncherCombo.select(0);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("default_auto_start", Boolean.toString(true).equals(this.fDefaultAutoStart.getText()));
        config.setAttribute("default_start_level", this.fDefaultStartLevel.getSelection());
        int index = this.fLauncherCombo.getSelectionIndex();
        String id = index > -1 ? this.fConfigElements[index].getAttribute("id") : null;
        OSGiFrameworkManager manager = PDELaunchingPlugin.getDefault().getOSGiFrameworkManager();
        if (manager.getDefaultFramework().equals(id)) {
            id = null;
        }
        config.setAttribute("osgi_framework_id", id);
    }

    public int getDefaultStartLevel() {
        return this.fDefaultStartLevel.getSelection();
    }

    class Listener
    extends SelectionAdapter
    implements ModifyListener {
        Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            OSGiFrameworkBlock.this.fTab.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent e) {
            OSGiFrameworkBlock.this.fTab.updateLaunchConfigurationDialog();
        }
    }
}

