/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.catalog;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IDelegateCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IRewriteEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ISuffixEntry;
import org.eclipse.wst.xml.ui.internal.catalog.URIUtils;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogMessages;

public class XMLCatalogEntryDetailsView {
    protected Text detailsText;
    protected ScrollBar verticalScroll;
    protected ScrollBar horizontalScroll;

    public XMLCatalogEntryDetailsView(Composite parent) {
        Color color = parent.getDisplay().getSystemColor(25);
        this.detailsText = new Text(parent, 2818);
        GridData data = new GridData(1808);
        data.heightHint = 85;
        this.detailsText.setLayoutData((Object)data);
        this.verticalScroll = this.detailsText.getVerticalBar();
        this.horizontalScroll = this.detailsText.getHorizontalBar();
        this.detailsText.setEditable(false);
        this.detailsText.setBackground(color);
    }

    protected void setCatalogEntry(ICatalogEntry entry) {
        String line1;
        if (entry == null) {
            this.detailsText.setText("");
            return;
        }
        String value = this.getDisplayValue(entry.getURI());
        String line0 = String.valueOf(XMLCatalogMessages.UI_LABEL_ENTRY_ELEMENT_COLON) + "\t\t";
        String line2 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_URI_COLON) + "\t\t\t\t" + value;
        if (value.startsWith("jar:file:")) {
            String jarFile = URIUtils.convertURIToLocation(URIHelper.ensureURIProtocolFormat((String)value.substring("jar:".length(), value.indexOf(33))));
            String internalFile = URIUtils.convertURIToLocation(URIHelper.ensureURIProtocolFormat((String)("file://" + value.substring(value.indexOf(33) + 1))));
            line1 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_URI_LOCATION) + "\t\t\t" + internalFile + " " + XMLCatalogMessages.UI_LABEL_DETAILS_IN_JAR_FILE + " " + jarFile;
        } else {
            value = URIUtils.convertURIToLocation(value);
            line1 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_URI_LOCATION) + "\t\t\t" + value;
        }
        switch (entry.getEntryType()) {
            case 2: {
                line0 = String.valueOf(line0) + XMLCatalogMessages.UI_LABEL_PUBLIC;
                break;
            }
            case 3: {
                line0 = String.valueOf(line0) + XMLCatalogMessages.UI_LABEL_SYSTEM;
                break;
            }
            case 4: {
                line0 = String.valueOf(line0) + XMLCatalogMessages.UI_LABEL_URI;
            }
        }
        value = this.getKeyTypeValue(entry);
        String line3 = String.valueOf(XMLCatalogMessages.UI_KEY_TYPE_DETAILS_COLON) + "\t\t\t" + value;
        value = this.getDisplayValue(entry.getKey());
        String line4 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_KEY_COLON) + "\t\t\t\t" + value;
        String entireString = String.valueOf(line0) + "\n" + line1 + "\n" + line2 + "\n" + line3 + "\n" + line4;
        this.detailsText.setText(entireString);
    }

    protected void setNextCatalog(INextCatalog nextCatalog) {
        String value = this.getDisplayValue(nextCatalog != null ? nextCatalog.getCatalogLocation() : "");
        String line0 = String.valueOf(XMLCatalogMessages.UI_LABEL_ENTRY_ELEMENT_COLON) + "\t\t" + XMLCatalogMessages.UI_LABEL_NEXT_CATALOG;
        String line1 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_URI_LOCATION) + "\t\t\t" + URIUtils.convertURIToLocation(value);
        String line2 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_URI_COLON) + "\t\t\t\t" + value;
        String entireString = String.valueOf(line0) + "\n" + line1 + "\n" + line2;
        this.detailsText.setText(entireString);
    }

    protected void setSuffixEntry(ISuffixEntry element) {
        String value = this.getDisplayValue(element != null ? element.getURI() : "");
        String line0 = String.valueOf(XMLCatalogMessages.UI_LABEL_ENTRY_ELEMENT_COLON) + "\t\t" + XMLCatalogMessages.UI_LABEL_SUFFIX_ENTRY;
        String line1 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_SUFFIX_COLON) + "\t\t\t\t" + element.getSuffix();
        String line2 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_URI_LOCATION) + "\t\t\t" + URIUtils.convertURIToLocation(value);
        String line3 = String.valueOf(XMLCatalogMessages.UI_KEY_TYPE_DETAILS_COLON) + "\t\t\t";
        String uri = element.getURI();
        boolean isSchema = false;
        if (uri != null && uri.endsWith("xsd")) {
            isSchema = true;
        }
        switch (element.getEntryType()) {
            case 41: {
                line3 = String.valueOf(line3) + (isSchema ? XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_XSD_SYSTEM : XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_SYSTEM);
                break;
            }
            default: {
                line3 = String.valueOf(line3) + (isSchema ? XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_XSD_PUBLIC : XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI);
            }
        }
        String entireString = String.valueOf(line0) + "\n" + line1 + "\n" + line2 + "\n" + line3;
        this.detailsText.setText(entireString);
    }

    protected void setRewriteEntry(IRewriteEntry element) {
        String line0 = String.valueOf(XMLCatalogMessages.UI_LABEL_ENTRY_ELEMENT_COLON) + "\t\t" + XMLCatalogMessages.UI_LABEL_REWRITE_ENTRY;
        String line1 = String.valueOf(XMLCatalogMessages.UI_LABEL_START_STRING) + "\t\t" + element.getStartString();
        String line2 = String.valueOf(XMLCatalogMessages.UI_LABEL_REWRITE_PREFIX) + "\t" + element.getRewritePrefix();
        String line3 = String.valueOf(XMLCatalogMessages.UI_KEY_TYPE_DETAILS_COLON) + "\t\t\t";
        switch (element.getEntryType()) {
            case 21: {
                line3 = String.valueOf(line3) + XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_SYSTEM;
                break;
            }
            default: {
                line3 = String.valueOf(line3) + XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI;
            }
        }
        String entireString = String.valueOf(line0) + "\n" + line1 + "\n" + line2 + "\n" + line3;
        this.detailsText.setText(entireString);
    }

    protected void setDelegateCatalog(IDelegateCatalog element) {
        String value = this.getDisplayValue(element != null ? element.getCatalogLocation() : "");
        String line0 = String.valueOf(XMLCatalogMessages.UI_LABEL_ENTRY_ELEMENT_COLON) + "\t\t" + XMLCatalogMessages.UI_LABEL_DELEGATE_CATALOG;
        String line1 = String.valueOf(XMLCatalogMessages.UI_LABEL_START_STRING) + "\t\t" + element.getStartString();
        String line2 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_URI_LOCATION) + "\t\t\t" + URIUtils.convertURIToLocation(value);
        String line3 = String.valueOf(XMLCatalogMessages.UI_KEY_TYPE_DETAILS_COLON) + "\t\t\t";
        switch (element.getEntryType()) {
            case 31: {
                line3 = String.valueOf(line3) + XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_PUBLIC;
                break;
            }
            case 32: {
                line3 = String.valueOf(line3) + XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_SYSTEM;
                break;
            }
            default: {
                line3 = String.valueOf(line3) + XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI;
            }
        }
        String entireString = String.valueOf(line0) + "\n" + line1 + "\n" + line2 + "\n" + line3;
        this.detailsText.setText(entireString);
    }

    public void setCatalogElement(ICatalogElement element) {
        if (element instanceof ICatalogEntry) {
            this.setCatalogEntry((ICatalogEntry)element);
        } else if (element instanceof INextCatalog) {
            this.setNextCatalog((INextCatalog)element);
        } else if (element instanceof IDelegateCatalog) {
            this.setDelegateCatalog((IDelegateCatalog)element);
        } else if (element instanceof IRewriteEntry) {
            this.setRewriteEntry((IRewriteEntry)element);
        } else if (element instanceof ISuffixEntry) {
            this.setSuffixEntry((ISuffixEntry)element);
        } else {
            this.setCatalogEntry(null);
        }
    }

    protected String getDisplayValue(String string) {
        return string != null ? string : "";
    }

    protected String getKeyTypeValue(ICatalogEntry entry) {
        String result = null;
        if (entry.getURI() != null && entry.getURI().endsWith("xsd")) {
            result = entry.getEntryType() == 4 ? XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_XSD_PUBLIC : XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_XSD_SYSTEM;
        } else {
            switch (entry.getEntryType()) {
                case 2: {
                    result = XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_PUBLIC;
                    break;
                }
                case 3: {
                    result = XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_SYSTEM;
                    break;
                }
                default: {
                    result = XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI;
                }
            }
        }
        return result;
    }
}

