/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.VariableDeclarationFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class VariableDeclarationCleanUp
extends AbstractCleanUp {
    public VariableDeclarationCleanUp(Map options) {
        super(options);
    }

    public VariableDeclarationCleanUp() {
    }

    public boolean requireAST(IJavaScriptUnit unit) throws CoreException {
        boolean addFinal = this.isEnabled("cleanup.make_variable_declarations_final");
        if (!addFinal) {
            return false;
        }
        return this.isEnabled("cleanup.make_private_fields_final") || this.isEnabled("cleanup.make_parameters_final") || this.isEnabled("cleanup.make_local_variable_final");
    }

    public IFix createFix(JavaScriptUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean addFinal = this.isEnabled("cleanup.make_variable_declarations_final");
        if (!addFinal) {
            return null;
        }
        return VariableDeclarationFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.make_private_fields_final"), this.isEnabled("cleanup.make_parameters_final"), this.isEnabled("cleanup.make_local_variable_final"));
    }

    public IFix createFix(JavaScriptUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_private_fields_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalField_description);
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_parameters_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalParameters_description);
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalLocals_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        return buf.toString();
    }

    public boolean canFix(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }

    public int maximalNumberOfFixes(JavaScriptUnit compilationUnit) {
        return -1;
    }
}

