/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.PrintWriter;
import java.util.Date;

public abstract class CopyrightComment {
    public static final int UNKNOWN_COMMENT = -1;
    public static final int JAVA_COMMENT = 1;
    public static final int PROPERTIES_COMMENT = 2;
    public static final int C_COMMENT = 3;
    public static final int SHELL_MAKE_COMMENT = 4;
    public static final int BAT_COMMENT = 5;
    public static final int JAVASCRIPT_COMMENT = 6;
    public static final int XML_COMMENT = 7;
    private int commentStyle;
    private int creationYear = -1;
    private int revisionYear = -1;

    protected CopyrightComment(int commentStyle, int creationYear, int revisionYear) {
        this.commentStyle = commentStyle;
        this.creationYear = creationYear == -1 ? new Date().getYear() + 1900 : creationYear;
        this.revisionYear = revisionYear;
    }

    public static String getLinePrefix(int commentStyle) {
        switch (commentStyle) {
            case 1: 
            case 3: 
            case 6: {
                return " *";
            }
            case 2: {
                return "#";
            }
            case 4: {
                return "#";
            }
            case 5: {
                return "@rem";
            }
            case 7: {
                return "   ";
            }
        }
        return null;
    }

    protected void writeCommentStart(PrintWriter writer) {
        switch (this.commentStyle) {
            case 1: 
            case 3: 
            case 6: {
                writer.println("/*******************************************************************************");
                break;
            }
            case 2: {
                writer.println("###############################################################################");
                break;
            }
            case 4: {
                writer.println("#*******************************************************************************");
                break;
            }
            case 5: {
                writer.println("@rem ***************************************************************************");
                break;
            }
            case 7: {
                writer.println("<!--");
            }
        }
    }

    protected void writeCommentEnd(PrintWriter writer) {
        switch (this.commentStyle) {
            case 1: 
            case 3: 
            case 6: {
                writer.println(" *******************************************************************************/");
                break;
            }
            case 2: {
                writer.println("###############################################################################");
                break;
            }
            case 4: {
                writer.println("#*******************************************************************************");
                break;
            }
            case 5: {
                writer.println("@rem ***************************************************************************");
                break;
            }
            case 7: {
                writer.println(" -->");
            }
        }
    }

    public int getRevisionYear() {
        return this.revisionYear == -1 ? this.creationYear : this.revisionYear;
    }

    public boolean hasRevisionYear() {
        return this.revisionYear != -1;
    }

    public void setRevisionYear(int year) {
        if (this.revisionYear != -1 || this.creationYear != year) {
            this.revisionYear = year;
        }
    }

    public int getCreationYear() {
        return this.creationYear;
    }

    public String getCommentPrefix() {
        return CopyrightComment.getLinePrefix(this.commentStyle);
    }

    public abstract String getCopyrightComment();
}

