/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.releng.tools.BlockComment;
import org.eclipse.releng.tools.IBMCopyrightComment;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.SourceFile;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class FixCopyrightAction
implements IObjectActionDelegate {
    private String newLine = System.getProperty("line.separator");
    private Map log = new HashMap();
    private boolean swt = false;
    private String filterString;
    protected IStructuredSelection selection;
    private static final int currentYear = new GregorianCalendar().get(1);

    protected IFile[] getSelectedResources() {
        ArrayList<IFile> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<IFile>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object next = elements.next();
                IResource resource = (IResource)next;
                switch (resource.getType()) {
                    case 1: {
                        resources.add((IFile)resource);
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.addMembers((IContainer)resource, resources);
                    }
                }
            }
        }
        if (resources != null && !resources.isEmpty()) {
            IFile[] result = new IFile[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new IFile[0];
    }

    private void addMembers(IContainer container, List list) {
        try {
            IResource[] resources = container.members();
            int i = 0;
            int max = resources.length;
            while (i < max) {
                IResource resource = resources[i];
                switch (resource.getType()) {
                    case 2: 
                    case 4: {
                        this.addMembers((IContainer)resource, list);
                        break;
                    }
                    case 1: {
                        list.add((IFile)resource);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.log = new HashMap();
        try {
            final String[] filterArray = new String[1];
            Dialog filterCriteria = new Dialog((IShellProvider)PlatformUI.getWorkbench().getActiveWorkbenchWindow()){
                Text text;

                protected void configureShell(Shell newShell) {
                    super.configureShell(newShell);
                    newShell.setText(Messages.getString("CopyrightDialog.1"));
                }

                protected Control createDialogArea(Composite parent) {
                    Composite parentComposite = (Composite)super.createDialogArea(parent);
                    Composite composite = new Composite(parentComposite, 0);
                    composite.setLayoutData((Object)new GridData(4, 4, true, true));
                    composite.setLayout((Layout)new GridLayout(2, false));
                    Label label = new Label(composite, 0);
                    label.setText(Messages.getString("CopyrightDialog.2"));
                    this.text = new Text(composite, 2052);
                    this.text.setText("copyright");
                    this.text.setLayoutData((Object)new GridData(4, 4, true, false));
                    Label header = new Label(composite, 64);
                    header.setText(Messages.getString("CopyrightDialog.3"));
                    GridData gridData = new GridData(4, 4, true, false);
                    gridData.horizontalSpan = 2;
                    header.setLayoutData((Object)gridData);
                    return parentComposite;
                }

                protected void okPressed() {
                    filterArray[0] = this.text.getText();
                    super.okPressed();
                }
            };
            filterCriteria.setBlockOnOpen(true);
            int result = filterCriteria.open();
            if (result == 1) {
                return;
            }
            if (!filterArray[0].trim().equals("")) {
                this.filterString = filterArray[0];
            }
            IFile[] results = this.getSelectedResources();
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation((IResource[])results){
                private final /* synthetic */ IResource[] val$results;
                {
                    this.val$results = iResourceArray;
                }

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    try {
                        IProject project;
                        monitor.beginTask("Fixing copyrights...", this.val$results.length);
                        System.out.println("Start Fixing Copyrights");
                        System.out.println("Resources selected: " + this.val$results.length);
                        if (this.val$results.length > 0 && (project = this.val$results[0].getProject()).getName().equals("org.eclipse.swt")) {
                            FixCopyrightAction.this.swt = true;
                        }
                        int i = 0;
                        while (i < this.val$results.length) {
                            IResource resource = this.val$results[i];
                            System.out.println("Resource selected: " + resource.getFullPath());
                            FixCopyrightAction.this.processFile((IFile)resource, monitor);
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                monitor.setCanceled(true);
                                break;
                            }
                            ++i;
                        }
                        FixCopyrightAction.this.writeLogs();
                        if (FixCopyrightAction.this.swt) {
                            FixCopyrightAction.this.displayLogs();
                        }
                        System.out.println("Done Fixing Copyrights");
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getCVSModificationYear(IFile file, IProgressMonitor monitor) {
        try {
            String logComment;
            ILogEntry entry;
            monitor.beginTask("Fetching logs from CVS", 100);
            try {
                ICVSRemoteResource cvsFile = CVSWorkspaceRoot.getRemoteResourceFor((IResource)file);
                if (cvsFile == null) return -1;
                entry = ((ICVSRemoteFile)cvsFile).getLogEntry((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                logComment = entry.getComment();
                if (this.swt && logComment.indexOf("CPL") != -1 && logComment.indexOf("EPL") != -1) {
                    return 0;
                }
            }
            catch (TeamException teamException) {
                return -1;
            }
            if (this.filterString != null && logComment.indexOf(this.filterString) != -1) {
                return 0;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(entry.getDate());
            int n = calendar.get(1);
            return n;
        }
        finally {
            monitor.done();
        }
    }

    private void writeLogs() {
        try {
            File aFile = new File(Platform.getLocation().toFile(), "copyrightLog.txt");
            FileOutputStream aStream = new FileOutputStream(aFile);
            Set aSet = this.log.entrySet();
            Iterator errorIterator = aSet.iterator();
            while (errorIterator.hasNext()) {
                Map.Entry anEntry = errorIterator.next();
                String errorDescription = (String)anEntry.getKey();
                aStream.write(errorDescription.getBytes());
                aStream.write(this.newLine.getBytes());
                List fileList = (List)anEntry.getValue();
                Iterator listIterator = fileList.iterator();
                while (listIterator.hasNext()) {
                    String fileName = (String)listIterator.next();
                    aStream.write("     ".getBytes());
                    aStream.write(fileName.getBytes());
                    aStream.write(this.newLine.getBytes());
                }
            }
            aStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void displayLogs() {
        Set aSet = this.log.entrySet();
        Iterator errorIterator = aSet.iterator();
        while (errorIterator.hasNext()) {
            Map.Entry anEntry = errorIterator.next();
            String errorDescription = (String)anEntry.getKey();
            System.out.println(errorDescription);
            List fileList = (List)anEntry.getValue();
            Iterator listIterator = fileList.iterator();
            while (listIterator.hasNext()) {
                String fileName = (String)listIterator.next();
                System.out.println("     " + fileName);
            }
        }
    }

    private void processFile(IFile file, IProgressMonitor monitor) {
        IBMCopyrightComment ibmCopyright;
        String extension = file.getFileExtension();
        if (extension == null) {
            this.warn(file, null, "File has no extension.  File UNCHANGED.");
            return;
        }
        monitor.subTask(file.getFullPath().toOSString());
        SourceFile aSourceFile = SourceFile.createFor(file);
        if (aSourceFile == null) {
            return;
        }
        if (aSourceFile.hasMultipleCopyrights()) {
            this.warn(file, null, "Multiple copyrights found.  File UNCHANGED.");
            return;
        }
        boolean hasCPL = false;
        boolean hasGPL = false;
        boolean hasMPL = false;
        boolean hasApple = false;
        BlockComment copyrightComment = aSourceFile.firstCopyrightComment();
        if (copyrightComment != null) {
            String copyrightString = copyrightComment.getContents();
            if (copyrightString.indexOf("Common Public License") != -1) {
                hasCPL = true;
            }
            if (this.swt) {
                if (copyrightString.indexOf("GPL") != -1) {
                    hasGPL = true;
                }
                if (copyrightString.indexOf("MPL") != -1) {
                    hasMPL = true;
                }
                if (copyrightString.indexOf("Apple Computer") != -1) {
                    hasApple = true;
                }
            }
        }
        if ((ibmCopyright = IBMCopyrightComment.parse(copyrightComment, aSourceFile.getFileType())) == null) {
            this.warn(file, copyrightComment, "Could not interpret copyright comment.  File UNCHANGED.");
            return;
        }
        int revised = ibmCopyright.getRevisionYear();
        int lastMod = revised;
        if (lastMod < currentYear) {
            lastMod = this.getCVSModificationYear(file, (IProgressMonitor)new NullProgressMonitor());
        }
        if (lastMod <= revised && !hasCPL) {
            return;
        }
        ibmCopyright.setRevisionYear(lastMod);
        if (copyrightComment == null) {
            aSourceFile.insert(ibmCopyright.getCopyrightComment());
        } else {
            if (!copyrightComment.atTop()) {
                this.warn(file, copyrightComment, "Old copyright not at start of file, new copyright replaces old in same location.");
            }
            if (hasGPL || hasMPL || hasApple) {
                this.warn(file, copyrightComment, "Old copyright contains GPL, MPL, or Apple. Copyright unchanged. Date updated if necessary.");
                aSourceFile.replace(copyrightComment, ibmCopyright.getOriginalCopyrightComment());
            } else {
                aSourceFile.replace(copyrightComment, ibmCopyright.getCopyrightComment());
            }
        }
    }

    private void warn(IFile file, BlockComment firstBlockComment, String errorDescription) {
        ArrayList<String> aList = (ArrayList<String>)this.log.get(errorDescription);
        if (aList == null) {
            aList = new ArrayList<String>();
            this.log.put(errorDescription, aList);
        }
        aList.add(file.getFullPath().toOSString());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public class MyInnerClass
    implements IResourceVisitor {
        public IProgressMonitor monitor;

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1) {
                FixCopyrightAction.this.processFile((IFile)resource, this.monitor);
            }
            return true;
        }
    }
}

