/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.releng.tools.BlockComment;
import org.eclipse.releng.tools.CopyrightComment;

public class IBMCopyrightComment
extends CopyrightComment {
    private static final int DEFAULT_CREATION_YEAR = 2005;
    private List contributors;
    private int yearRangeStart;
    private int yearRangeEnd;
    private String originalText;

    private IBMCopyrightComment(int commentStyle, int creationYear, int revisionYear, List contributors, int yearRangeStart, int yearRangeEnd, String originalText) {
        super(commentStyle, creationYear == -1 ? 2005 : creationYear, revisionYear);
        this.contributors = contributors;
        this.yearRangeStart = yearRangeStart;
        this.yearRangeEnd = yearRangeEnd;
        this.originalText = originalText;
    }

    public static IBMCopyrightComment defaultComment(int commentStyle) {
        return new IBMCopyrightComment(commentStyle, 2005, -1, null, 0, 0, null);
    }

    public static IBMCopyrightComment parse(BlockComment comment, int commentStyle) {
        String startStr;
        if (comment == null) {
            return IBMCopyrightComment.defaultComment(commentStyle);
        }
        String body = comment.getContents();
        int start = body.indexOf("Copyright (c) ");
        if (start == -1) {
            return null;
        }
        int contrib = body.indexOf("Contributors:", start);
        int rangeEnd = body.indexOf(" IBM Corp", start);
        if (rangeEnd == -1 || rangeEnd > contrib) {
            return null;
        }
        int rangeStart = start + "Copyright (c) ".length();
        String yearRange = body.substring(rangeStart, rangeEnd);
        int comma = yearRange.indexOf(",");
        if (comma == -1) {
            comma = yearRange.indexOf("-");
        }
        String string = startStr = comma == -1 ? yearRange : yearRange.substring(0, comma);
        if (comma != -1 && Character.isWhitespace(yearRange.charAt(comma))) {
            ++comma;
        }
        String endStr = comma == -1 ? null : yearRange.substring(comma + 1);
        int startYear = -1;
        if (startStr != null) {
            try {
                startYear = Integer.parseInt(startStr.trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int endYear = -1;
        if (endStr != null) {
            try {
                endYear = Integer.parseInt(endStr.trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String contribComment = body.substring(contrib);
        StringTokenizer tokens = new StringTokenizer(contribComment, "\r\n");
        tokens.nextToken();
        ArrayList<String> contributors = new ArrayList<String>();
        String linePrefix = IBMCopyrightComment.getLinePrefix(commentStyle);
        while (tokens.hasMoreTokens()) {
            String contributor = tokens.nextToken();
            if (contributor.indexOf("***********************************") != -1 || contributor.indexOf("###################################") != -1) continue;
            int c = contributor.indexOf(linePrefix);
            if (c == -1 && linePrefix.equals(" *")) {
                c = contributor.indexOf("*");
            }
            if (c == 0) {
                contributor = contributor.substring(c + linePrefix.length());
            }
            contributors.add(contributor);
        }
        return new IBMCopyrightComment(commentStyle, startYear, endYear, contributors, rangeStart, rangeEnd, body);
    }

    public String getCopyrightComment() {
        String linePrefix = this.getCommentPrefix();
        if (linePrefix == null) {
            return null;
        }
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        try {
            this.writeCommentStart(writer);
            this.writeLegal(writer, linePrefix);
            this.writeContributions(writer, linePrefix);
            this.writeCommentEnd(writer);
            String string = out.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    public String getOriginalCopyrightComment() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        try {
            writer.print(this.originalText.substring(0, this.yearRangeStart));
            writer.print(this.getCreationYear());
            if (this.hasRevisionYear() && this.getRevisionYear() != this.getCreationYear()) {
                writer.print(", " + this.getRevisionYear());
            }
            writer.print(this.originalText.substring(this.yearRangeEnd));
            String string = out.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    private void writeLegal(PrintWriter writer, String linePrefix) {
        writer.print(String.valueOf(linePrefix) + " Copyright (c) " + this.getCreationYear());
        if (this.hasRevisionYear() && this.getRevisionYear() != this.getCreationYear()) {
            writer.print(", " + this.getRevisionYear());
        }
        writer.println(" IBM Corporation and others.");
        writer.println(String.valueOf(linePrefix) + " All rights reserved. This program and the accompanying materials");
        writer.println(String.valueOf(linePrefix) + " are made available under the terms of the Eclipse Public License v1.0");
        writer.println(String.valueOf(linePrefix) + " which accompanies this distribution, and is available at");
        writer.println(String.valueOf(linePrefix) + " http://www.eclipse.org/legal/epl-v10.html");
    }

    private void writeContributions(PrintWriter writer, String linePrefix) {
        writer.println(linePrefix);
        writer.println(String.valueOf(linePrefix) + " Contributors:");
        if (this.contributors == null || this.contributors.size() <= 0) {
            writer.println(String.valueOf(linePrefix) + "     IBM Corporation - initial API and implementation");
        } else {
            Iterator i = this.contributors.iterator();
            while (i.hasNext()) {
                String contributor = (String)i.next();
                if (contributor.length() > 0) {
                    if (Character.isWhitespace(contributor.charAt(0))) {
                        writer.println(String.valueOf(linePrefix) + contributor);
                        continue;
                    }
                    writer.println(String.valueOf(linePrefix) + " " + contributor);
                    continue;
                }
                writer.println(linePrefix);
            }
        }
    }
}

