/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OrderedMap {
    private List keys = new ArrayList();
    private List values = new ArrayList();

    public void clear() {
        this.keys = new ArrayList();
        this.values = new ArrayList();
    }

    public boolean containsKey(Object key) {
        Iterator iter = this.keys.iterator();
        while (iter.hasNext()) {
            if (!key.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Iterator iter = this.values.iterator();
        while (iter.hasNext()) {
            if (!value.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        int index = this.indexOf(key);
        return index == -1 ? null : this.values.get(index);
    }

    private int indexOf(Object key) {
        int length = this.keys.size();
        int i = 0;
        while (i < length) {
            Object tempKey = this.keys.get(i);
            if (key.equals(tempKey)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.keys.size() == 0;
    }

    public Object put(Object key, Object value) {
        int index = this.indexOf(key);
        if (index == -1) {
            this.keys.add(key);
            this.values.add(value);
            return null;
        }
        Object oldValue = this.values.get(index);
        this.values.set(index, value);
        return oldValue;
    }

    public void putAll(Map other) {
        Iterator iter = other.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry key = iter.next();
            this.put(key, other.get(key));
        }
    }

    public Object remove(Object key) {
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        this.keys.remove(index);
        return this.values.remove(index);
    }

    public int size() {
        return this.keys.size();
    }

    public Collection values() {
        return this.values;
    }

    public Collection keys() {
        return this.keys;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        Iterator iter = this.keys().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = this.get(key);
            result.append(key);
            result.append('=');
            result.append(value);
            result.append(",\n");
        }
        if (result.length() > 2) {
            result = result.deleteCharAt(result.length() - 1);
            result = result.deleteCharAt(result.length() - 1);
        }
        result.append("}");
        return result.toString();
    }
}

