/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.releng.tools.Messages;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RelEngPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.releng.tools";
    public static final String MAP_PROJECT_NAME = Messages.getString("RelEngPlugin.1");
    public static final String MAP_FOLDER = Messages.getString("RelEngPlugin.2");
    private static RelEngPlugin plugin;
    private ResourceBundle resourceBundle;

    public RelEngPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(ID + Messages.getString("RelEngPlugin.3"));
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static RelEngPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = RelEngPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void log(CoreException e) {
        RelEngPlugin.log(e.getStatus().getSeverity(), e.getMessage(), e);
    }

    public static void log(int severity, String message, Throwable e) {
        RelEngPlugin.log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public static void log(IStatus status) {
        RelEngPlugin.getPlugin().getLog().log(status);
    }

    public static RelEngPlugin getPlugin() {
        while (plugin == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return plugin;
    }
}

