/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.eclipse.equinox.http.servlet.internal.DefaultHttpContext;
import org.eclipse.equinox.http.servlet.internal.ProxyServlet;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpServiceImpl
implements HttpService,
ExtendedHttpService {
    private Bundle bundle;
    private ProxyServlet proxy;
    private Set aliases = new HashSet();
    private Set filters = new HashSet();
    private boolean shutdown = false;

    public HttpServiceImpl(Bundle bundle, ProxyServlet proxy) {
        this.bundle = bundle;
        this.proxy = proxy;
    }

    synchronized void shutdown() {
        Iterator it = this.aliases.iterator();
        while (it.hasNext()) {
            String alias = (String)it.next();
            this.proxy.unregister(alias, false);
        }
        this.aliases.clear();
        it = this.filters.iterator();
        while (it.hasNext()) {
            Filter filter = (Filter)it.next();
            this.proxy.unregisterFilter(filter, false);
        }
        this.filters.clear();
        this.shutdown = true;
    }

    private void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("Service instance is already shutdown");
        }
    }

    public synchronized void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext context) throws ServletException, NamespaceException {
        this.checkShutdown();
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        this.proxy.registerServlet(alias, servlet, initparams, context);
        this.aliases.add(alias);
    }

    public synchronized void registerResources(String alias, String name, HttpContext context) throws NamespaceException {
        this.checkShutdown();
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        this.proxy.registerResources(alias, name, context);
        this.aliases.add(alias);
    }

    public synchronized void unregister(String alias) {
        this.checkShutdown();
        if (!this.aliases.remove(alias)) {
            throw new IllegalArgumentException("Alias not found.");
        }
        this.proxy.unregister(alias, true);
    }

    public synchronized HttpContext createDefaultHttpContext() {
        this.checkShutdown();
        return new DefaultHttpContext(this.bundle);
    }

    public void registerFilter(String alias, Filter filter, Dictionary initparams, HttpContext context) throws ServletException {
        this.checkShutdown();
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        this.proxy.registerFilter(alias, filter, initparams, context);
        this.filters.add(filter);
    }

    public void unregisterFilter(Filter filter) {
        this.checkShutdown();
        if (!this.filters.remove(filter)) {
            throw new IllegalArgumentException("Filter not found.");
        }
        this.proxy.unregisterFilter(filter, true);
    }
}

