/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.property.list.IListProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VirtualEntry<M> {
    private int id;
    private Object originalParent;
    private String label;
    private IObservableList list;

    public VirtualEntry(int id, IListProperty property, Object originalParent, String label) {
        this.id = id;
        this.originalParent = originalParent;
        this.label = label;
        this.list = new WritableList();
        IObservableList origList = property.observe(originalParent);
        this.list.addAll(this.cleanedList(origList));
        origList.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                List clean = VirtualEntry.this.cleanedList(event.getObservableList());
                ListDiff diff = Diffs.computeListDiff((List)VirtualEntry.this.list, (List)clean);
                diff.applyTo((List)VirtualEntry.this.list);
            }
        });
    }

    private List<Object> cleanedList(IObservableList list) {
        ArrayList<Object> l = new ArrayList<Object>(list.size());
        for (Object o : list) {
            if (!this.accepted(o)) continue;
            l.add(o);
        }
        return l;
    }

    protected abstract boolean accepted(M var1);

    public IObservableList getList() {
        return this.list;
    }

    public Object getOriginalParent() {
        return this.originalParent;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.label;
    }
}

