/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.ant.internal.launching.AntCoreModelMessages;
import org.eclipse.ant.internal.launching.AntLaunch;
import org.eclipse.ant.internal.launching.AntLaunching;
import org.eclipse.ant.internal.launching.launchConfigurations.AntHomeClasspathEntry;
import org.eclipse.ant.internal.launching.launchConfigurations.AntProcess;
import org.eclipse.ant.internal.launching.launchConfigurations.RemoteAntRuntimeProcess;
import org.eclipse.core.externaltools.internal.model.ExternalToolBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.JavaRuntime;

public final class AntLaunchingUtil {
    public static final String ATTRIBUTE_SEPARATOR = ",";
    public static final char ANT_CLASSPATH_DELIMITER = '*';
    public static final String ANT_HOME_CLASSPATH_PLACEHOLDER = "G";
    public static final String ANT_GLOBAL_USER_CLASSPATH_PLACEHOLDER = "UG";

    private AntLaunchingUtil() {
    }

    public static String combineStrings(String[] strings) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < strings.length - 1) {
            buf.append(strings[i]);
            buf.append(ATTRIBUTE_SEPARATOR);
            ++i;
        }
        buf.append(strings[strings.length - 1]);
        return buf.toString();
    }

    public static String[] getTargetNames(ILaunchConfiguration configuration) throws CoreException {
        String attribute = null;
        if ("org.eclipse.ant.AntBuilderLaunchConfigurationType".equals(configuration.getType().getIdentifier())) {
            attribute = AntLaunchingUtil.getTargetNamesForAntBuilder(configuration);
        }
        if (attribute == null && (attribute = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null)) == null) {
            return null;
        }
        return AntLaunchingUtil.parseRunTargets(attribute);
    }

    private static String getTargetNamesForAntBuilder(ILaunchConfiguration configuration) throws CoreException {
        String buildType = ExternalToolBuilder.getBuildType();
        String targets = null;
        if ("auto".equals(buildType)) {
            targets = configuration.getAttribute("org.eclipse.ant.ui.ATTR_ANT_AUTO_TARGETS", null);
        } else if ("clean".equals(buildType)) {
            targets = configuration.getAttribute("org.eclipse.ant.ui.ATTR_ANT_CLEAN_TARGETS", null);
        } else if ("full".equals(buildType)) {
            targets = configuration.getAttribute("org.eclipse.ant.ui.ATTR_ANT_AFTER_CLEAN_TARGETS", null);
        } else if ("incremental".equals(buildType)) {
            targets = configuration.getAttribute("org.eclipse.ant.ui.ATTR_ANT_MANUAL_TARGETS", null);
        }
        return targets;
    }

    public static Map getProperties(ILaunchConfiguration configuration) throws CoreException {
        Map map = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", null);
        return map;
    }

    public static String getAntHome(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry2 entry2;
            IRuntimeClasspathEntry entry = entries[i];
            if (entry.getType() == 5 && (entry2 = (IRuntimeClasspathEntry2)entry).getTypeId().equals("org.eclipse.ant.ui.classpathentry.antHome")) {
                return ((AntHomeClasspathEntry)entry2).getAntHome();
            }
            ++i;
        }
        return null;
    }

    public static String[] getPropertyFiles(ILaunchConfiguration configuration) throws CoreException {
        String attribute = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", null);
        if (attribute == null) {
            return null;
        }
        String[] propertyFiles = AntLaunchingUtil.parseString(attribute, ATTRIBUTE_SEPARATOR);
        int i = 0;
        while (i < propertyFiles.length) {
            String propertyFile = propertyFiles[i];
            propertyFiles[i] = propertyFile = AntLaunchingUtil.expandVariableString(propertyFile, AntCoreModelMessages.AntUtil_6);
            ++i;
        }
        return propertyFiles;
    }

    public static URL[] getCustomClasspath(ILaunchConfiguration config) throws CoreException {
        boolean useDefault = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        if (useDefault) {
            return null;
        }
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)config);
        ArrayList<IRuntimeClasspathEntry> userEntries = new ArrayList<IRuntimeClasspathEntry>(unresolved.length);
        int i = 0;
        while (i < unresolved.length) {
            IRuntimeClasspathEntry entry = unresolved[i];
            if (entry.getClasspathProperty() == 3) {
                userEntries.add(entry);
            }
            ++i;
        }
        IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])userEntries.toArray(new IRuntimeClasspathEntry[userEntries.size()]), (ILaunchConfiguration)config);
        URL[] urls = new URL[entries.length];
        int i2 = 0;
        while (i2 < entries.length) {
            IRuntimeClasspathEntry entry = entries[i2];
            try {
                urls[i2] = new URL("file:" + entry.getLocation());
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, AntLaunching.getUniqueIdentifier(), 120, AntCoreModelMessages.AntUtil_7, (Throwable)e));
            }
            ++i2;
        }
        return urls;
    }

    private static String expandVariableString(String variableString, String invalidMessage) throws CoreException {
        String expandedString = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(variableString);
        if (expandedString == null || expandedString.length() == 0) {
            String msg = MessageFormat.format((String)invalidMessage, (Object[])new String[]{variableString});
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ant.launching", 0, msg, null));
        }
        return expandedString;
    }

    public static String[] parseRunTargets(String extraAttibuteValue) {
        return AntLaunchingUtil.parseString(extraAttibuteValue, ATTRIBUTE_SEPARATOR);
    }

    public static String[] parseString(String delimString, String delim) {
        if (delimString == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(delimString, delim);
        String[] results = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < results.length) {
            results[i] = tokenizer.nextToken().trim();
            ++i;
        }
        return results;
    }

    public static IFile getFile(String fullPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getFile((IPath)new Path(fullPath));
    }

    public static IFile getFileForLocation(String path, File buildFileParent) {
        IFile[] files;
        IFile file;
        block11: {
            if (path == null) {
                return null;
            }
            Path filePath = new Path(path);
            file = null;
            files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
            if (files.length > 0) {
                file = files[0];
            }
            if (file == null) {
                File relativeFile = null;
                try {
                    relativeFile = FileUtils.getFileUtils().resolveFile(buildFileParent, path);
                    filePath = new Path(relativeFile.getAbsolutePath());
                    files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
                    if (files.length > 0) {
                        file = files[0];
                        break block11;
                    }
                    return null;
                }
                catch (BuildException buildException) {
                    return null;
                }
            }
        }
        if (file.exists()) {
            return file;
        }
        File ioFile = file.getLocation().toFile();
        if (ioFile.exists()) {
            try {
                files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(ioFile.getCanonicalPath()));
                if (files.length > 0) {
                    return files[0];
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static void migrateToNewClasspathFormat(ILaunchConfiguration configuration) throws CoreException {
        String oldClasspath = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
        String oldAntHome = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", null);
        String provider = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, null);
        if (oldClasspath != null || oldAntHome != null || provider == null) {
            ILaunchConfigurationWorkingCopy workingCopy = null;
            workingCopy = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", null);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            if (oldAntHome != null) {
                IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)workingCopy);
                ArrayList<String> mementos = new ArrayList<String>(entries.length);
                int i = 0;
                while (i < entries.length) {
                    IRuntimeClasspathEntry2 entry2;
                    IRuntimeClasspathEntry entry = entries[i];
                    if (entry.getType() == 5 && (entry2 = (IRuntimeClasspathEntry2)entry).getTypeId().equals("org.eclipse.ant.ui.classpathentry.antHome")) {
                        AntHomeClasspathEntry homeEntry = new AntHomeClasspathEntry(oldAntHome);
                        mementos.add(homeEntry.getMemento());
                    } else {
                        mementos.add(entry.getMemento());
                    }
                    ++i;
                }
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
            }
            workingCopy.doSave();
        }
    }

    public static boolean isSeparateJREAntBuild(ILaunchConfiguration configuration) {
        boolean separateJRE = true;
        try {
            separateJRE = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null) != null;
        }
        catch (CoreException e) {
            AntLaunching.log(AntCoreModelMessages.AntUtil_2, e);
        }
        return separateJRE;
    }

    public static void linkBuildFailedMessage(String message, IProcess process) {
        String fileName = null;
        String lineNumber = "";
        int fileStart = 0;
        int index = message.indexOf("xml");
        if (index > 0) {
            int numberStart = index + 4;
            int numberEnd = message.indexOf(58, numberStart);
            int fileEnd = index + 3;
            if (numberStart > 0 && fileEnd > 0) {
                fileName = message.substring(fileStart, fileEnd).trim();
                if (numberEnd > 0) {
                    lineNumber = message.substring(numberStart, numberEnd).trim();
                }
            }
        }
        if (fileName != null) {
            int num = -1;
            try {
                num = Integer.parseInt(lineNumber);
            }
            catch (NumberFormatException numberFormatException) {}
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(fileName));
            IFile file = null;
            if (files.length > 0) {
                file = files[0];
            }
            if (file != null && file.exists() && process != null) {
                ILaunch launch = null;
                if (process instanceof RemoteAntRuntimeProcess) {
                    launch = ((RemoteAntRuntimeProcess)process).getLaunch();
                } else if (process instanceof AntProcess) {
                    launch = ((AntProcess)process).getLaunch();
                }
                if (launch != null) {
                    ((AntLaunch)launch).addLinkDescriptor(message, fileName, num, 0, message.length());
                }
            }
        }
    }
}

