/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StructuredViewerInternals;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;

public class StructuredViewerManager {
    private StructuredViewer viewer;
    private Object cachedOldInput;
    private Object cachedNewInput;
    private Map viewerDataMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(Object element) {
        Map map = this.viewerDataMap;
        synchronized (map) {
            return this.viewerDataMap.get(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetViewerData() {
        Map map = this.viewerDataMap;
        synchronized (map) {
            if (Policy.DEBUG_VIEWER_MAP) {
                System.out.println("viewer map RESET");
            }
            this.viewerDataMap.clear();
        }
    }

    public StructuredViewerManager(StructuredViewer aViewer, NavigatorContentService contentService) {
        this.viewer = aViewer;
        this.viewerDataMap = new HashMap();
        StructuredViewerAccess.hookAssociateListener(this.viewer, this.viewerDataMap, contentService);
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(Object anOldInput, Object aNewInput) {
        this.cachedOldInput = anOldInput;
        this.cachedNewInput = aNewInput;
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = (StructuredViewer)aViewer;
        this.cachedOldInput = anOldInput;
        this.cachedNewInput = aNewInput;
    }

    public boolean initialize(IStructuredContentProvider aContentProvider) {
        boolean result = true;
        try {
            if (aContentProvider != null) {
                aContentProvider.inputChanged((Viewer)this.viewer, this.cachedOldInput, this.cachedNewInput);
            }
        }
        catch (RuntimeException e) {
            NavigatorPlugin.logError(0, e.toString(), e);
            result = false;
        }
        return result;
    }

    public void safeRefresh() {
        StructuredViewer localViewer = this.viewer;
        if (localViewer == null || localViewer.getControl().isDisposed()) {
            return;
        }
        Display display = localViewer.getControl().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.syncExec(new Runnable((Viewer)localViewer){
            private final /* synthetic */ Viewer val$localViewer;
            {
                this.val$localViewer = viewer;
            }

            public void run() {
                if (this.val$localViewer.getControl().isDisposed()) {
                    return;
                }
                try {
                    try {
                        this.val$localViewer.getControl().setRedraw(false);
                        this.val$localViewer.refresh();
                    }
                    catch (RuntimeException e) {
                        NavigatorPlugin.logError(0, e.toString(), e);
                        this.val$localViewer.getControl().setRedraw(true);
                    }
                }
                finally {
                    this.val$localViewer.getControl().setRedraw(true);
                }
            }
        });
    }

    static class StructuredViewerAccess
    extends StructuredViewerInternals {
        StructuredViewerAccess() {
        }

        protected static void hookAssociateListener(StructuredViewer v, Map viewerDataMap, NavigatorContentService contentService) {
            StructuredViewerInternals.setAssociateListener((StructuredViewer)v, (StructuredViewerInternals.AssociateListener)new Listener(contentService, viewerDataMap));
        }

        static class Listener
        implements StructuredViewerInternals.AssociateListener {
            private final NavigatorContentService contentService;
            private final Map viewerDataMap;

            public Listener(NavigatorContentService contentService, Map viewerDataMap) {
                this.contentService = contentService;
                this.viewerDataMap = viewerDataMap;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void associate(Object element, Item item) {
                NavigatorContentDescriptor desc = this.contentService.getContribution(element);
                this.contentService.forgetContribution(element);
                Map map = this.viewerDataMap;
                synchronized (map) {
                    if (this.viewerDataMap.containsKey(element)) {
                        if (Policy.DEBUG_VIEWER_MAP) {
                            System.out.println("associate: SKIPPED " + element + " item: " + item + " desc: " + desc + " FOUND");
                        }
                        return;
                    }
                    this.viewerDataMap.put(element, desc);
                    if (Policy.DEBUG_VIEWER_MAP) {
                        System.out.println("associate: " + element + " item: " + item + " desc: " + desc);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void disassociate(Item item) {
                Map map = this.viewerDataMap;
                synchronized (map) {
                    if (Policy.DEBUG_VIEWER_MAP) {
                        System.out.println("disassociate:  item: " + item + " object: " + item.getData());
                    }
                    this.viewerDataMap.remove(item.getData());
                }
            }
        }
    }
}

