/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.debugger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.rhino.debugger.ContextData;
import org.eclipse.wst.jsdt.debug.rhino.debugger.RhinoDebugger;
import org.eclipse.wst.jsdt.debug.rhino.debugger.ScriptImpl;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class DebugFrameImpl
implements DebugFrame {
    private final Long id;
    private final Context context;
    private final ContextData contextData;
    private final DebuggableScript debuggableScript;
    private final ScriptImpl script;
    private final ScriptImpl.ScriptRecord record;
    private final HashMap handles = new HashMap();
    private final IdentityHashMap handledObjects = new IdentityHashMap();
    private Scriptable activation;
    private Scriptable thisObj;
    private int lineNumber;

    public DebugFrameImpl(Long frameId, Context context, DebuggableScript debuggableScript, ScriptImpl script) {
        this.id = frameId;
        this.context = context;
        this.contextData = (ContextData)context.getDebuggerContextData();
        this.debuggableScript = debuggableScript;
        this.script = script;
        this.record = script.getRecord(debuggableScript);
        this.lineNumber = this.record.firstLine;
    }

    public Long getId() {
        return this.id;
    }

    public ScriptImpl getScript() {
        return this.script;
    }

    public Integer getLineNumber() {
        return new Integer(this.lineNumber);
    }

    public void onDebuggerStatement(Context cx) {
        this.initializeHandles();
        this.contextData.debuggerStatement(this.script, new Integer(this.lineNumber));
    }

    public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        this.activation = activation;
        this.thisObj = thisObj;
        this.initializeHandles();
        this.contextData.pushFrame(this, this.script, new Integer(this.lineNumber), this.debuggableScript.getFunctionName());
    }

    public void onExit(Context cx, boolean byThrow, Object resultOrException) {
        this.activation = null;
        this.thisObj = null;
        this.clearHandles();
        this.contextData.popFrame(byThrow, resultOrException);
    }

    public void onExceptionThrown(Context cx, Throwable ex) {
        this.initializeHandles();
        this.contextData.exceptionThrown(ex);
    }

    public void onLineChange(Context cx, int lineNumber) {
        this.initializeHandles();
        this.lineNumber = 1 + lineNumber;
        this.contextData.lineChange(this.script, new Integer(this.lineNumber));
    }

    public Object evaluate(String source) {
        Object object;
        RhinoDebugger rhinoDebugger = (RhinoDebugger)this.context.getDebugger();
        rhinoDebugger.disableThread();
        Context evalContext = this.context.getFactory().enterContext();
        Debugger debugger = evalContext.getDebugger();
        Object debuggerContextData = evalContext.getDebuggerContextData();
        evalContext.setDebugger(null, null);
        try {
            Object result = ScriptRuntime.evalSpecial((Context)evalContext, (Scriptable)this.activation, (Object)this.thisObj, (Object[])new Object[]{source}, (String)"eval", (int)0);
            Long handle = this.createHandle(result);
            object = this.serialize(handle, result);
            Object var8_9 = null;
        }
        catch (EcmaError ecmaError) {
            try {
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                evalContext.setDebugger(debugger, debuggerContextData);
                Context.exit();
                rhinoDebugger.enableThread();
                throw throwable;
            }
            evalContext.setDebugger(debugger, debuggerContextData);
            Context.exit();
            rhinoDebugger.enableThread();
            return null;
        }
        evalContext.setDebugger(debugger, debuggerContextData);
        Context.exit();
        rhinoDebugger.enableThread();
        return object;
    }

    public boolean evaluateCondition(String condition) {
        boolean bl;
        RhinoDebugger rhinoDebugger = (RhinoDebugger)this.context.getDebugger();
        rhinoDebugger.disableThread();
        Context evalContext = this.context.getFactory().enterContext();
        Debugger debugger = evalContext.getDebugger();
        Object debuggerContextData = evalContext.getDebuggerContextData();
        evalContext.setDebugger(null, null);
        try {
            Object result = ScriptRuntime.evalSpecial((Context)evalContext, (Scriptable)this.activation, (Object)this.thisObj, (Object[])new Object[]{condition}, (String)"condition", (int)0);
            bl = ScriptRuntime.toBoolean((Object)result);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            evalContext.setDebugger(debugger, debuggerContextData);
            Context.exit();
            rhinoDebugger.enableThread();
            throw throwable;
        }
        evalContext.setDebugger(debugger, debuggerContextData);
        Context.exit();
        rhinoDebugger.enableThread();
        return bl;
    }

    public Object lookup(Long handle) {
        Object object;
        Object result = this.handles.get(handle);
        RhinoDebugger rhinoDebugger = (RhinoDebugger)this.context.getDebugger();
        rhinoDebugger.disableThread();
        Context lookupContext = this.context.getFactory().enterContext();
        Debugger debugger = lookupContext.getDebugger();
        Object debuggerContextData = lookupContext.getDebuggerContextData();
        lookupContext.setDebugger(null, null);
        try {
            object = this.serialize(handle, result);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            lookupContext.setDebugger(debugger, debuggerContextData);
            Context.exit();
            rhinoDebugger.enableThread();
            throw throwable;
        }
        lookupContext.setDebugger(debugger, debuggerContextData);
        Context.exit();
        rhinoDebugger.enableThread();
        return object;
    }

    public Object toJSON() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("threadId", this.contextData.getThreadId());
        result.put("contextId", this.contextData.getId());
        result.put("frameId", this.id);
        result.put("scriptId", this.script.getId());
        result.put("line", new Integer(this.lineNumber));
        result.put("ref", new Integer(0));
        result.put("scopeName", this.record.name);
        return result;
    }

    public Object serialize(Long handle, Object object) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("handle", handle);
        if (object == Undefined.instance) {
            this.serializeUndefined(result);
        } else if (object == null) {
            this.serializeNull(result);
        } else if (object instanceof Boolean) {
            this.serializeSimpleType(object, "boolean", result);
        } else if (object instanceof Number) {
            Object value = object == ScriptRuntime.NaNobj ? null : object;
            this.serializeSimpleType(value, "number", result);
        } else if (object instanceof String) {
            this.serializeSimpleType(object, "string", result);
        } else if (object instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)object;
            this.serializeFunctionOrObject(scriptable, result);
        } else if (object == this) {
            this.serializeFrame(result);
        } else {
            this.serializeUndefined(result);
        }
        return result;
    }

    private void serializeUndefined(Map result) {
        result.put("type", "undefined");
    }

    private void serializeNull(Map result) {
        result.put("type", "null");
    }

    private void serializeSimpleType(Object object, String type, Map result) {
        result.put("type", type);
        result.put("value", object);
    }

    private void serializeFunctionOrObject(Scriptable scriptable, Map result) {
        if (scriptable instanceof BaseFunction) {
            result.put("type", "function");
            result.put("name", ((BaseFunction)scriptable).getFunctionName());
        } else if (scriptable instanceof NativeArray) {
            result.put("type", "array");
        } else {
            result.put("type", "object");
        }
        result.put("className", scriptable.getClassName());
        Object constructorFunction = null;
        if (ScriptableObject.hasProperty((Scriptable)scriptable, (String)"constructor")) {
            constructorFunction = ScriptableObject.getProperty((Scriptable)scriptable, (String)"constructor");
        }
        result.put("constructorFunction", this.createRef(constructorFunction));
        Scriptable protoObject = this.findProtoObject(scriptable);
        result.put("protoObject", this.createRef(protoObject));
        result.put("prototypeObject", this.createRef(scriptable.getPrototype()));
        if (scriptable instanceof NativeJavaObject) {
            result.put("properties", this.createJavaObjectProperties((NativeJavaObject)scriptable));
        } else {
            result.put("properties", this.createProperties(scriptable));
        }
    }

    private Object createJavaObjectProperties(NativeJavaObject javaObject) {
        ArrayList properties = new ArrayList();
        return properties;
    }

    private void serializeFrame(Map result) {
        result.put("type", "frame");
        List properties = this.createProperties(this.activation);
        properties.add(this.createProperty("this", this.thisObj));
        result.put("properties", properties);
    }

    private Scriptable findProtoObject(Scriptable scriptable) {
        Scriptable protoObject = scriptable.getPrototype();
        while (protoObject != null) {
            Scriptable parent = protoObject.getPrototype();
            if (parent == null || parent.equals(protoObject)) break;
            protoObject = parent;
        }
        return protoObject;
    }

    private List createProperties(Scriptable scriptable) {
        ArrayList<Map> properties = new ArrayList<Map>();
        Object[] ids = scriptable.getIds();
        int i = 0;
        while (i < ids.length) {
            block5: {
                Object value;
                Object id;
                block4: {
                    block3: {
                        id = ids[i];
                        value = null;
                        if (!(id instanceof String)) break block3;
                        value = ScriptableObject.getProperty((Scriptable)scriptable, (String)((String)id));
                        break block4;
                    }
                    if (!(id instanceof Number)) break block5;
                    value = ScriptableObject.getProperty((Scriptable)scriptable, (int)((Number)id).intValue());
                }
                Map property = this.createProperty(id, value);
                properties.add(property);
            }
            ++i;
        }
        return properties;
    }

    private Map createProperty(Object id, Object value) {
        Map property = this.createRef(value);
        property.put("name", id);
        return property;
    }

    private Map createRef(Object object) {
        HashMap<String, Long> map = new HashMap<String, Long>(2);
        map.put("ref", this.createHandle(object));
        return map;
    }

    private void clearHandles() {
        this.handles.clear();
        this.handledObjects.clear();
    }

    private void initializeHandles() {
        if (this.handles.size() != 1) {
            this.clearHandles();
            this.createHandle(this);
        }
    }

    private Long createHandle(Object object) {
        Long handle = (Long)this.handledObjects.get(object);
        if (handle == null) {
            handle = new Long(this.nextHandle());
            this.handles.put(handle, object);
            this.handledObjects.put(object, handle);
        }
        return handle;
    }

    private int nextHandle() {
        return this.handles.size();
    }

    public Object getThreadId() {
        return this.contextData.getThreadId();
    }
}

