/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.propertypage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.IModuleHandler;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.ui.Messages;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.IWizardHandle;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ProjectReferenceWizardFragment
extends WizardFragment {
    protected LabelProvider labelProvider = null;
    protected ITreeContentProvider contentProvider = null;
    protected TreeViewer viewer;
    protected IProject[] selected;

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        handle.setTitle(Messages.ProjectReferenceTitle);
        handle.setDescription(Messages.ProjectReferenceDescription);
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(c, 2050);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectReferenceWizardFragment.this.selChanged();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectReferenceWizardFragment.this.advanceToNextPageOrFinish();
            }
        });
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        return c;
    }

    protected void selChanged() {
        IStructuredSelection sel;
        if (this.viewer != null && (sel = (IStructuredSelection)this.viewer.getSelection()) != null) {
            List selectionList = sel.toList();
            this.selected = selectionList.toArray(new IProject[selectionList.size()]);
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IVirtualComponent[] comps = new IVirtualComponent[this.selected.length];
        String[] paths = new String[this.selected.length];
        int i = 0;
        while (i < this.selected.length) {
            IProject proj = this.selected[i];
            if (!ModuleCoreNature.isFlexibleProject((IProject)proj)) {
                try {
                    ModuleCoreNature.addModuleCoreNatureIfNecessary((IProject)proj, (IProgressMonitor)monitor);
                    ProjectFacetsManager.create((IProject)proj, (boolean)true, (IProgressMonitor)monitor);
                }
                catch (CoreException coreException) {}
            }
            comps[i] = ComponentCore.createComponent((IProject)proj, (boolean)false);
            paths[i] = this.getArchiveName(proj, comps[i]);
            ++i;
        }
        this.getTaskModel().putObject("dependency.component", comps);
        this.getTaskModel().putObject("dependency.component.path", paths);
    }

    protected String getArchiveName(IProject proj, IVirtualComponent comp) {
        return this.getModuleHandler().getArchiveName(proj, comp);
    }

    protected IModuleHandler getModuleHandler() {
        return (IModuleHandler)this.getTaskModel().getObject("module.handler");
    }

    protected LabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider(){

                public Image getImage(Object element) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                }

                public String getText(Object element) {
                    if (element instanceof IProject) {
                        return ((IProject)element).getName();
                    }
                    return element == null ? "" : element.toString();
                }
            };
        }
        return this.labelProvider;
    }

    protected ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new ITreeContentProvider(){

                public Object[] getElements(Object inputElement) {
                    IProject cfr_ignored_0 = (IProject)ProjectReferenceWizardFragment.this.getTaskModel().getObject("root.project");
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    ArrayList<IProject> list = new ArrayList<IProject>(Arrays.asList(projects));
                    IVirtualComponent comp = (IVirtualComponent)ProjectReferenceWizardFragment.this.getTaskModel().getObject("root.component");
                    List filtered = ProjectReferenceWizardFragment.this.getModuleHandler().getFilteredProjectListForAdd(comp, list);
                    return filtered.toArray(new IProject[filtered.size()]);
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getChildren(Object parentElement) {
                    return null;
                }
            };
        }
        return this.contentProvider;
    }
}

