/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentproperties.ui;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.internal.contentproperties.ContentSettings;
import org.eclipse.wst.sse.internal.contentproperties.ContentSettingsCreator;
import org.eclipse.wst.sse.internal.contentproperties.IContentSettings;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.contentproperties.ui.ComboListOnPropertyPage;

public abstract class ContentSettingsPropertyPage
extends PropertyPage {
    private static final IStatus STATUS_ERROR = new Status(4, "org.eclipse.wst.sse.ui", 1, "ERROR", null);
    private static final IStatus STATUS_OK = new Status(0, "org.eclipse.wst.sse.ui", 0, "OK", null);
    protected ComboListOnPropertyPage[] combo;
    protected Composite composite;
    protected IContentSettings contentSettings;
    protected final String CSS_LABEL = SSEUIMessages.UI_CSS_profile___2;
    protected final String DEVICE_LABEL = SSEUIMessages.UI_Target_Device___3;
    protected final String DOCUMENT_LABEL = SSEUIMessages.UI_Default_HTML_DOCTYPE_ID___1;
    protected int numberOfCombo;
    protected int numCols = 1;
    protected int numRows = 1;
    protected Composite propertyPage;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IStatus validateEdit(IFile file, Shell context) {
        long afterModifiedFromIFile;
        long afterModifiedFromJavaIO;
        long beforeModifiedFromIFile;
        long beforeModifiedFromJavaIO;
        block9: {
            IStructuredModel model;
            block10: {
                IModelManager manager;
                if (file == null || !file.exists()) {
                    return STATUS_ERROR;
                }
                if (!file.isReadOnly()) {
                    return STATUS_OK;
                }
                IPath location = file.getLocation();
                beforeModifiedFromJavaIO = location != null ? location.toFile().lastModified() : -1L;
                beforeModifiedFromIFile = file.getModificationStamp();
                IStatus status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)context);
                if (!status.isOK()) {
                    return status;
                }
                afterModifiedFromJavaIO = location != null ? location.toFile().lastModified() : -1L;
                afterModifiedFromIFile = file.getModificationStamp();
                if (beforeModifiedFromJavaIO == afterModifiedFromJavaIO && beforeModifiedFromIFile == afterModifiedFromIFile || (model = (manager = StructuredModelManager.getModelManager()).getExistingModelForRead(file)) == null) break block9;
                if (model.isDirty()) break block10;
                try {
                    try {
                        file.refreshLocal(1, null);
                    }
                    catch (CoreException coreException) {
                        IStatus iStatus = STATUS_ERROR;
                        Object var14_11 = null;
                        model.releaseFromRead();
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_12 = null;
                    model.releaseFromRead();
                    throw throwable;
                }
                {
                    Object var14_13 = null;
                    model.releaseFromRead();
                    break block9;
                }
            }
            model.releaseFromRead();
        }
        if (beforeModifiedFromJavaIO == afterModifiedFromJavaIO && beforeModifiedFromIFile == afterModifiedFromIFile) {
            return STATUS_OK;
        }
        return STATUS_ERROR;
    }

    private void cleanUp() {
    }

    protected ComboListOnPropertyPage createComboBoxOf(String title) {
        Label label = new Label(this.propertyPage, 16384);
        label.setText(title);
        if (title != null && title.startsWith(SSEUIMessages.UI_Default_HTML_DOCTYPE_ID___1)) {
            GridData data = new GridData();
            data.horizontalIndent = 10;
            label.setLayoutData((Object)data);
        }
        ComboListOnPropertyPage combo = new ComboListOnPropertyPage(this.propertyPage, 8);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        combo.setLayoutData(data);
        return combo;
    }

    protected Composite createComposite(Composite parent, int numColumns, int numRows) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        this.contentSettings = ContentSettingsCreator.create();
        this.propertyPage = this.createComposite(parent, this.numCols, this.numRows);
        this.createSettingsPageGUI();
        return this.propertyPage;
    }

    protected abstract void createSettingsPageGUI();

    protected abstract void deleteNoneProperty(int var1);

    protected boolean isInitValueChanged(String before, String after) {
        if (before == null && after == null) {
            return false;
        }
        return before == null || !before.equals(after);
    }

    protected void performDefaults() {
        super.performDefaults();
        int i = 0;
        while (i < this.numberOfCombo) {
            this.combo[i].select(0);
            ++i;
        }
    }

    public boolean performOk() {
        Hashtable properties = new Hashtable();
        if (!this.validateState()) {
            this.cleanUp();
            return true;
        }
        int i = 0;
        while (i < this.numberOfCombo) {
            String str = this.combo[i].getSelectedValue();
            if (str != null && this.isInitValueChanged(this.combo[i].getApplyValue(), str)) {
                if (str.length() == 0) {
                    this.deleteNoneProperty(i);
                } else {
                    this.putSelectedPropertyInto(properties, str, i);
                }
                this.combo[i].setApplyValue(str);
            }
            ++i;
        }
        if (!properties.isEmpty()) {
            this.contentSettings.setProperties((IResource)super.getElement(), properties);
        }
        properties.clear();
        properties = null;
        if (!this.contentSettings.existsProperties((IResource)super.getElement())) {
            this.contentSettings.deleteAllProperties((IResource)super.getElement());
        }
        return true;
    }

    protected abstract void putSelectedPropertyInto(Map var1, String var2, int var3);

    protected void setSelectionItem(ComboListOnPropertyPage combo, String value) {
        if (combo.getItemCount() <= 0) {
            return;
        }
        combo.setApplyValue(value);
        String item = combo.getKey(value);
        if (item != null) {
            combo.select(combo.indexOf(item));
        } else {
            combo.select(0);
        }
    }

    private boolean validateState() {
        String name = ContentSettings.getContentSettingsName();
        IResource resource = (IResource)super.getElement();
        IProject project = resource.getProject();
        IFile file = project.getFile(name);
        if (file != null && !file.exists()) {
            return true;
        }
        Shell shell = this.getControl().getShell();
        IStatus status = ContentSettingsPropertyPage.validateEdit(file, shell);
        return status.isOK();
    }
}

