/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.projection;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.reconcile.AbstractStructuredTextReconcilingStrategy;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;

public abstract class AbstractStructuredFoldingStrategy
extends AbstractStructuredTextReconcilingStrategy
implements IProjectionListener {
    public static final String ID = "foldingstrategy";
    public static final String FOLDING_ENABLED = "foldingEnabled";
    protected ProjectionAnnotationModel fProjectionAnnotationModel;
    private StructuredTextViewer fViewer;
    private IReconcileStep fFoldingStep;

    public void setViewer(StructuredTextViewer viewer) {
        super.setViewer((SourceViewer)viewer);
        if (this.fViewer != null) {
            this.fViewer.removeProjectionListener(this);
        }
        this.fViewer = viewer;
        this.fViewer.addProjectionListener(this);
        this.fProjectionAnnotationModel = this.fViewer.getProjectionAnnotationModel();
    }

    public void uninstall() {
        this.setDocument(null);
        if (this.fViewer != null) {
            this.fViewer.removeProjectionListener(this);
            this.fViewer = null;
        }
        this.fFoldingStep = null;
        this.projectionDisabled();
    }

    public void setDocument(IDocument document) {
        super.setDocument(document);
    }

    public void projectionDisabled() {
        this.fProjectionAnnotationModel = null;
    }

    public void projectionEnabled() {
        if (this.fViewer != null) {
            this.fProjectionAnnotationModel = this.fViewer.getProjectionAnnotationModel();
        }
    }

    /*
     * Exception decompiling
     */
    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 334->338)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract Position calcNewFoldPosition(IndexedRegion var1);

    protected void updateAnnotations(Annotation existingAnnotation, IndexedRegion dirtyRegion, Map additions, List modifications, List deletions) {
        if (existingAnnotation instanceof FoldingAnnotation) {
            FoldingAnnotation foldingAnnotation = (FoldingAnnotation)existingAnnotation;
            Position newPos = this.calcNewFoldPosition(foldingAnnotation.getRegion());
            if (newPos != null && newPos.length > 0 && this.fProjectionAnnotationModel != null) {
                Position oldPos = this.fProjectionAnnotationModel.getPosition((Annotation)foldingAnnotation);
                if (!newPos.equals((Object)oldPos)) {
                    oldPos.setOffset(newPos.offset);
                    oldPos.setLength(newPos.length);
                    modifications.add(foldingAnnotation);
                }
            } else {
                deletions.add(foldingAnnotation);
            }
        }
    }

    protected void markInvalidAnnotationsForDeletion(DirtyRegion dirtyRegion, List deletions) {
        Iterator iter = this.getAnnotationIterator(dirtyRegion);
        while (iter.hasNext()) {
            Annotation anno = (Annotation)iter.next();
            if (!(anno instanceof FoldingAnnotation)) continue;
            Position pos = this.fProjectionAnnotationModel.getPosition(anno);
            if (pos.length != 0) continue;
            deletions.add(anno);
        }
    }

    protected abstract boolean indexedRegionValidType(IndexedRegion var1);

    protected boolean containsStep(IReconcileStep step) {
        return this.fFoldingStep.equals(step);
    }

    public void createReconcileSteps() {
        this.fFoldingStep = new StructuredReconcileStep(){};
    }

    private Iterator getAnnotationIterator(DirtyRegion dirtyRegion) {
        Iterator annoIter = null;
        if (this.fProjectionAnnotationModel != null) {
            int offset = dirtyRegion.getOffset();
            if (offset > 0) {
                --offset;
            }
            annoIter = this.fProjectionAnnotationModel.getAnnotationIterator(offset, dirtyRegion.getLength(), false, false);
        }
        return annoIter;
    }

    private Annotation getExistingAnnotation(IndexedRegion indexedRegion) {
        Iterator iter = this.fProjectionAnnotationModel.getAnnotationIterator(indexedRegion.getStartOffset(), 1, false, true);
        Annotation anno = null;
        if (iter.hasNext()) {
            anno = (Annotation)iter.next();
        }
        return anno;
    }

    private Set getIndexedRegions(IStructuredModel model, IStructuredDocumentRegion[] structRegions) {
        HashSet<IndexedRegion> indexedRegions = new HashSet<IndexedRegion>();
        int structRegionIndex = 0;
        while (structRegionIndex < structRegions.length && this.fProjectionAnnotationModel != null) {
            ITextRegionList textRegions = structRegions[structRegionIndex].getRegions();
            int textRegionIndex = 0;
            while (textRegionIndex < textRegions.size() && this.fProjectionAnnotationModel != null) {
                int offset = structRegions[structRegionIndex].getStartOffset(textRegions.get(textRegionIndex));
                indexedRegions.add(model.getIndexedRegion(offset));
                ++textRegionIndex;
            }
            ++structRegionIndex;
        }
        return indexedRegions;
    }

    protected class FoldingAnnotation
    extends ProjectionAnnotation {
        private boolean fIsVisible = false;
        private IndexedRegion fRegion;

        public FoldingAnnotation(IndexedRegion region, boolean isCollapsed) {
            super(isCollapsed);
            this.fRegion = region;
        }

        public IndexedRegion getRegion() {
            return this.fRegion;
        }

        public void setRegion(IndexedRegion region) {
            this.fRegion = region;
        }

        public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
            FontMetrics metrics;
            if (!this.isCollapsed() && (metrics = gc.getFontMetrics()) != null && rectangle.height / metrics.getHeight() <= 1) {
                this.fIsVisible = false;
                return;
            }
            this.fIsVisible = true;
            super.paint(gc, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.fIsVisible) {
                super.markCollapsed();
            }
        }

        public boolean equals(Object obj) {
            boolean equal = false;
            if (obj instanceof FoldingAnnotation) {
                equal = this.fRegion.equals(((FoldingAnnotation)((Object)obj)).fRegion);
            }
            return equal;
        }

        public int hashCode() {
            return this.fRegion.hashCode();
        }

        public String toString() {
            return this.fRegion.toString();
        }
    }
}

