/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.util;

import java.util.HashMap;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.util.IModuleConstants;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class VirtualReferenceUtilities
implements IModuleConstants {
    public static VirtualReferenceUtilities INSTANCE = new VirtualReferenceUtilities();
    private HashMap<String, String> mapping = new HashMap();

    VirtualReferenceUtilities() {
        this.mapping.put("jst.appclient", ".jar");
        this.mapping.put("jst.web", ".war");
        this.mapping.put("jst.ejb", ".jar");
        this.mapping.put("wst.web", ".war");
        this.mapping.put("jst.ear", ".ear");
        this.mapping.put("jst.connector", ".jar");
        this.mapping.put("jst.utility", ".jar");
        this.mapping.put("jst.webfragment", ".jar");
    }

    public boolean addDefaultExtension(String facet, String extension) {
        if (!this.mapping.containsKey(facet) && ProjectFacetsManager.isProjectFacetDefined((String)facet)) {
            this.mapping.put(facet, extension);
            return true;
        }
        return false;
    }

    public void ensureReferencesHaveNames(IVirtualReference[] refs) {
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getArchiveName() == null || refs[i].getArchiveName().equals("")) {
                refs[i].setArchiveName(this.getDefaultArchiveName(refs[i]));
            }
            ++i;
        }
    }

    public String getDefaultArchiveName(IVirtualReference ref) {
        if (!ref.getReferencedComponent().isBinary()) {
            return this.getDefaultProjectArchiveName(ref.getReferencedComponent());
        }
        return new Path(ref.getReferencedComponent().getDeployedName()).lastSegment();
    }

    public String getDefaultProjectArchiveName(IVirtualComponent component) {
        for (String facet : this.mapping.keySet()) {
            if (!FacetedProjectUtilities.isProjectOfType(component.getProject(), facet)) continue;
            return String.valueOf(component.getName()) + this.mapping.get(facet);
        }
        return String.valueOf(component.getName()) + ".jar";
    }
}

