/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ComposedImageDescriptor;
import org.eclipse.emf.edit.ui.provider.ImageWrapperImageDescriptor;
import org.eclipse.emf.edit.ui.provider.URLImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ExtendedImageRegistry {
    public static final ExtendedImageRegistry INSTANCE = new ExtendedImageRegistry();
    protected HashMap<Object, Image> table = new HashMap(10);
    protected static Object resourceURL = EMFEditPlugin.INSTANCE.getImage("full/obj16/Resource");
    protected static String resourceURLPrefix = String.valueOf(resourceURL.toString()) + "#";
    protected static String itemURLPrefix = String.valueOf(EMFEditPlugin.INSTANCE.getImage("full/obj16/Item").toString()) + "#";
    protected static String createChildURLPrefix = String.valueOf(EMFEditPlugin.INSTANCE.getImage("full/ctool16/CreateChild").toString()) + "#";

    public static ExtendedImageRegistry getInstance() {
        return INSTANCE;
    }

    public ExtendedImageRegistry() {
        Display display = Display.getCurrent();
        this.hookDisplayDispose(display);
    }

    public ExtendedImageRegistry(Display display) {
        this.hookDisplayDispose(display);
    }

    public Image getImage(Object object) {
        if (object instanceof Image) {
            return (Image)object;
        }
        Image result = this.table.get(object);
        if (result == null) {
            if (object instanceof ImageDescriptor) {
                ImageDescriptor imageDescriptor = (ImageDescriptor)object;
                result = imageDescriptor.createImage();
            } else if (object instanceof URL || object instanceof URI) {
                String urlString = object.toString();
                ImageDescriptor imageDescriptor = null;
                if (urlString.startsWith(resourceURLPrefix)) {
                    if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
                        imageDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor("dummy." + urlString.substring(resourceURLPrefix.length()));
                    } else {
                        result = this.getImage(resourceURL);
                    }
                } else if (urlString.startsWith(itemURLPrefix)) {
                    try {
                        URL url = new URL(urlString.substring(0, itemURLPrefix.length()));
                        String key1 = urlString.substring(itemURLPrefix.length());
                        imageDescriptor = new URLImageDescriptor(url, key1, null);
                    }
                    catch (IOException iOException) {}
                } else if (urlString.startsWith(createChildURLPrefix)) {
                    try {
                        URL url = new URL(urlString.substring(0, createChildURLPrefix.length()));
                        String key1 = urlString.substring(createChildURLPrefix.length() + 1);
                        String key2 = null;
                        int index = key1.indexOf("/");
                        if (index != -1) {
                            key2 = key1.substring(index + 1);
                            key1 = key1.substring(0, index);
                        }
                        imageDescriptor = new URLImageDescriptor(url, key1, key2);
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(urlString));
                    }
                    catch (IOException iOException) {}
                }
                if (imageDescriptor != null) {
                    result = imageDescriptor.createImage();
                }
            } else if (object instanceof ComposedImage) {
                ComposedImageDescriptor composedImageDescriptor = new ComposedImageDescriptor((ComposedImage)object);
                result = composedImageDescriptor.createImage();
            }
            if (result != null) {
                this.table.put(object, result);
            }
        }
        return result;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (object instanceof ImageDescriptor) {
            return (ImageDescriptor)object;
        }
        Image image = this.getImage(object);
        if (image != null) {
            return new ImageWrapperImageDescriptor(image);
        }
        return null;
    }

    protected void handleDisplayDispose() {
        for (Image image : this.table.values()) {
            image.dispose();
        }
        this.table = null;
    }

    protected void hookDisplayDispose(Display display) {
        display.disposeExec(new Runnable(){

            public void run() {
                ExtendedImageRegistry.this.handleDisplayDispose();
            }
        });
    }
}

