/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTextView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    NSScrollView scrollView;
    String text;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    NSColor linkColor;

    public Link(Composite parent, int style) {
        super(parent, style);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    boolean textView_clickOnLink_atIndex(long id2, long sel, long textView, long link, long charIndex) {
        NSString str = new NSString(link);
        Event event = new Event();
        event.text = str.getString();
        this.sendSelectionEvent(13, event, true);
        return true;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int borderStyle = this.hasBorder() ? 2 : 0;
        NSSize borderSize = NSScrollView.frameSizeForContentSize(new NSSize(), false, false, borderStyle);
        NSTextView widget = (NSTextView)this.view;
        NSSize size = widget.textStorage().size();
        int width = (int)(size.width + borderSize.width);
        int height = (int)(size.height + borderSize.height);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        return new Point(++width, height += border * 2);
    }

    void createHandle() {
        this.state |= 0x800;
        NSScrollView scrollWidget = (NSScrollView)new SWTScrollView().alloc();
        scrollWidget.init();
        scrollWidget.setDrawsBackground(false);
        scrollWidget.setBorderType(this.hasBorder() ? 2 : 0);
        NSTextView widget = (NSTextView)new SWTTextView().alloc();
        widget.init();
        widget.setEditable(false);
        widget.setDrawsBackground(false);
        widget.setDelegate(widget);
        widget.setAutoresizingMask(18L);
        widget.textContainer().setLineFragmentPadding(0.0);
        widget.setFont(this.getFont().handle);
        widget.setAlignment(0L);
        NSMutableDictionary dict = NSMutableDictionary.dictionaryWithCapacity(4L);
        dict.setDictionary(widget.selectedTextAttributes());
        dict.removeObjectForKey(OS.NSBackgroundColorAttributeName);
        dict.setObject(NSCursor.arrowCursor(), OS.NSCursorAttributeName);
        widget.setSelectedTextAttributes(dict);
        this.scrollView = scrollWidget;
        this.view = widget;
    }

    void createWidget() {
        super.createWidget();
        this.text = "";
        NSDictionary dict = ((NSTextView)this.view).linkTextAttributes();
        this.linkColor = new NSColor(dict.valueForKey(OS.NSForegroundColorAttributeName));
    }

    NSFont defaultNSFont() {
        return this.display.textFieldFont;
    }

    void deregister() {
        super.deregister();
        if (this.scrollView != null) {
            this.display.removeWidget(this.scrollView);
        }
    }

    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        this.fillBackground(this.view, context, rect, -1);
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        NSColor nsColor = null;
        nsColor = enabled ? (this.foreground == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(this.foreground[0], this.foreground[1], this.foreground[2], this.foreground[3])) : NSColor.disabledControlTextColor();
        NSTextView widget = (NSTextView)this.view;
        widget.setTextColor(nsColor);
        NSDictionary linkTextAttributes = widget.linkTextAttributes();
        int count = (int)linkTextAttributes.count();
        NSMutableDictionary dict = NSMutableDictionary.dictionaryWithCapacity(count);
        dict.setDictionary(linkTextAttributes);
        dict.setValue(enabled ? this.linkColor : nsColor, OS.NSForegroundColorAttributeName);
        widget.setLinkTextAttributes(dict);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean shouldDrawInsertionPoint(long id2, long sel) {
        return false;
    }

    void register() {
        super.register();
        this.display.addWidget(this.scrollView, this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
        this.linkColor = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    String parse(String string) {
        int length = string.length();
        this.offsets = new Point[length / 4];
        this.ids = new String[length / 4];
        this.mnemonics = new int[length / 4 + 1];
        StringBuffer result = new StringBuffer();
        char[] buffer = new char[length];
        string.getChars(0, string.length(), buffer, 0);
        int index = 0;
        int state = 0;
        int linkIndex = 0;
        int start = 0;
        int tagStart = 0;
        int linkStart = 0;
        int endtagStart = 0;
        int refStart = 0;
        while (index < length) {
            char c = Character.toLowerCase(buffer[index]);
            block0 : switch (state) {
                case 0: {
                    if (c != '<') break;
                    tagStart = index;
                    ++state;
                    break;
                }
                case 1: {
                    if (c != 'a') break;
                    ++state;
                    break;
                }
                case 2: {
                    switch (c) {
                        case 'h': {
                            state = 7;
                            break block0;
                        }
                        case '>': {
                            linkStart = index + 1;
                            ++state;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c)) break;
                    state = 13;
                    break;
                }
                case 3: {
                    if (c != '<') break;
                    endtagStart = index;
                    ++state;
                    break;
                }
                case 4: {
                    state = c == '/' ? state + 1 : 3;
                    break;
                }
                case 5: {
                    state = c == 'a' ? state + 1 : 3;
                    break;
                }
                case 6: {
                    if (c == '>') {
                        this.mnemonics[linkIndex] = this.parseMnemonics(buffer, start, tagStart, result);
                        int offset = result.length();
                        this.parseMnemonics(buffer, linkStart, endtagStart, result);
                        this.offsets[linkIndex] = new Point(offset, result.length() - 1);
                        if (this.ids[linkIndex] == null) {
                            this.ids[linkIndex] = new String(buffer, linkStart, endtagStart - linkStart);
                        }
                        ++linkIndex;
                        endtagStart = refStart = index + 1;
                        linkStart = refStart;
                        tagStart = refStart;
                        start = refStart;
                        state = 0;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 7: {
                    state = c == 'r' ? state + 1 : 0;
                    break;
                }
                case 8: {
                    state = c == 'e' ? state + 1 : 0;
                    break;
                }
                case 9: {
                    state = c == 'f' ? state + 1 : 0;
                    break;
                }
                case 10: {
                    state = c == '=' ? state + 1 : 0;
                    break;
                }
                case 11: {
                    if (c == '\"') {
                        ++state;
                        refStart = index + 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    if (c != '\"') break;
                    this.ids[linkIndex] = new String(buffer, refStart, index - refStart);
                    state = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        break;
                    }
                    if (c != '=') break;
                    ++state;
                    break;
                }
                case 14: {
                    state = c == '\"' ? state + 1 : 0;
                    break;
                }
                case 15: {
                    if (c != '\"') break;
                    state = 2;
                    break;
                }
                default: {
                    state = 0;
                }
            }
            ++index;
        }
        if (start < length) {
            int tmp = this.parseMnemonics(buffer, start, tagStart, result);
            int mnemonic = this.parseMnemonics(buffer, Math.max(tagStart, linkStart), length, result);
            if (mnemonic == -1) {
                mnemonic = tmp;
            }
            this.mnemonics[linkIndex] = mnemonic;
        } else {
            this.mnemonics[linkIndex] = -1;
        }
        if (this.offsets.length != linkIndex) {
            Point[] newOffsets = new Point[linkIndex];
            System.arraycopy(this.offsets, 0, newOffsets, 0, linkIndex);
            this.offsets = newOffsets;
            String[] newIDs = new String[linkIndex];
            System.arraycopy(this.ids, 0, newIDs, 0, linkIndex);
            this.ids = newIDs;
            int[] newMnemonics = new int[linkIndex + 1];
            System.arraycopy(this.mnemonics, 0, newMnemonics, 0, linkIndex + 1);
            this.mnemonics = newMnemonics;
        }
        return result.toString();
    }

    int parseMnemonics(char[] buffer, int start, int end, StringBuffer result) {
        int mnemonic = -1;
        int index = start;
        while (index < end) {
            if (buffer[index] == '&') {
                if (index + 1 < end && buffer[index + 1] == '&') {
                    result.append(buffer[index]);
                    ++index;
                } else {
                    mnemonic = result.length();
                }
            } else {
                result.append(buffer[index]);
            }
            ++index;
        }
        return mnemonic;
    }

    void setBackgroundColor(NSColor nsColor) {
        this.setBackground(nsColor);
    }

    void setBackgroundImage(NSImage image) {
        ((NSTextView)this.view).setDrawsBackground(image == null);
    }

    void setBackground(NSColor nsColor) {
        NSTextView widget = (NSTextView)this.view;
        if (nsColor == null) {
            widget.setDrawsBackground(false);
        } else {
            widget.setDrawsBackground(true);
            widget.setBackgroundColor(nsColor);
        }
    }

    void setFont(NSFont font) {
        ((NSTextView)this.view).setFont(font);
    }

    void setForeground(double[] color) {
        if (!this.getEnabled()) {
            return;
        }
        NSColor nsColor = color == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(color[0], color[1], color[2], 1.0);
        ((NSTextView)this.view).setTextColor(nsColor);
    }

    void setOrientation() {
        NSTextView widget = (NSTextView)this.view;
        int direction = (this.style & 0x4000000) != 0 ? 1 : 0;
        widget.setBaseWritingDirection(direction);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        NSTextView widget = (NSTextView)this.view;
        widget.setString(NSString.stringWith(this.parse(string)));
        NSTextStorage textStorage = widget.textStorage();
        NSRange range = new NSRange();
        range.length = textStorage.length();
        textStorage.removeAttribute(OS.NSLinkAttributeName, range);
        textStorage.addAttribute(OS.NSCursorAttributeName, NSCursor.arrowCursor(), range);
        int i = 0;
        while (i < this.offsets.length) {
            range.location = this.offsets[i].x;
            range.length = this.offsets[i].y - this.offsets[i].x + 1;
            textStorage.addAttribute(OS.NSLinkAttributeName, NSString.stringWith(this.ids[i]), range);
            ++i;
        }
    }

    public void setToolTipText(String string) {
        ((NSTextView)this.view).setDisplaysLinkToolTips(string == null);
        super.setToolTipText(string);
    }

    void setZOrder() {
        super.setZOrder();
        if (this.scrollView != null) {
            this.scrollView.setDocumentView(this.view);
        }
    }

    NSView topView() {
        return this.scrollView;
    }

    void updateCursorRects(boolean enabled) {
        super.updateCursorRects(enabled);
        if (this.scrollView == null) {
            return;
        }
        this.updateCursorRects(enabled, this.scrollView);
        NSClipView contentView = this.scrollView.contentView();
        this.updateCursorRects(enabled, contentView);
        contentView.setDocumentCursor(enabled ? NSCursor.IBeamCursor() : null);
    }
}

