/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.releng.tools.MapContentDocument;
import org.eclipse.releng.tools.MapEntry;
import org.eclipse.releng.tools.MapFile;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.operations.CommitOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;

public class MapProject
implements IResourceChangeListener {
    private static MapProject mapProject = null;
    private IProject project;
    private MapFile[] mapFiles;

    public static MapProject getDefaultMapProject() {
        if (mapProject == null) {
            IProject project = MapProject.getProjectFromWorkspace();
            try {
                mapProject = new MapProject(project);
            }
            catch (CoreException e) {
                RelEngPlugin.log(e);
            }
        }
        return mapProject;
    }

    private static IProject getProjectFromWorkspace() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(RelEngPlugin.MAP_PROJECT_NAME);
        return project;
    }

    public MapProject(IProject p) throws CoreException {
        this.project = p;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.loadMapFiles();
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject p) {
        this.project = p;
    }

    private MapFile getMapFile(IProject p) {
        int i = 0;
        while (i < this.mapFiles.length) {
            if (this.mapFiles[i].contains(p)) {
                return this.mapFiles[i];
            }
            ++i;
        }
        return null;
    }

    public MapEntry getMapEntry(IProject p) {
        MapFile file = this.getMapFile(p);
        if (file != null) {
            return file.getMapEntry(p);
        }
        return null;
    }

    public boolean mapsAreLoaded() {
        return this.project.exists();
    }

    public MapFile[] getValidMapFiles() {
        ArrayList<MapFile> list = new ArrayList<MapFile>();
        int i = 0;
        while (i < this.mapFiles.length) {
            IProject[] projects = this.mapFiles[i].getAccessibleProjects();
            if (projects != null && projects.length > 0) {
                list.add(this.mapFiles[i]);
            }
            ++i;
        }
        return list.toArray(new MapFile[list.size()]);
    }

    public void updateFile(IProject aProject, String tag) throws CoreException {
        MapFile aFile = this.getMapFile(aProject);
        if (aFile == null) {
            return;
        }
        MapContentDocument changed = new MapContentDocument(aFile);
        changed.updateTag(aProject, tag);
        if (changed.isChanged()) {
            aFile.getFile().setContents(changed.getContents(), 2, null);
        }
    }

    public void commitMapProject(String comment, IProgressMonitor monitor) throws CoreException {
        try {
            new CommitOperation(null, RepositoryProviderOperation.asResourceMappers((IResource[])new IResource[]{this.project}), new Command.LocalOption[0], comment).run(monitor);
        }
        catch (InvocationTargetException e) {
            throw TeamException.asTeamException((InvocationTargetException)e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public MapFile[] getMapFilesFor(IProject[] projects) {
        HashSet<MapFile> alist = new HashSet<MapFile>();
        int i = 0;
        while (i < projects.length) {
            MapFile aMapFile = this.getMapFile(projects[i]);
            alist.add(aMapFile);
            ++i;
        }
        return alist.toArray(new MapFile[alist.size()]);
    }

    public CVSTag[] getTagsFor(IProject[] projects) {
        if (projects == null || projects.length == 0) {
            return null;
        }
        CVSTag[] tags = new CVSTag[projects.length];
        int i = 0;
        while (i < tags.length) {
            MapEntry entry = this.getMapEntry(projects[i]);
            tags[i] = entry == null ? CVSTag.DEFAULT : entry.getTag();
            ++i;
        }
        return tags;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta root = event.getDelta();
        IResourceDelta folderDelta = root.findMember(this.getMapFolder().getFullPath());
        if (folderDelta == null) {
            return;
        }
        IResourceDelta[] deltas = folderDelta.getAffectedChildren();
        if (deltas == null || deltas.length == 0) {
            return;
        }
        int i = 0;
        while (i < deltas.length) {
            IResourceDelta delta = deltas[i];
            if (delta.getResource().getType() == 1) {
                try {
                    IFile aFile = (IFile)delta.getResource();
                    MapFile mFile = null;
                    if (this.isMapFile(aFile)) {
                        if (delta.getKind() == 4) {
                            mFile = this.getMapFileFor(aFile);
                            mFile.loadEntries();
                        }
                        if (delta.getKind() == 2) {
                            this.loadMapFiles();
                        }
                        if (delta.getKind() == 1) {
                            mFile = this.getMapFileFor(aFile);
                            this.addMapFile(mFile);
                        }
                    }
                }
                catch (CoreException e) {
                    RelEngPlugin.log(e);
                }
            }
            ++i;
        }
    }

    private IFolder getMapFolder() {
        return this.getProject().getFolder(RelEngPlugin.MAP_FOLDER);
    }

    private void loadMapFiles() throws CoreException {
        final ArrayList maps = new ArrayList();
        this.project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                IFile file;
                if (resource.getType() == 1 && MapProject.this.isMapFile(file = (IFile)resource)) {
                    maps.add(new MapFile(file));
                }
                return true;
            }
        });
        this.mapFiles = maps.size() > 0 ? maps.toArray(new MapFile[maps.size()]) : new MapFile[0];
    }

    private MapFile getMapFileFor(IFile file) throws CoreException {
        int i = 0;
        while (i < this.mapFiles.length) {
            if (this.mapFiles[i].getFile().equals((Object)file)) {
                return this.mapFiles[i];
            }
            ++i;
        }
        return new MapFile(file);
    }

    private void addMapFile(MapFile aFile) {
        HashSet<MapFile> set = new HashSet<MapFile>(Arrays.asList(this.mapFiles));
        set.add(aFile);
        this.mapFiles = set.toArray(new MapFile[set.size()]);
    }

    private boolean isMapFile(IFile aFile) {
        String extension = aFile.getFileExtension();
        return extension != null && extension.equals("map");
    }
}

