/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.releng.tools.MapFile;
import org.eclipse.releng.tools.MapProject;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.ReleaseWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ProjectSelectionPage
extends WizardPage {
    private CheckboxTreeViewer viewer;
    private IDialogSettings settings;
    private Button compareButton;
    private boolean compareButtonChecked;
    private String SELECTED_ITEMS_KEY = Messages.getString("ProjectSelectionPage.0");
    private String COMPARE_BUTTON_KEY = Messages.getString("ProjectSelectionPage.1");
    private MapProject mapProject;

    public ProjectSelectionPage(String pageName, String title, IDialogSettings settings, ImageDescriptor image) {
        super(pageName, title, image);
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topContainer = new Composite(parent, 0);
        topContainer.setLayout((Layout)new GridLayout());
        topContainer.setLayoutData((Object)new GridData(1808));
        Label label = new Label(topContainer, 256);
        label.setFont(font);
        label.setText(Messages.getString("ProjectSelectionPage.2"));
        this.viewer = new ContainerCheckedTreeViewer(topContainer, 2820);
        GridData gd = new GridData(1808);
        gd.heightHint = this.viewer.getTree().getItemHeight() * 15;
        this.viewer.getTree().setLayoutData((Object)gd);
        this.viewer.getTree().setFont(font);
        this.viewer.setLabelProvider((IBaseLabelProvider)new MapFileLabelProvider());
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.setComparator((ViewerComparator)new ResourceComparator(1){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (o1 instanceof MapFile && o2 instanceof MapFile) {
                    return super.compare(viewer, (Object)((MapFile)o1).getFile(), (Object)((MapFile)o2).getFile());
                }
                return super.compare(viewer, o1, o2);
            }
        });
        this.viewer.setInput((Object)this.mapProject);
        this.viewer.expandAll();
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectSelectionPage.this.updatePageComplete();
            }
        });
        this.compareButton = new Button(topContainer, 32);
        this.compareButton.setText(Messages.getString("ProjectSelectionPage.3"));
        this.compareButton.setFont(font);
        this.compareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionPage.this.compareButtonChecked = ProjectSelectionPage.this.compareButton.getSelection();
            }
        });
        this.initialize();
        this.setControl((Control)topContainer);
    }

    private IContentProvider getContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof MapProject) {
                    return ProjectSelectionPage.this.mapProject.getValidMapFiles();
                }
                if (parentElement instanceof MapFile) {
                    return ((MapFile)parentElement).getAccessibleProjects();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof MapFile) {
                    return ((MapFile)element).getAccessibleProjects().length > 0;
                }
                return false;
            }
        };
    }

    public IProject[] getCheckedProjects() {
        ArrayList<Object> projectsToRelease = new ArrayList<Object>();
        Object[] obj = this.viewer.getCheckedElements();
        if (obj == null) {
            return null;
        }
        int i = 0;
        while (i < obj.length) {
            if (obj[i] instanceof IProject) {
                projectsToRelease.add(obj[i]);
            }
            ++i;
        }
        return projectsToRelease.toArray(new IProject[projectsToRelease.size()]);
    }

    private void readProjectSettings() {
        if (this.settings == null) {
            return;
        }
        if (this.settings.getArray(this.SELECTED_ITEMS_KEY) != null) {
            ArrayList<String> nameList = new ArrayList<String>(Arrays.asList(this.settings.getArray(this.SELECTED_ITEMS_KEY)));
            Iterator<String> iter = nameList.iterator();
            while (iter.hasNext()) {
                String name = iter.next();
                IProject project = this.getProjectWithName(name);
                if (project == null) continue;
                this.viewer.setChecked((Object)project, true);
            }
        }
    }

    private void initCompareEnablement() {
        if (this.settings == null || this.settings.get(this.COMPARE_BUTTON_KEY) == null) {
            this.compareButton.setSelection(true);
            this.compareButtonChecked = true;
            return;
        }
        boolean b = this.settings.getBoolean(this.COMPARE_BUTTON_KEY);
        this.compareButton.setSelection(b);
        this.compareButtonChecked = b;
    }

    public void saveSettings() {
        Object[] obj = this.viewer.getCheckedElements();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < obj.length) {
            if (obj[i] instanceof IProject) {
                names.add(((IProject)obj[i]).getName());
            }
            ++i;
        }
        this.settings.put(this.SELECTED_ITEMS_KEY, names.toArray(new String[names.size()]));
        this.settings.put(this.COMPARE_BUTTON_KEY, this.compareButtonChecked);
    }

    private void initialize() {
        this.initCheckedProjects();
        this.initCompareEnablement();
        this.updatePageComplete();
    }

    private void initCheckedProjects() {
        Object[] p = ((ReleaseWizard)this.getWizard()).getPreSelectedProjects();
        if (p != null) {
            this.viewer.setCheckedElements(p);
        } else {
            this.readProjectSettings();
        }
    }

    private IProject getProjectWithName(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists() && project.isAccessible()) {
            return project;
        }
        return null;
    }

    public boolean isCompareButtonChecked() {
        return this.compareButtonChecked;
    }

    private void updatePageComplete() {
        Object[] obj = this.viewer.getCheckedElements();
        if (obj.length > 0) {
            int i = 0;
            while (i < obj.length) {
                if (obj[i] instanceof IProject) {
                    this.setPageComplete(true);
                    break;
                }
                ++i;
            }
        } else {
            this.setPageComplete(false);
        }
    }

    private CheckboxTreeViewer getViewer() {
        return this.viewer;
    }

    public void setSelection(IProject[] projects) {
        if (projects != null && projects.length > 0) {
            this.getViewer().setCheckedElements((Object[])projects);
        }
    }

    public void updateMapProject(MapProject m) {
        this.mapProject = m;
        if (this.viewer != null) {
            this.viewer.setInput((Object)this.mapProject);
        }
    }

    private class MapFileLabelProvider
    extends LabelProvider {
        WorkbenchLabelProvider provider = new WorkbenchLabelProvider();

        private MapFileLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof MapFile) {
                return ((MapFile)element).getName();
            }
            return this.provider.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof MapFile) {
                return this.provider.getImage((Object)((MapFile)element).getFile());
            }
            return this.provider.getImage(element);
        }

        public void dispose() {
            this.provider.dispose();
            super.dispose();
        }
    }
}

