/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.tools.emf.editor3x.RedoAction;
import org.eclipse.e4.tools.emf.editor3x.UndoAction;
import org.eclipse.e4.tools.emf.editor3x.XMIModelResource;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.wbm.ApplicationModelEditor;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;

public class E4WorkbenchModelEditor
extends EditorPart {
    private XMIModelResource resource;
    private ApplicationModelEditor editor;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private static final String CSS_URI = "platform:/plugin/org.eclipse.e4.tools.emf.editor3x/css/default.css";
    private IModelResource.ModelListener listener = new IModelResource.ModelListener(){

        public void dirtyChanged() {
            E4WorkbenchModelEditor.this.firePropertyChange(257);
        }

        public void commandStackChanged() {
        }
    };

    public void doSave(IProgressMonitor monitor) {
        this.editor.save();
    }

    public void doSaveAs() {
    }

    private void setupCss(Display display) {
        CSSEngine engine = (CSSEngine)display.getData("org.eclipse.e4.ui.css.core.engine");
        if (engine == null) {
            engine = new CSSSWTEngineImpl(display, true);
            engine.setErrorHandler(new CSSErrorHandler(){

                public void error(Exception e) {
                    e.printStackTrace();
                }
            });
            display.setData("org.eclipse.e4.ui.css.core.engine", (Object)engine);
            try {
                URL url = FileLocator.resolve((URL)new URL(CSS_URI.toString()));
                display.setData("org.eclipse.e4.ui.css.core.cssURL", (Object)url);
                InputStream stream = url.openStream();
                engine.parseStyleSheet(stream);
                stream.close();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        URI resourceURI = EditUIUtil.getURI((IEditorInput)input);
        if (resourceURI != null) {
            this.resource = new XMIModelResource(resourceURI);
            this.resource.addModelListener(this.listener);
        }
    }

    public boolean isDirty() {
        return this.resource.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.setupCss(parent.getDisplay());
        Composite comp = new Composite(parent, 0);
        comp.setBackground(comp.getDisplay().getSystemColor(1));
        comp.setBackgroundMode(1);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        comp.setLayout((Layout)layout);
        IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
        this.editor = new ApplicationModelEditor(comp, (IModelResource)this.resource, input.getFile().getProject());
        try {
            parent.setRedraw(false);
            parent.reskin(1);
        }
        finally {
            parent.setRedraw(true);
        }
        this.makeActions();
    }

    private void makeActions() {
        this.undoAction = new UndoAction(this.resource);
        this.redoAction = new RedoAction(this.resource);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void dispose() {
        if (this.undoAction != null) {
            this.undoAction.dispose();
        }
        if (this.redoAction != null) {
            this.redoAction.dispose();
        }
        if (this.listener != null && this.resource != null) {
            this.resource.removeModelListener(this.listener);
        }
        super.dispose();
    }

    public void setFocus() {
        this.editor.setFocus();
    }
}

