/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.commands;

import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.commands.Command;

public class ApplyAttributeSettingCommand
extends Command {
    private XamlNode parent;
    private String attributeName;
    private String namespace;
    private String oldValue;
    private String newValue;
    private boolean isCreation = false;
    private XamlAttribute attr;

    public ApplyAttributeSettingCommand(XamlNode parent, String attributeName, String namespace, String newValue) {
        super("Set " + attributeName);
        this.parent = parent;
        this.attributeName = attributeName;
        this.namespace = namespace;
        this.newValue = newValue;
    }

    public ApplyAttributeSettingCommand(XamlNode parent, XamlAttribute attr, String value) {
        this(parent, attr.getName(), attr.getNamespace(), value);
        this.attr = attr;
    }

    public boolean canExecute() {
        if (this.attr != null) {
            return this.newValue == null && this.attr.getValue() != null || !this.newValue.equals(this.attr.getValue());
        }
        if (this.parent == null || this.attributeName == null) {
            return false;
        }
        this.attr = this.parent.getAttribute(this.attributeName, this.namespace);
        if (this.attr != null) {
            return this.newValue == null && this.attr.getValue() != null || !this.newValue.equals(this.attr.getValue());
        }
        return true;
    }

    public boolean canUndo() {
        if (this.isCreation && this.parent != null) {
            return this.attr != null;
        }
        return this.attr != null;
    }

    public void execute() {
        if (this.attr == null) {
            this.attr = this.parent.getAttribute(this.attributeName, this.namespace);
        }
        if (this.attr == null) {
            this.attr = XamlFactory.eINSTANCE.createAttribute(this.attributeName, this.namespace);
        } else {
            this.oldValue = this.attr.getValue();
        }
        if ((this.newValue == null || this.newValue.length() == 0) && this.parent != null) {
            this.parent.getAttributes().remove((Object)this.attr);
            return;
        }
        this.attr.setValue(this.newValue);
        boolean bl = this.isCreation = this.attr.eContainer() == null || this.parent != null && this.attr.eContainer() != this.parent;
        if (this.parent != null && this.isCreation) {
            this.parent.getAttributes().add((Object)this.attr);
        }
    }

    public XamlAttribute getAttribute() {
        return this.attr;
    }

    public void undo() {
        if (this.isCreation && this.parent != null) {
            this.parent.getAttributes().remove((Object)this.attr);
        }
        if (this.attr != null) {
            if (this.oldValue != null) {
                this.attr.setValue(this.oldValue);
            } else {
                this.attr.setValue(null);
                this.attr.setUseFlatValue(true);
                this.parent.getAttributes().remove((Object)this.attr);
                this.parent.getAttributes().add((Object)this.attr);
            }
        }
    }

    public static Command createCommand(XamlNode parent, String attrName, String namespace, String newValue) {
        return new ApplyAttributeSettingCommand(parent, attrName, namespace, newValue);
    }
}

