/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.XWTLoaderManager;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.Designer;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.IVisualFactory;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.IVisualRenderer;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.dnd.DropContext;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.outline.ContentOutlinePage;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.outline.dnd.OutlineDropManager;
import org.eclipse.e4.xwt.tools.ui.designer.core.model.IModelBuilder;
import org.eclipse.e4.xwt.tools.ui.designer.editor.XWTDesignerMenuProvider;
import org.eclipse.e4.xwt.tools.ui.designer.editor.XWTJavaEditor;
import org.eclipse.e4.xwt.tools.ui.designer.editor.XWTSelectionTool;
import org.eclipse.e4.xwt.tools.ui.designer.editor.XWTVisualRenderer;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.BindingLayerAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.ChangeTextAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.CopyElementAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.CutElementAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.LayoutAssistantAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.OpenBindingDialogAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.OpenExternalizeStringsAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.PasteElementAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.PreviewAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.SurroundWithAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.dnd.XWTDropContext;
import org.eclipse.e4.xwt.tools.ui.designer.editor.dnd.XWTGraphicalViewerDropListener;
import org.eclipse.e4.xwt.tools.ui.designer.editor.event.EventHandler;
import org.eclipse.e4.xwt.tools.ui.designer.editor.model.XWTModelBuilder;
import org.eclipse.e4.xwt.tools.ui.designer.editor.outline.OutlinePageContentProvider;
import org.eclipse.e4.xwt.tools.ui.designer.editor.outline.OutlinePageDropManager;
import org.eclipse.e4.xwt.tools.ui.designer.editor.outline.OutlinePageLabelProvider;
import org.eclipse.e4.xwt.tools.ui.designer.loader.XWTVisualLoader;
import org.eclipse.e4.xwt.tools.ui.designer.parts.XWTEditPartFactory;
import org.eclipse.e4.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Tool;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class XWTDesigner
extends Designer
implements ITabbedPropertySheetPageContributor {
    public static final String EDITOR_ID = "org.eclipse.e4.xwt.tools.ui.designer.XWTDesigner";
    private XWTJavaEditor javaEditor;
    private EventHandler eventHandler;
    private ToolItem generateTool;
    private XWTVisualLoader xwtLoader;

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IFile inputFile = this.getInputFile();
        if (inputFile != null) {
            this.xwtLoader = new XWTVisualLoader(inputFile);
            XWTLoaderManager.setActive((IXWTLoader)this.xwtLoader, (boolean)true);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        EditDomain domain = this.getEditDomain();
        domain.setDefaultTool((Tool)new XWTSelectionTool());
        domain.loadDefaultTool();
    }

    public void dispose() {
        super.dispose();
        if (this.xwtLoader != null) {
            XWTLoaderManager.setActive((IXWTLoader)this.xwtLoader, (boolean)false);
        }
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new CopyElementAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new PasteElementAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new CutElementAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new PreviewAction(this);
        registry.registerAction((IAction)action);
        action = new ChangeTextAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new LayoutAssistantAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new OpenBindingDialogAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new BindingLayerAction(this);
        registry.registerAction((IAction)action);
        action = new OpenExternalizeStringsAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new SurroundWithAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
    }

    protected IModelBuilder createModelBuilder() {
        return new XWTModelBuilder();
    }

    protected void setupGraphicalViewer() {
        ((XWTEditPartFactory)this.getEditPartFactory()).setVisualFactory((IVisualFactory)this.getVisualsRender());
        super.setupGraphicalViewer();
        this.setupJavaEditor();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)true);
    }

    protected void setupGraphicalViewerDropCreation(GraphicalViewer viewer) {
        viewer.addDropTargetListener((TransferDropTargetListener)new XWTGraphicalViewerDropListener((EditPartViewer)viewer));
    }

    private void setupJavaEditor() {
        String hostClassName = this.getVisualsRender().getHostClassName();
        if (hostClassName != null && this.javaEditor == null) {
            this.javaEditor = new XWTJavaEditor(this.getJavaProject(), hostClassName);
            IType type = this.javaEditor.getType();
            if (type != null) {
                try {
                    int javaPageIndex = this.addPage((IEditorPart)this.javaEditor, this.javaEditor.getEditorInput());
                    this.setPageText(javaPageIndex, "Java");
                    this.setPageImage(javaPageIndex, JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif"));
                    this.eventHandler = new EventHandler(this, type);
                    if (this.generateTool != null && !this.generateTool.isDisposed()) {
                        this.generateTool.setEnabled(true);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    protected IJavaProject getJavaProject() {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
        if (!javaProject.exists()) {
            return null;
        }
        return javaProject;
    }

    protected ToolBar createToolBar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        ToolBarManager toolBarManager = new ToolBarManager(toolbar);
        toolBarManager.add(this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId()));
        toolBarManager.add(this.getActionRegistry().getAction((Object)ActionFactory.PASTE.getId()));
        toolBarManager.add(this.getActionRegistry().getAction((Object)ActionFactory.CUT.getId()));
        toolBarManager.add(this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.e4.xwt.tools.ui.designer.editor.actions.PreviewAction"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.e4.xwt.tools.ui.designer.editor.actions.LayoutAssistantAction"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getActionRegistry().getAction((Object)OpenBindingDialogAction.ID));
        toolBarManager.update(true);
        toolbar.pack();
        return toolbar;
    }

    protected void configureContainerToolBar(ToolBar toolBar) {
        ToolItem previewTool = new ToolItem(toolBar, 8);
        previewTool.setImage(ImageShop.get("/icons/full/tools/preview.png"));
        previewTool.setToolTipText("Preview");
        previewTool.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                new PreviewAction(XWTDesigner.this).run();
            }
        });
        this.generateTool = new ToolItem(toolBar, 8);
        this.generateTool.setImage(JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif"));
        this.generateTool.setToolTipText("Create event handlers");
        this.generateTool.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (XWTDesigner.this.eventHandler != null) {
                    XWTDesigner.this.eventHandler.createHandlers();
                }
            }
        });
        this.generateTool.setEnabled(false);
    }

    protected ContextMenuProvider createMenuProvider() {
        return new XWTDesignerMenuProvider(this);
    }

    protected EditPartFactory createEditPartFactory() {
        return new XWTEditPartFactory();
    }

    protected ContentOutlinePage createOutlinePage() {
        ContentOutlinePage outlinePage = super.createOutlinePage();
        outlinePage.setContentProvider((ITreeContentProvider)new OutlinePageContentProvider());
        outlinePage.setLabelProvider((ILabelProvider)new OutlinePageLabelProvider());
        outlinePage.setContextMenuProvider(this.getContextMenuProvider());
        outlinePage.setDropManager((OutlineDropManager)new OutlinePageDropManager(this.getEditDomain().getCommandStack()));
        return outlinePage;
    }

    protected DropContext getDropContext() {
        return new XWTDropContext();
    }

    public void openPerspective() {
        IPerspectiveDescriptor pers;
        IWorkbench workbench = PlatformUI.getWorkbench();
        int count = workbench.getWorkbenchWindowCount();
        if (count == 0) {
            return;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            window = workbench.getWorkbenchWindows()[0];
        }
        if ((pers = workbench.getPerspectiveRegistry().findPerspectiveWithId("org.eclipse.e4.xwt.ui.perspective")) == null) {
            return;
        }
        try {
            workbench.showPerspective("org.eclipse.e4.xwt.ui.perspective", window);
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
    }

    protected IPropertySheetPage createPropertyPage() {
        TabbedPropertySheetPage propertyPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        return propertyPage;
    }

    protected IVisualRenderer createVisualsRender() {
        return new XWTVisualRenderer(this.getInputFile(), (XamlDocument)this.getDocumentRoot());
    }

    public String getContributorId() {
        return this.getSite().getId();
    }
}

