/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalCategory;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalComputerDescriptor;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalContentTypeContext;

public final class CompletionProposalComputerRegistry {
    private static final String EXTENSION_POINT = "completionProposal";
    private static final String ELEM_PROPOSAL_CATEGORY = "proposalCategory";
    private static final String ELEM_PROPOSAL_COMPUTER = "proposalComputer";
    private static final String ELEM_PROPOSAL_COMPUTER_EXTENDED_ACTIVATION = "proposalComputerExtendedActivation";
    private static final String ATTR_ID = "id";
    private static final String NUM_COMPUTERS_PREF_KEY = "content_assist_number_of_computers";
    private static final String ALL_PARTITION_TYPES_ID = "all_partition_types_fake_ID";
    private static CompletionProposalComputerRegistry fgSingleton = null;
    private final Map fActivationContexts;
    private final Map fDescriptors = new HashMap();
    private final List fCategories = new ArrayList();
    private final List fPublicCategories = Collections.unmodifiableList(this.fCategories);
    private boolean fLoaded = false;
    private boolean fHasUninstalledComputers = false;

    public static synchronized CompletionProposalComputerRegistry getDefault() {
        if (fgSingleton == null) {
            fgSingleton = new CompletionProposalComputerRegistry();
        }
        return fgSingleton;
    }

    private CompletionProposalComputerRegistry() {
        this.fActivationContexts = new HashMap();
    }

    public List getProposalCategories() {
        this.ensureExtensionPointRead();
        return this.fPublicCategories;
    }

    public List getProposalCategories(String contentTypeID) {
        this.ensureExtensionPointRead();
        ArrayList<CompletionProposalCategory> result = new ArrayList<CompletionProposalCategory>();
        int i = 0;
        while (i < this.fCategories.size()) {
            CompletionProposalCategory category = (CompletionProposalCategory)this.fCategories.get(i);
            if (category.hasComputers(contentTypeID)) {
                result.add(category);
            }
            ++i;
        }
        return Collections.unmodifiableList(result);
    }

    public boolean hasUninstalledComputers() {
        return this.fHasUninstalledComputers;
    }

    public void resetUnistalledComputers() {
        this.fHasUninstalledComputers = false;
    }

    void putDescription(String contentTypeID, String partitionTypeID, CompletionProposalComputerDescriptor descriptor) {
        if (partitionTypeID == null) {
            partitionTypeID = ALL_PARTITION_TYPES_ID;
        }
        CompletionProposalContentTypeContext context = this.getContext(contentTypeID);
        context.putDescriptor(partitionTypeID, descriptor);
    }

    List getProposalComputerDescriptors(String contentTypeID, String partitionTypeID) {
        this.ensureExtensionPointRead();
        HashSet descriptorsSet = new HashSet();
        List contexts = this.getContexts(contentTypeID);
        int i = 0;
        while (i < contexts.size()) {
            CompletionProposalContentTypeContext contentSpecificContext = (CompletionProposalContentTypeContext)contexts.get(i);
            descriptorsSet.addAll(contentSpecificContext.getDescriptors(partitionTypeID));
            descriptorsSet.addAll(contentSpecificContext.getDescriptors(ALL_PARTITION_TYPES_ID));
            ++i;
        }
        ArrayList descriptors = new ArrayList(descriptorsSet);
        return Collections.unmodifiableList(descriptors);
    }

    List getProposalComputerDescriptors(String contentTypeID) {
        this.ensureExtensionPointRead();
        HashSet descriptorsSet = new HashSet();
        List contexts = this.getContexts(contentTypeID);
        int i = 0;
        while (i < contexts.size()) {
            CompletionProposalContentTypeContext contentSpecificContext = (CompletionProposalContentTypeContext)contexts.get(i);
            descriptorsSet.addAll(contentSpecificContext.getDescriptors());
            ++i;
        }
        ArrayList descriptors = new ArrayList(descriptorsSet);
        return Collections.unmodifiableList(descriptors);
    }

    List getProposalComputerDescriptors() {
        this.ensureExtensionPointRead();
        return Collections.unmodifiableList(new ArrayList(this.fDescriptors.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureExtensionPointRead() {
        boolean reload;
        CompletionProposalComputerRegistry completionProposalComputerRegistry = this;
        synchronized (completionProposalComputerRegistry) {
            reload = !this.fLoaded;
            this.fLoaded = true;
        }
        if (reload) {
            this.load();
            this.updateUninstalledComputerCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        IConfigurationElement element;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> extensionElements = new ArrayList<IConfigurationElement>(Arrays.asList(registry.getConfigurationElementsFor("org.eclipse.wst.sse.ui", EXTENSION_POINT)));
        HashMap<String, CompletionProposalComputerDescriptor> loadedDescriptors = new HashMap<String, CompletionProposalComputerDescriptor>();
        ArrayList<IConfigurationElement> extendedComputerActivations = new ArrayList<IConfigurationElement>();
        List categories = this.getCategories(extensionElements);
        Iterator iter = extensionElements.iterator();
        while (iter.hasNext()) {
            element = (IConfigurationElement)iter.next();
            try {
                if (element.getName().equals(ELEM_PROPOSAL_COMPUTER)) {
                    CompletionProposalComputerDescriptor desc = new CompletionProposalComputerDescriptor(element, categories);
                    desc.addToRegistry();
                    loadedDescriptors.put(desc.getId(), desc);
                    continue;
                }
                if (!element.getName().equals(ELEM_PROPOSAL_COMPUTER_EXTENDED_ACTIVATION)) continue;
                extendedComputerActivations.add(element);
            }
            catch (InvalidRegistryObjectException x) {
                String message = "The extension ''" + element.toString() + "'' is invalid.";
                Status status = new Status(2, "org.eclipse.wst.sse.ui", 0, message, (Throwable)x);
                Logger.log((IStatus)status);
            }
            catch (CoreException x) {
                Logger.log(x.getStatus());
            }
        }
        int i = 0;
        while (i < extendedComputerActivations.size()) {
            element = (IConfigurationElement)extendedComputerActivations.get(i);
            String proposalComputerID = element.getAttribute(ATTR_ID);
            CompletionProposalComputerDescriptor descriptor = (CompletionProposalComputerDescriptor)loadedDescriptors.get(proposalComputerID);
            if (descriptor != null) {
                try {
                    CompletionProposalComputerDescriptor.parseActivationAndAddToRegistry(element, descriptor);
                }
                catch (InvalidRegistryObjectException x) {
                    String message = "The extension ''" + element.toString() + "'' is invalid.";
                    Status status = new Status(2, "org.eclipse.wst.sse.ui", 0, message, (Throwable)x);
                    Logger.log((IStatus)status);
                }
                catch (CoreException x) {
                    Logger.log(x.getStatus());
                }
            } else {
                Logger.log(2, "Configuration element " + element + " intented to extend an existing completion proposal computer" + " specified an invalid completion proposal computer ID " + proposalComputerID);
            }
            ++i;
        }
        CompletionProposalComputerRegistry completionProposalComputerRegistry = this;
        synchronized (completionProposalComputerRegistry) {
            this.fCategories.clear();
            this.fCategories.addAll(categories);
            this.fDescriptors.clear();
            this.fDescriptors.putAll(loadedDescriptors);
        }
    }

    private void updateUninstalledComputerCount() {
        int currNumber;
        IPreferenceStore preferenceStore = SSEUIPlugin.getDefault().getPreferenceStore();
        int lastNumberOfComputers = preferenceStore.getInt(NUM_COMPUTERS_PREF_KEY);
        this.fHasUninstalledComputers = lastNumberOfComputers > (currNumber = this.fDescriptors.size());
        preferenceStore.putValue(NUM_COMPUTERS_PREF_KEY, Integer.toString(currNumber));
    }

    private List getCategories(List extensionElements) {
        ArrayList<CompletionProposalCategory> categories = new ArrayList<CompletionProposalCategory>();
        Iterator iter = extensionElements.iterator();
        while (iter.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)iter.next();
            try {
                if (!element.getName().equals(ELEM_PROPOSAL_CATEGORY)) continue;
                iter.remove();
                CompletionProposalCategory category = new CompletionProposalCategory(element);
                categories.add(category);
            }
            catch (InvalidRegistryObjectException x) {
                String message = "The extension ''" + element.toString() + "'' has become invalid.";
                Status status = new Status(2, "org.eclipse.wst.sse.ui", 0, message, (Throwable)x);
                Logger.log((IStatus)status);
            }
            catch (CoreException x) {
                Logger.log(x.getStatus());
            }
        }
        return categories;
    }

    private CompletionProposalContentTypeContext getContext(String contentTypeID) {
        CompletionProposalContentTypeContext context = (CompletionProposalContentTypeContext)this.fActivationContexts.get(contentTypeID);
        if (context == null) {
            context = new CompletionProposalContentTypeContext(contentTypeID);
            this.fActivationContexts.put(contentTypeID, context);
        }
        return context;
    }

    private List getContexts(String contentTypeID) {
        ArrayList contexts = new ArrayList();
        IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeID);
        while (contentType != null) {
            Object context = this.fActivationContexts.get(contentType.getId());
            if (context != null) {
                contexts.add(context);
            }
            contentType = contentType.getBaseType();
        }
        return contexts;
    }
}

