/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableFolderSyncInfo;

class StickyHandler
extends ResponseHandler {
    private final boolean setSticky;

    public StickyHandler(boolean setSticky) {
        this.setSticky = setSticky;
    }

    public String getResponseID() {
        if (this.setSticky) {
            return "Set-sticky";
        }
        return "Clear-sticky";
    }

    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        block6: {
            String repositoryDir = session.readLine();
            String tag = null;
            if (this.setSticky && (tag = session.readLine()) != null && tag.length() == 0) {
                tag = null;
            }
            Assert.isTrue((boolean)repositoryDir.endsWith("/"));
            repositoryDir = repositoryDir.substring(0, repositoryDir.length() - 1);
            try {
                ICVSFolder folder = StickyHandler.createFolder(session, localDir, repositoryDir);
                FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
                if (syncInfo == null) {
                    return;
                }
                MutableFolderSyncInfo newInfo = syncInfo.cloneMutable();
                newInfo.setTag(tag != null ? new CVSEntryLineTag(tag) : null);
                if (tag != null && tag.equals("TBASE")) {
                    newInfo.setTag(syncInfo.getTag());
                }
                if (!syncInfo.equals(newInfo)) {
                    folder.setFolderSyncInfo(newInfo);
                }
            }
            catch (CVSException e) {
                if (this.handleInvalidResourceName(session, session.getLocalRoot().getFolder(localDir), e)) break block6;
                throw e;
            }
        }
    }
}

