/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public abstract class TypeBinding
extends Binding {
    public int id = Integer.MAX_VALUE;
    public long tagBits = 0L;
    public static final BaseTypeBinding INT = new BaseTypeBinding(10, TypeConstants.INT, new char[]{'I'});
    public static final BaseTypeBinding SHORT = new BaseTypeBinding(4, TypeConstants.SHORT, new char[]{'S'});
    public static final BaseTypeBinding CHAR = new BaseTypeBinding(2, TypeConstants.CHAR, new char[]{'C'});
    public static final BaseTypeBinding LONG = new BaseTypeBinding(7, TypeConstants.LONG, new char[]{'J'});
    public static final BaseTypeBinding FLOAT = new BaseTypeBinding(9, TypeConstants.FLOAT, new char[]{'F'});
    public static final BaseTypeBinding DOUBLE = new BaseTypeBinding(8, TypeConstants.DOUBLE, new char[]{'D'});
    public static final BaseTypeBinding BOOLEAN = new BaseTypeBinding(5, TypeConstants.BOOLEAN, new char[]{'Z'});
    public static final BaseTypeBinding NULL = new BaseTypeBinding(12, TypeConstants.NULL, new char[]{'N'});
    public static final BaseTypeBinding VOID = new BaseTypeBinding(6, TypeConstants.VOID, new char[]{'V'});
    public static final BaseTypeBinding UNDEFINED = new BaseTypeBinding(0, TypeConstants.UNDEFINED, new char[]{'U'});
    public static final BaseTypeBinding ANY = new BaseTypeBinding(13, TypeConstants.ANY, new char[]{'A'});
    public static final BaseTypeBinding UNKNOWN = new BaseTypeBinding(13, TypeConstants.ANY, new char[]{'A'});

    public static final TypeBinding wellKnownType(Scope scope, int id) {
        switch (id) {
            case 5: {
                return BOOLEAN;
            }
            case 2: {
                return CHAR;
            }
            case 4: {
                return SHORT;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return FLOAT;
            }
            case 10: {
                return INT;
            }
            case 7: {
                return LONG;
            }
            case 1: {
                return scope.getJavaLangObject();
            }
            case 11: {
                return scope.getJavaLangString();
            }
        }
        return null;
    }

    public boolean canBeInstantiated() {
        return !this.isBaseType();
    }

    public abstract char[] constantPoolName();

    public String debugName() {
        return new String(this.readableName());
    }

    public int dimensions() {
        return 0;
    }

    public ReferenceBinding enclosingType() {
        return null;
    }

    public ReferenceBinding findSuperTypeErasingTo(int wellKnownErasureID, boolean erasureIsClass) {
        if (!(this instanceof ReferenceBinding)) {
            return null;
        }
        ReferenceBinding reference = (ReferenceBinding)this;
        if (reference.id == wellKnownErasureID || this.id == wellKnownErasureID) {
            return reference;
        }
        ReferenceBinding currentType = reference;
        if (erasureIsClass) {
            while ((currentType = currentType.superclass()) != null) {
                if (currentType.id != wellKnownErasureID && currentType.id != wellKnownErasureID) continue;
                return currentType;
            }
            return null;
        }
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        while ((currentType = currentType.superclass()) != null) {
        }
        int i = 0;
        while (i < nextPosition) {
            currentType = interfacesToVisit[i];
            if (currentType.id == wellKnownErasureID || currentType.id == wellKnownErasureID) {
                return currentType;
            }
            ++i;
        }
        return null;
    }

    public TypeBinding findSuperTypeWithSameErasure(TypeBinding otherType) {
        if (this == otherType) {
            return this;
        }
        if (otherType == null) {
            return null;
        }
        switch (this.kind()) {
            case 68: {
                ArrayBinding arrayType = (ArrayBinding)this;
                int otherDim = otherType.dimensions();
                if (arrayType.dimensions != otherDim) {
                    switch (otherType.id) {
                        case 1: {
                            return otherType;
                        }
                    }
                    if (otherDim < arrayType.dimensions && otherType.leafComponentType().id == 1) {
                        return otherType;
                    }
                    return null;
                }
                if (!(arrayType.leafComponentType instanceof ReferenceBinding)) {
                    return null;
                }
                TypeBinding leafSuperType = arrayType.leafComponentType.findSuperTypeWithSameErasure(otherType.leafComponentType());
                if (leafSuperType == null) {
                    return null;
                }
                return arrayType.environment().createArrayType(leafSuperType, arrayType.dimensions);
            }
            case 4: {
                if (this == otherType || this == otherType) {
                    return this;
                }
                ReferenceBinding currentType = (ReferenceBinding)this;
                while ((currentType = currentType.superclass()) != null) {
                    if (currentType != otherType && currentType != otherType) continue;
                    return currentType;
                }
                return null;
            }
        }
        return null;
    }

    public TypeBinding genericCast(TypeBinding otherType) {
        if (this == otherType) {
            return null;
        }
        return otherType;
    }

    public abstract PackageBinding getPackage();

    public final boolean isAnonymousType() {
        return (this.tagBits & 0x20L) != 0L;
    }

    public final boolean isObjectLiteralType() {
        return (this.tagBits & 0x100000000000000L) != 0L;
    }

    public final boolean isArrayType() {
        return (this.tagBits & 1L) != 0L;
    }

    public final boolean isBaseType() {
        return (this.tagBits & 2L) != 0L;
    }

    public boolean isBasicType() {
        if ((this.tagBits & 2L) != 0L) {
            return true;
        }
        return this.id <= 14;
    }

    public boolean isClass() {
        return false;
    }

    public abstract boolean isCompatibleWith(TypeBinding var1);

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        return false;
    }

    public final boolean isHierarchyInconsistent() {
        return (this.tagBits & 0x20000L) != 0L;
    }

    public boolean isIntersectingWith(TypeBinding otherType) {
        return this == otherType;
    }

    public final boolean isLocalType() {
        return (this.tagBits & 0x10L) != 0L;
    }

    public final boolean isMemberType() {
        return (this.tagBits & 8L) != 0L;
    }

    public final boolean isNestedType() {
        return (this.tagBits & 4L) != 0L;
    }

    public final boolean isAnyType() {
        return this.id == 13;
    }

    public final boolean isNumericType() {
        switch (this.id) {
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isProvablyDistinctFrom(TypeBinding otherType, int depth) {
        if (this == otherType) {
            return false;
        }
        if (depth > 1) {
            return true;
        }
        return this != otherType;
    }

    public boolean isReifiable() {
        TypeBinding leafType = this.leafComponentType();
        if (!(leafType instanceof ReferenceBinding)) {
            return true;
        }
        ReferenceBinding current = (ReferenceBinding)leafType;
        do {
            if (current.isStatic()) {
                return true;
            }
            if (!current.isLocalType()) continue;
            return true;
        } while ((current = current.enclosingType()) != null);
        return true;
    }

    public boolean isThrowable() {
        return false;
    }

    public boolean isTypeArgumentContainedBy(TypeBinding otherType) {
        return this == otherType;
    }

    public boolean isUncheckedException(boolean includeSupertype) {
        return false;
    }

    public int kind() {
        return 4;
    }

    public TypeBinding leafComponentType() {
        return this;
    }

    public boolean needsUncheckedConversion(TypeBinding targetType) {
        if (this == targetType) {
            return false;
        }
        if (!((targetType = targetType.leafComponentType()) instanceof ReferenceBinding)) {
            return false;
        }
        TypeBinding currentType = this.leafComponentType();
        TypeBinding match = currentType.findSuperTypeWithSameErasure(targetType);
        if (!(match instanceof ReferenceBinding)) {
            return false;
        }
        return false;
    }

    public char[] qualifiedPackageName() {
        PackageBinding packageBinding = this.getPackage();
        return packageBinding == null || packageBinding.compoundName == CharOperation.NO_CHAR_CHAR ? CharOperation.NO_CHAR : packageBinding.readableName();
    }

    public abstract char[] qualifiedSourceName();

    public char[] signature() {
        return this.constantPoolName();
    }

    public abstract char[] sourceName();

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType, LookupEnvironment environment) {
    }

    public boolean isFunctionType() {
        return false;
    }

    public char[] getFileName() {
        return new char[0];
    }

    public TypeBinding reconcileAnonymous(TypeBinding other) {
        return null;
    }
}

