/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.dialogs.UIResourceFilterDescription;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.CreateLinkedResourceGroup;
import org.eclipse.ui.internal.ide.dialogs.ResourceFilterEditDialog;
import org.eclipse.ui.internal.ide.misc.OverlayIcon;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WizardNewFolderMainPage
extends WizardPage
implements Listener {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    private IStructuredSelection currentSelection;
    private IFolder newFolder;
    private URI linkTargetPath;
    private ResourceAndContainerGroup resourceGroup;
    private Button advancedButton;
    private Button useDefaultLocation;
    private Button useVirtualFolder;
    private Button useLinkedResource;
    private Button filterButton;
    private CreateLinkedResourceGroup linkedResourceGroup;
    private Composite advancedComposite;
    private Composite linkedResourceComposite;
    private Composite linkedGroupComposite;
    private UIResourceFilterDescription[] filterList = null;
    private int linkedResourceGroupHeight = -1;
    private boolean firstLinkCheck = true;
    static /* synthetic */ Class class$0;

    public WizardNewFolderMainPage(String pageName, IStructuredSelection selection) {
        super("newFolderPage1");
        this.setTitle(pageName);
        this.setDescription(IDEWorkbenchMessages.WizardNewFolderMainPage_description);
        this.currentSelection = selection;
    }

    protected void createAdvancedControls(Composite parent) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("description.disableLinking")) {
            this.advancedComposite = new Composite(parent, 0);
            this.advancedComposite.setFont(parent.getFont());
            this.advancedComposite.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.advancedComposite.setLayout((Layout)layout);
            this.advancedButton = new Button(this.advancedComposite, 8);
            this.advancedButton.setFont(this.advancedComposite.getFont());
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
            GridData data = this.setButtonLayoutData(this.advancedButton);
            data.horizontalAlignment = 1;
            this.advancedButton.setLayoutData((Object)data);
            this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WizardNewFolderMainPage.this.handleAdvancedButtonSelect();
                }
            });
        }
        this.linkedResourceGroup = new CreateLinkedResourceGroup(2, new Listener(){

            public void handleEvent(Event e) {
                WizardNewFolderMainPage.this.setPageComplete(WizardNewFolderMainPage.this.validatePage());
                WizardNewFolderMainPage.this.firstLinkCheck = false;
            }
        }, new CreateLinkedResourceGroup.IStringValue(){

            public String getValue() {
                return WizardNewFolderMainPage.this.resourceGroup.getResource();
            }

            public void setValue(String string) {
                WizardNewFolderMainPage.this.resourceGroup.setResource(string);
            }

            public IResource getResource() {
                IPath path = WizardNewFolderMainPage.this.resourceGroup.getContainerFullPath();
                if (path != null) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IResource resource = root.findMember(path);
                    if (resource != null && resource instanceof IContainer) {
                        String resourceName = WizardNewFolderMainPage.this.resourceGroup.getResource();
                        if (resourceName.length() > 0) {
                            return ((IContainer)resource).getFolder(Path.fromOSString((String)resourceName));
                        }
                        return resource;
                    }
                    return resource;
                }
                return null;
            }
        });
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.new_folder_wizard_page_context");
        this.resourceGroup = new ResourceAndContainerGroup(composite, this, IDEWorkbenchMessages.WizardNewFolderMainPage_folderName, IDEWorkbenchMessages.WizardNewFolderMainPage_folderLabel, false, 250);
        this.resourceGroup.setAllowExistingResources(false);
        this.createAdvancedControls(composite);
        this.initializePage();
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected void createFolder(IFolder folderHandle, IProgressMonitor monitor) throws CoreException {
        try {
            if (!folderHandle.exists()) {
                if (this.linkTargetPath != null) {
                    folderHandle.createLink(this.linkTargetPath, 16, monitor);
                } else {
                    IPath path = folderHandle.getFullPath();
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    int numSegments = path.segmentCount();
                    if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                        int i = numSegments - 2;
                        while (i > 0) {
                            IFolder folder = root.getFolder(path.removeLastSegments(i));
                            if (!folder.exists()) {
                                folder.create(false, true, monitor);
                            }
                            --i;
                        }
                    }
                    folderHandle.create(false, true, monitor);
                }
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                folderHandle.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFolder(folderPath);
    }

    protected IContainer createContainerHandle(IPath containerPath) {
        if (containerPath.segmentCount() == 1) {
            return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProject(containerPath.segment(0));
        }
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFolder(containerPath);
    }

    protected void createLinkTarget() {
        this.linkTargetPath = this.linkedResourceGroup.getLinkTargetURI();
    }

    public IFolder createNewFolder() {
        if (this.newFolder != null) {
            return this.newFolder;
        }
        IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFolderPath = containerPath.append(this.resourceGroup.getResource());
        final IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
        final boolean createVirtualFolder = this.useVirtualFolder != null && this.useVirtualFolder.getSelection();
        this.createLinkTarget();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateFolderOperation op = new CreateFolderOperation(newFolderHandle, WizardNewFolderMainPage.this.linkTargetPath, createVirtualFolder, WizardNewFolderMainPage.this.filterList, IDEWorkbenchMessages.WizardNewFolderCreationPage_title);
                try {
                    op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter(WizardNewFolderMainPage.this.getShell()));
                }
                catch (ExecutionException e) {
                    WizardNewFolderMainPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(this, e){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ ExecutionException val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$e = executionException;
                        }

                        public void run() {
                            if (this.val$e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)WizardNewFolderMainPage.access$4(4.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_errorTitle, null, (IStatus)((CoreException)this.val$e.getCause()).getStatus());
                            } else {
                                IDEWorkbenchPlugin.log(this.getClass(), "createNewFolder()", this.val$e.getCause());
                                MessageDialog.openError((Shell)WizardNewFolderMainPage.access$4(4.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFolder_internalError, (Object)this.val$e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }

            static /* synthetic */ WizardNewFolderMainPage access$0(4 var0) {
                return var0.WizardNewFolderMainPage.this;
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "createNewFolder()", e.getTargetException());
            MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFolder_internalError, (Object)e.getTargetException().getMessage()), (int)0x10000000);
            return null;
        }
        this.newFolder = newFolderHandle;
        return this.newFolder;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.linkedResourceComposite != null) {
            this.linkedResourceComposite.dispose();
            this.linkedResourceComposite = null;
            this.filterButton.dispose();
            this.useDefaultLocation.dispose();
            this.useVirtualFolder.dispose();
            this.useLinkedResource.dispose();
            this.linkedGroupComposite.dispose();
            this.filterButton = null;
            this.useDefaultLocation = null;
            this.useVirtualFolder = null;
            this.useLinkedResource = null;
            this.linkedGroupComposite = null;
            composite.layout();
            shell.setSize(shellSize.x, shellSize.y - this.linkedResourceGroupHeight);
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        } else {
            ImageDescriptor folderDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
            ImageDescriptor[][] linkedResourceOverlayMap = new ImageDescriptor[4][1];
            linkedResourceOverlayMap[1] = new ImageDescriptor[]{AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/ovr16/link_ovr.gif")};
            OverlayIcon linkedFolderDescriptor = new OverlayIcon(folderDescriptor, linkedResourceOverlayMap, new Point(16, 16));
            ImageDescriptor[][] virtualFolderOverlayMap = new ImageDescriptor[4][1];
            virtualFolderOverlayMap[1] = new ImageDescriptor[]{AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/ovr16/virt_ovr.gif")};
            OverlayIcon virtualFolderDescriptor = new OverlayIcon(folderDescriptor, virtualFolderOverlayMap, new Point(16, 16));
            Image folderImage = folderDescriptor.createImage();
            this.useDefaultLocation = new Button(this.advancedComposite, 16);
            int indent = this.useDefaultLocation.computeSize((int)-1, (int)-1).x;
            this.useDefaultLocation.setFont(this.advancedComposite.getFont());
            this.useDefaultLocation.setText(IDEWorkbenchMessages.useDefaultLocation);
            this.useDefaultLocation.setImage(folderImage);
            GridData data = this.setButtonLayoutData(this.useDefaultLocation);
            data.horizontalAlignment = 1;
            data.horizontalIndent = indent;
            this.useDefaultLocation.setLayoutData((Object)data);
            Image virtualFolderImage = virtualFolderDescriptor.createImage();
            this.useVirtualFolder = new Button(this.advancedComposite, 16);
            this.useVirtualFolder.setFont(this.advancedComposite.getFont());
            this.useVirtualFolder.setImage(virtualFolderImage);
            this.useVirtualFolder.setText(IDEWorkbenchMessages.createVirtualFolder);
            data = this.setButtonLayoutData(this.useVirtualFolder);
            data.horizontalAlignment = 1;
            data.horizontalIndent = indent;
            this.useVirtualFolder.setLayoutData((Object)data);
            Image linkedFolderImage = linkedFolderDescriptor.createImage();
            this.useLinkedResource = new Button(this.advancedComposite, 16);
            this.useLinkedResource.setFont(this.advancedComposite.getFont());
            this.useLinkedResource.setText(IDEWorkbenchMessages.createLinkedFolder);
            this.useLinkedResource.setImage(linkedFolderImage);
            data = this.setButtonLayoutData(this.useLinkedResource);
            data.horizontalAlignment = 1;
            data.horizontalIndent = indent;
            this.useLinkedResource.setLayoutData((Object)data);
            SelectionAdapter radioListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WizardNewFolderMainPage.this.handleRadioSelect();
                }
            };
            this.useLinkedResource.addSelectionListener((SelectionListener)radioListener);
            this.useVirtualFolder.addSelectionListener((SelectionListener)radioListener);
            this.useDefaultLocation.addSelectionListener((SelectionListener)radioListener);
            this.useDefaultLocation.setSelection(true);
            this.linkedGroupComposite = new Composite(this.advancedComposite, 0);
            data = new GridData(4, 1, true, false);
            data.horizontalIndent = indent;
            this.linkedGroupComposite.setLayoutData((Object)data);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.linkedGroupComposite.setLayout((Layout)layout);
            this.linkedResourceComposite = this.linkedResourceGroup.createTextOnlyContents(this.linkedGroupComposite);
            if (this.linkedResourceGroupHeight == -1) {
                Point groupSize = this.linkedResourceComposite.computeSize(-1, -1, true);
                this.linkedResourceGroupHeight = groupSize.y;
            }
            this.linkedResourceGroup.setEnabled(false);
            shell.setSize(shellSize.x, shellSize.y + this.linkedResourceGroupHeight);
            this.filterButton = new Button(this.advancedComposite, 8);
            this.filterButton.setFont(this.advancedComposite.getFont());
            this.filterButton.setText(IDEWorkbenchMessages.editfilters);
            data = this.setButtonLayoutData(this.filterButton);
            data.horizontalAlignment = 1;
            data.horizontalIndent = indent;
            this.filterButton.setLayoutData((Object)data);
            this.filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WizardNewFolderMainPage.this.handleEditFilterSelect();
                }
            });
            composite.layout();
            this.advancedButton.setText(IDEWorkbenchMessages.hideAdvanced);
        }
    }

    private void handleRadioSelect() {
        this.linkedResourceGroup.setEnabled(this.useLinkedResource.getSelection());
    }

    private void handleEditFilterSelect() {
        ResourceFilterEditDialog dialog = new ResourceFilterEditDialog(this.getShell());
        dialog.setFilters(this.filterList);
        if (dialog.open() == 0) {
            this.filterList = dialog.getFilters();
        }
    }

    public void handleEvent(Event ev) {
        this.setPageComplete(this.validatePage());
    }

    protected void initializePage() {
        Iterator it = this.currentSelection.iterator();
        if (it.hasNext()) {
            Object next = it.next();
            IResource selectedResource = null;
            if (next instanceof IResource) {
                selectedResource = (IResource)next;
            } else if (next instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                selectedResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (selectedResource != null) {
                if (selectedResource.getType() == 1) {
                    selectedResource = selectedResource.getParent();
                }
                if (selectedResource.isAccessible()) {
                    this.resourceGroup.setContainerFullPath(selectedResource.getFullPath());
                }
            }
        }
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.resourceGroup.setFocus();
        }
    }

    protected IStatus validateLinkedResource() {
        IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFolderPath = containerPath.append(this.resourceGroup.getResource());
        IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
        IStatus status = this.linkedResourceGroup.validateLinkLocation((IResource)newFolderHandle);
        if (status.getSeverity() == 4) {
            if (this.firstLinkCheck) {
                this.setMessage(status.getMessage());
            } else {
                this.setErrorMessage(status.getMessage());
            }
        } else if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
            this.setErrorMessage(null);
        }
        return status;
    }

    protected boolean validatePage() {
        IPath containerPath;
        boolean valid = true;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            valid = false;
        }
        if ((this.useDefaultLocation == null || this.useDefaultLocation.getSelection()) && (containerPath = this.resourceGroup.getContainerFullPath()) != null && this.createContainerHandle(containerPath).isVirtual()) {
            valid = false;
            this.setErrorMessage(IDEWorkbenchMessages.CreateLinkedResourceGroup_linkRequiredUnderAGroup);
        }
        IStatus linkedResourceStatus = null;
        if (valid && (linkedResourceStatus = this.validateLinkedResource()).getSeverity() == 4) {
            valid = false;
        }
        if (valid && (linkedResourceStatus == null || linkedResourceStatus.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        if (this.isFilteredByParent()) {
            this.setMessage(IDEWorkbenchMessages.WizardNewFolderCreationPage_resourceWillBeFilteredWarning, 2);
        }
        return valid;
    }

    private boolean isFilteredByParent() {
        boolean createVirtualFolder;
        boolean bl = createVirtualFolder = this.useVirtualFolder != null && this.useVirtualFolder.getSelection();
        if (createVirtualFolder) {
            return false;
        }
        if (this.linkTargetPath != null) {
            return false;
        }
        IPath containerPath = this.resourceGroup.getContainerFullPath();
        if (containerPath == null) {
            return false;
        }
        String resourceName = this.resourceGroup.getResource();
        if (resourceName == null) {
            return false;
        }
        if (resourceName.length() > 0) {
            IPath newFolderPath = containerPath.append(resourceName);
            IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
            return newFolderHandle.isFiltered();
        }
        return false;
    }
}

