/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptPreferencesManager;
import org.eclipse.wst.jsdt.debug.internal.core.launching.ConnectorsManager;
import org.eclipse.wst.jsdt.debug.internal.core.model.BreakpointParticipantManager;
import org.osgi.framework.BundleContext;

public class JavaScriptDebugPlugin
extends Plugin {
    public static final int INTERNAL_ERROR = 120;
    public static final String PLUGIN_ID = "org.eclipse.wst.jsdt.debug.core";
    private static JavaScriptDebugPlugin plugin;
    private static ConnectorsManager connectionmanager;
    private static BreakpointParticipantManager participantmanager;
    private static JavaScriptPreferencesManager prefmanager;

    static {
        connectionmanager = null;
        participantmanager = null;
        prefmanager = null;
    }

    public static synchronized ConnectorsManager getConnectionsManager() {
        if (connectionmanager == null) {
            connectionmanager = new ConnectorsManager();
        }
        return connectionmanager;
    }

    public static synchronized BreakpointParticipantManager getParticipantManager() {
        if (participantmanager == null) {
            participantmanager = new BreakpointParticipantManager();
        }
        return participantmanager;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        prefmanager = new JavaScriptPreferencesManager();
        prefmanager.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            plugin = null;
            if (connectionmanager != null) {
                connectionmanager.dispose();
            }
            if (participantmanager != null) {
                participantmanager.dispose();
            }
            if (prefmanager != null) {
                prefmanager.stop();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    public static JavaScriptDebugPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public static void log(Throwable t) {
        JavaScriptDebugPlugin.log(JavaScriptDebugPlugin.newErrorStatus("Error logged from JSDT Debug Core: ", t));
    }

    public static void logErrorMessage(String message) {
        JavaScriptDebugPlugin.log(JavaScriptDebugPlugin.newErrorStatus("Internal message logged from JavaScript Debug Core: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 120, message, exception);
    }
}

