/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.core.model.JavaScriptDebugModel;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;

public class JavaScriptPreferencesManager
implements IEclipsePreferences.IPreferenceChangeListener {
    private static IJavaScriptLoadBreakpoint allLoadsBreakpoint = null;

    public void start() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.wst.jsdt.debug.core");
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        if (node.getBoolean("org.eclipse.wst.jsdt.debug.core.suspend_on_all_script_loads", false)) {
            allLoadsBreakpoint = this.createSuspendOnAllLoads();
        }
    }

    public void stop() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.wst.jsdt.debug.core");
        if (node != null) {
            node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        try {
            if (allLoadsBreakpoint != null) {
                allLoadsBreakpoint.delete();
            }
        }
        catch (CoreException e) {
            JavaScriptDebugPlugin.log(e);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("org.eclipse.wst.jsdt.debug.core.suspend_on_all_script_loads")) {
            if (event.getNewValue().equals(Boolean.TRUE.toString()) && allLoadsBreakpoint == null) {
                allLoadsBreakpoint = this.createSuspendOnAllLoads();
            } else {
                this.deleteSuspendOnAllLoads();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteSuspendOnAllLoads() {
        if (allLoadsBreakpoint == null) return;
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] instanceof JavaScriptDebugTarget) {
                ((JavaScriptDebugTarget)targets[i]).breakpointRemoved(allLoadsBreakpoint, null);
            }
            ++i;
        }
        try {
            try {
                allLoadsBreakpoint.delete();
            }
            catch (CoreException e) {
                JavaScriptDebugPlugin.log(e);
            }
            Object var3_6 = null;
            allLoadsBreakpoint = null;
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            allLoadsBreakpoint = null;
            throw throwable;
        }
    }

    private IJavaScriptLoadBreakpoint createSuspendOnAllLoads() {
        IJavaScriptLoadBreakpoint breakpoint = null;
        try {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("org.eclipse.wst.jsdt.debug.core.global_suspend", Boolean.TRUE);
            breakpoint = JavaScriptDebugModel.createScriptLoadBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), -1, -1, map, false);
        }
        catch (DebugException e) {
            JavaScriptDebugPlugin.log(e);
        }
        if (breakpoint != null) {
            IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (targets[i] instanceof JavaScriptDebugTarget) {
                    ((JavaScriptDebugTarget)targets[i]).breakpointAdded(breakpoint);
                }
                ++i;
            }
        }
        return breakpoint;
    }

    public static IJavaScriptBreakpoint[] getAllManagedBreakpoints() {
        ArrayList<IJavaScriptLoadBreakpoint> breakpoints = new ArrayList<IJavaScriptLoadBreakpoint>();
        if (allLoadsBreakpoint != null) {
            breakpoints.add(allLoadsBreakpoint);
        }
        return breakpoints.toArray(new IJavaScriptBreakpoint[breakpoints.size()]);
    }
}

