/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.ShadowComposite;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ApplicationEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.BindingTableEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CommandEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DirectMenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DirectToolItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandledMenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandledToolItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandlerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.InputPartEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.KeyBindingEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ModelComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ModelComponentsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartDescriptorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartSashContainerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartStackEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PerspectiveEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PerspectiveStackEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PlaceholderEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.WindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.WindowTrimEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VBindingTableEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VCommandEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VHandlerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VModelComponentBindingEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPartDescriptor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowTrimEditor;
import org.eclipse.e4.ui.model.application.MApplicationPackage;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ModelEditor {
    public static final int VIRTUAL_MENU = 0;
    public static final int VIRTUAL_PART = 1;
    public static final int VIRTUAL_HANDLER = 2;
    public static final int VIRTUAL_BINDING_TABLE = 3;
    public static final int VIRTUAL_COMMAND = 4;
    public static final int VIRTUAL_WINDOWS = 5;
    public static final int VIRTUAL_WINDOW_CONTROLS = 6;
    public static final int VIRTUAL_WINDOW_TRIMS = 7;
    public static final int VIRTUAL_PART_DESCRIPTORS = 8;
    public static final int VIRTUAL_MODEL_COMP_COMMANDS = 9;
    public static final int VIRTUAL_MODEL_COMP_BINDINGS = 10;
    private Map<EClass, AbstractComponentEditor> editorMap = new HashMap<EClass, AbstractComponentEditor>();
    private AbstractComponentEditor[] virtualEditors;
    private List<FeaturePath> labelFeaturePaths = new ArrayList<FeaturePath>();
    private TreeViewer viewer;
    private IModelResource modelProvider;
    private IProject project;

    @Inject
    public ModelEditor(Composite composite, IModelResource modelProvider, IProject project) {
        this.modelProvider = modelProvider;
        this.project = project;
        this.registerDefaultEditors();
        this.registerVirtualEditors();
        SashForm form = new SashForm(composite, 256);
        form.setBackground(form.getDisplay().getSystemColor(1));
        this.viewer = this.createTreeViewerArea((Composite)form);
        Composite parent = new Composite((Composite)form, 0);
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        parent.setBackgroundMode(1);
        FillLayout l = new FillLayout();
        l.marginWidth = 5;
        parent.setLayout((Layout)l);
        ShadowComposite editingArea = new ShadowComposite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginTop = 0;
        gl.marginHeight = 0;
        editingArea.setLayout((Layout)gl);
        editingArea.setBackgroundMode(1);
        Composite headerContainer = new Composite((Composite)editingArea, 0);
        headerContainer.setBackgroundMode(1);
        headerContainer.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"headerSectionContainer");
        headerContainer.setLayout((Layout)new GridLayout(2, false));
        headerContainer.setLayoutData((Object)new GridData(768));
        final Label iconLabel = new Label(headerContainer, 0);
        iconLabel.setLayoutData((Object)new GridData(20, 20));
        final Label textLabel = new Label(headerContainer, 0);
        textLabel.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"sectionHeader");
        textLabel.setLayoutData((Object)new GridData(768));
        final ScrolledComposite scrolling = new ScrolledComposite((Composite)editingArea, 768);
        scrolling.setBackgroundMode(1);
        scrolling.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"formContainer");
        final Composite contentContainer = new Composite((Composite)scrolling, 0);
        contentContainer.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"formContainer");
        scrolling.setExpandHorizontal(true);
        scrolling.setExpandVertical(true);
        scrolling.setContent((Control)contentContainer);
        scrolling.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrolling.getClientArea();
                scrolling.setMinSize(contentContainer.computeSize(r.width, -1));
            }
        });
        scrolling.setLayoutData((Object)new GridData(1808));
        final StackLayout layout = new StackLayout();
        contentContainer.setLayout((Layout)layout);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    IStructuredSelection s = (IStructuredSelection)event.getSelection();
                    if (s.getFirstElement() instanceof EObject) {
                        EObject obj = (EObject)s.getFirstElement();
                        AbstractComponentEditor editor = (AbstractComponentEditor)ModelEditor.this.editorMap.get(obj.eClass());
                        if (editor != null) {
                            textLabel.setText(editor.getLabel(obj));
                            iconLabel.setImage(editor.getImage(obj, iconLabel.getDisplay()));
                            Composite comp = editor.getEditor(contentContainer, s.getFirstElement());
                            comp.setBackgroundMode(1);
                            layout.topControl = comp;
                            contentContainer.layout(true);
                        }
                    } else {
                        VirtualEntry entry = (VirtualEntry)s.getFirstElement();
                        AbstractComponentEditor editor = ModelEditor.this.virtualEditors[entry.getId()];
                        if (editor != null) {
                            textLabel.setText(editor.getLabel(entry));
                            iconLabel.setImage(editor.getImage(entry, iconLabel.getDisplay()));
                            Composite comp = editor.getEditor(contentContainer, s.getFirstElement());
                            comp.setBackgroundMode(1);
                            layout.topControl = comp;
                            contentContainer.layout(true);
                        }
                    }
                    Rectangle r = scrolling.getClientArea();
                    scrolling.setMinSize(contentContainer.computeSize(r.width, -1));
                }
            }
        });
        form.setWeights(new int[]{1, 2});
        this.viewer.setSelection((ISelection)new StructuredSelection((List)modelProvider.getRoot()));
    }

    private TreeViewer createTreeViewerArea(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"formContainer");
        parent.setBackgroundMode(1);
        FillLayout l = new FillLayout();
        l.marginWidth = 5;
        parent.setLayout((Layout)l);
        ShadowComposite editingArea = new ShadowComposite(parent, 0);
        editingArea.setLayout((Layout)new FillLayout());
        final TreeViewer viewer = new TreeViewer((Composite)editingArea, 66304);
        viewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider(this));
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider((IObservableFactory)new ObservableFactoryImpl(), (TreeStructureAdvisor)new TreeStructureAdvisorImpl());
        viewer.setContentProvider((IContentProvider)contentProvider);
        final WritableSet clearedSet = new WritableSet();
        contentProvider.getKnownElements().addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                for (Object o : event.diff.getAdditions()) {
                    if (!(o instanceof EObject)) continue;
                    clearedSet.add(o);
                }
                for (Object o : event.diff.getRemovals()) {
                    if (!(o instanceof EObject)) continue;
                    clearedSet.remove(o);
                }
            }
        });
        for (FeaturePath p : this.labelFeaturePaths) {
            IObservableMap map = EMFProperties.value((FeaturePath)p).observeDetail((IObservableSet)clearedSet);
            map.addMapChangeListener(new IMapChangeListener(){

                public void handleMapChange(MapChangeEvent event) {
                    viewer.update(event.diff.getChangedKeys().toArray(), null);
                }
            });
        }
        viewer.setInput((Object)this.modelProvider.getRoot());
        viewer.expandAll();
        return viewer;
    }

    private void registerVirtualEditors() {
        AbstractComponentEditor[] abstractComponentEditorArray = new AbstractComponentEditor[11];
        abstractComponentEditorArray[0] = new VMenuEditor(this.modelProvider.getEditingDomain(), this);
        abstractComponentEditorArray[2] = new VHandlerEditor(this.modelProvider.getEditingDomain(), this);
        abstractComponentEditorArray[3] = new VBindingTableEditor(this.modelProvider.getEditingDomain(), this);
        abstractComponentEditorArray[4] = new VCommandEditor(this.modelProvider.getEditingDomain(), this, (EStructuralFeature)MApplicationPackage.Literals.APPLICATION__COMMANDS);
        abstractComponentEditorArray[5] = new VWindowEditor(this.modelProvider.getEditingDomain(), this);
        abstractComponentEditorArray[6] = new VControlEditor(this.modelProvider.getEditingDomain(), this);
        abstractComponentEditorArray[7] = new VWindowTrimEditor(this.modelProvider.getEditingDomain(), this);
        abstractComponentEditorArray[8] = new VPartDescriptor(this.modelProvider.getEditingDomain(), this);
        abstractComponentEditorArray[9] = new VCommandEditor(this.modelProvider.getEditingDomain(), this, (EStructuralFeature)MApplicationPackage.Literals.MODEL_COMPONENT__COMMANDS);
        abstractComponentEditorArray[10] = new VModelComponentBindingEditor(this.modelProvider.getEditingDomain(), this);
        this.virtualEditors = abstractComponentEditorArray;
    }

    public void setSelection(Object element) {
        this.viewer.setSelection((ISelection)new StructuredSelection(element));
    }

    private void registerDefaultEditors() {
        this.registerEditor(MApplicationPackage.Literals.APPLICATION, new ApplicationEditor(this.modelProvider.getEditingDomain()));
        this.registerEditor(MApplicationPackage.Literals.MODEL_COMPONENTS, new ModelComponentsEditor(this.modelProvider.getEditingDomain(), this));
        this.registerEditor(MApplicationPackage.Literals.MODEL_COMPONENT, new ModelComponentEditor(this.modelProvider.getEditingDomain()));
        this.registerEditor(MApplicationPackage.Literals.PART, new PartEditor(this.modelProvider.getEditingDomain(), this.project));
        this.registerEditor(MApplicationPackage.Literals.PART_DESCRIPTOR, new PartDescriptorEditor(this.modelProvider.getEditingDomain(), this.project));
        this.registerEditor(MApplicationPackage.Literals.KEY_BINDING, new KeyBindingEditor(this.modelProvider.getEditingDomain(), this.modelProvider));
        this.registerEditor(MApplicationPackage.Literals.HANDLER, new HandlerEditor(this.modelProvider.getEditingDomain(), this.modelProvider, this.project));
        this.registerEditor(MApplicationPackage.Literals.COMMAND, new CommandEditor(this.modelProvider.getEditingDomain()));
        this.registerEditor(MApplicationPackage.Literals.WINDOW, new WindowEditor(this.modelProvider.getEditingDomain()));
        this.registerEditor(MApplicationPackage.Literals.PART_SASH_CONTAINER, new PartSashContainerEditor(this.modelProvider.getEditingDomain(), this));
        this.registerEditor(MApplicationPackage.Literals.PART_STACK, new PartStackEditor(this.modelProvider.getEditingDomain(), this));
        this.registerEditor(MApplicationPackage.Literals.WINDOW_TRIM, new WindowTrimEditor(this.modelProvider.getEditingDomain(), this));
        this.registerEditor(MApplicationPackage.Literals.TOOL_BAR, new ToolBarEditor(this.modelProvider.getEditingDomain(), this));
        this.registerEditor(MApplicationPackage.Literals.DIRECT_TOOL_ITEM, new DirectToolItemEditor(this.modelProvider.getEditingDomain(), this.project));
        this.registerEditor(MApplicationPackage.Literals.HANDLED_TOOL_ITEM, new HandledToolItemEditor(this.modelProvider.getEditingDomain()));
        this.registerEditor(MApplicationPackage.Literals.TOOL_ITEM, new ToolItemEditor(this.modelProvider.getEditingDomain()));
        this.registerEditor(MApplicationPackage.Literals.PERSPECTIVE_STACK, new PerspectiveStackEditor(this.modelProvider.getEditingDomain()));
        this.registerEditor(MApplicationPackage.Literals.PERSPECTIVE, new PerspectiveEditor(this.modelProvider.getEditingDomain()));
        this.registerEditor(MApplicationPackage.Literals.PLACEHOLDER, new PlaceholderEditor(this.modelProvider.getEditingDomain()));
        this.registerEditor(MApplicationPackage.Literals.MENU, new MenuEditor(this.modelProvider.getEditingDomain(), this));
        this.registerEditor(MApplicationPackage.Literals.MENU_ITEM, new MenuItemEditor(this.modelProvider.getEditingDomain(), this));
        this.registerEditor(MApplicationPackage.Literals.HANDLED_MENU_ITEM, new HandledMenuItemEditor(this.modelProvider.getEditingDomain(), this));
        this.registerEditor(MApplicationPackage.Literals.DIRECT_MENU_ITEM, new DirectMenuItemEditor(this.modelProvider.getEditingDomain(), this, this.project));
        this.registerEditor(MApplicationPackage.Literals.BINDING_TABLE, new BindingTableEditor(this.modelProvider.getEditingDomain(), this));
        this.registerEditor(MApplicationPackage.Literals.INPUT_PART, new InputPartEditor(this.modelProvider.getEditingDomain(), this.project));
    }

    public void registerEditor(EClass eClass, AbstractComponentEditor editor) {
        this.editorMap.put(eClass, editor);
        FeaturePath[] featurePathArray = editor.getLabelProperties();
        int n = featurePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeaturePath p = featurePathArray[n2];
            boolean found = false;
            for (FeaturePath tmp : this.labelFeaturePaths) {
                if (!this.equalsPaths(p, tmp)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.labelFeaturePaths.add(p);
            }
            ++n2;
        }
    }

    private boolean equalsPaths(FeaturePath p1, FeaturePath p2) {
        if (p1.getFeaturePath().length == p2.getFeaturePath().length) {
            int i = 0;
            while (i < p1.getFeaturePath().length) {
                if (!p1.getFeaturePath()[i].equals(p2.getFeaturePath()[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public AbstractComponentEditor getEditor(EClass eClass) {
        return this.editorMap.get(eClass);
    }

    public IStatus save() {
        if (this.modelProvider.isSaveable()) {
            return this.modelProvider.save();
        }
        return Status.CANCEL_STATUS;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private class ObservableFactoryImpl
    implements IObservableFactory {
        private ObservableFactoryImpl() {
        }

        public IObservable createObservable(Object target) {
            if (target instanceof IObservableList) {
                return (IObservable)target;
            }
            if (target instanceof VirtualEntry) {
                return ((VirtualEntry)target).getList();
            }
            AbstractComponentEditor editor = (AbstractComponentEditor)ModelEditor.this.editorMap.get(((EObject)target).eClass());
            if (editor != null) {
                return editor.getChildList(target);
            }
            return null;
        }
    }

    private static class TreeStructureAdvisorImpl
    extends TreeStructureAdvisor {
        private TreeStructureAdvisorImpl() {
        }
    }
}

