/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MUILabel;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.swt.internal.AbstractPartRenderer;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtiltities;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.IResourceUtiltities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SWTPartRenderer
extends AbstractPartRenderer {
    public void processContents(MElementContainer<MUIElement> container) {
        if (container == null) {
            return;
        }
        EList parts = container.getChildren();
        if (parts != null) {
            MUIElement[] plist = (MUIElement[])parts.toArray((Object[])new MUIElement[parts.size()]);
            int i = 0;
            while (i < plist.length) {
                MUIElement childME = plist[i];
                IPresentationEngine renderer = (IPresentationEngine)this.context.get(IPresentationEngine.class.getName());
                renderer.createGui(childME);
                ++i;
            }
        }
    }

    public void setCSSInfo(MUIElement me, Object widget) {
        IStylingEngine engine = (IStylingEngine)this.getContext(me).get(IStylingEngine.SERVICE_NAME);
        EObject eObj = (EObject)me;
        String cssClassStr = String.valueOf('M') + eObj.eClass().getName();
        for (String tag : me.getTags()) {
            cssClassStr = String.valueOf(cssClassStr) + ' ' + tag;
        }
        engine.setClassname(widget, cssClassStr);
        engine.setId(widget, me.getId());
    }

    public void bindWidget(MUIElement me, Object widget) {
        me.setWidget(widget);
        ((Widget)widget).setData("modelElement", (Object)me);
        me.setRenderer((Object)this);
        this.setCSSInfo(me, widget);
        Widget swtWidget = (Widget)widget;
        swtWidget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MUIElement element = (MUIElement)e.widget.getData("modelElement");
                if (element != null) {
                    SWTPartRenderer.this.unbindWidget(element);
                }
            }
        });
    }

    public Object unbindWidget(MUIElement me) {
        Widget widget = (Widget)me.getWidget();
        if (widget != null) {
            me.setWidget(null);
            if (!widget.isDisposed()) {
                widget.setData("modelElement", null);
            }
        }
        me.setRenderer(null);
        return widget;
    }

    protected Widget getParentWidget(MUIElement element) {
        return (Widget)element.getParent().getWidget();
    }

    public void disposeWidget(MUIElement element) {
        Widget curWidget = (Widget)element.getWidget();
        if (curWidget != null && !curWidget.isDisposed()) {
            this.unbindWidget(element);
            curWidget.dispose();
        }
        element.setWidget(null);
    }

    public void hookControllerLogic(final MUIElement me) {
        Widget widget = (Widget)me.getWidget();
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MUIElement model = (MUIElement)e.widget.getData("modelElement");
                if (model != null) {
                    model.setWidget(null);
                }
            }
        });
        if (widget instanceof Control && me instanceof MUILabel) {
            ((Control)widget).getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = ((MUILabel)me).getLabel();
                }
            });
        }
    }

    protected Image getImage(MUILabel element) {
        ISWTResourceUtiltities resUtils;
        ImageDescriptor desc;
        IEclipseContext localContext = this.context;
        String iconURI = element.getIconURI();
        if (iconURI != null && iconURI.length() > 0 && (desc = (ImageDescriptor)(resUtils = (ISWTResourceUtiltities)localContext.get(IResourceUtiltities.class.getName())).imageDescriptorFromURI(URI.createURI((String)iconURI))) != null) {
            return desc.createImage();
        }
        return null;
    }

    protected int calcVisibleIndex(MUIElement element) {
        MElementContainer parent = element.getParent();
        int curIndex = 0;
        for (MUIElement child : parent.getChildren()) {
            if (child == element) {
                return curIndex;
            }
            if (child.getWidget() == null) continue;
            ++curIndex;
        }
        return -1;
    }

    protected Composite createWrapperForStyling(Composite parentWidget, IEclipseContext context) {
        Composite layoutHolder = new Composite(parentWidget, 0);
        this.addLayoutForStyling(layoutHolder);
        layoutHolder.setData("org.eclipse.e4.ui.css.swt.marginWrapper", (Object)true);
        IStylingEngine engine = (IStylingEngine)context.get(IStylingEngine.SERVICE_NAME);
        engine.setClassname((Object)layoutHolder, "marginWrapper");
        return layoutHolder;
    }

    protected void addLayoutForStyling(Composite composite) {
        GridLayout gl = new GridLayout(1, true);
        composite.setLayout((Layout)gl);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
    }

    protected void configureForStyling(Control control) {
        control.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
    }
}

