/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import org.eclipse.core.internal.resources.semantic.ISemanticFileStoreInternal;
import org.eclipse.core.internal.resources.semantic.SemanticResourceAdapterImpl;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class SemanticFileAdapterImpl
extends SemanticResourceAdapterImpl
implements ISemanticFile {
    private final IFile file;

    SemanticFileAdapterImpl(IFile file, ISemanticFileSystem fileSystem) {
        super((IResource)file, fileSystem);
        this.file = file;
    }

    public IFile getAdaptedFile() {
        return this.file;
    }

    public IStatus validateEdit(Object shell) {
        try {
            this.checkCurrentRule(SemanticResourceAdapterImpl.RuleType.VALIDATE_EDIT);
            ISemanticFileStoreInternal store = this.getOwnStore();
            return store.validateEdit(shell);
        }
        catch (CoreException e) {
            if (SfsTraceLocation.TEAM.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.TEAM.getLocation(), e.getMessage(), (Throwable)e);
            }
            return e.getStatus();
        }
    }

    public IStatus validateSave() {
        try {
            ISemanticFileStoreInternal store = this.getOwnStore();
            return store.validateSave();
        }
        catch (CoreException e) {
            if (SfsTraceLocation.TEAM.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.TEAM.getLocation(), e.getMessage(), (Throwable)e);
            }
            return e.getStatus();
        }
    }

    public void revertChanges(int options, IProgressMonitor monitor) throws CoreException {
        ISchedulingRule rule = this.checkCurrentRule(SemanticResourceAdapterImpl.RuleType.MODIFY);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.revertChanges(monitor);
        this.refreshLocalIfNeeded(SemanticResourceAdapterImpl.RuleType.MODIFY, rule, options, monitor);
    }
}

