/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.internal.resources.semantic.Messages;
import org.eclipse.core.internal.resources.semantic.SemanticFileStore;
import org.eclipse.core.internal.resources.semantic.SemanticFileSystemLog;
import org.eclipse.core.internal.resources.semantic.SemanticResourcesPlugin;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.internal.resources.semantic.Util;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.ResourceTreeNode;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.SemanticDB;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.SemanticResourceDBFactory;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.SemanticResourceDBPackage;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.TreeNodeType;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.TreeRoot;
import org.eclipse.core.internal.resources.semantic.util.ISemanticFileSystemLog;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticURILocatorService;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class SemanticFileSystem
extends FileSystem
implements ISemanticFileSystem {
    protected static final QualifiedName ATTRIBUTE_URI = new QualifiedName("org.eclipse.core.resources.semantic", "URIString");
    private static final String METADATA_FILENAME = "metadata.xmi";
    private static final IPath EMPTY = new Path("");
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private final ISemanticFileSystemLog log = new SemanticFileSystemLog();
    private SemanticDB db;
    Resource metadataResource;
    private SemanticURILocatorService uriLocator;
    private boolean isDelayedFlush = false;
    private boolean needsFlush = false;

    public SemanticFileSystem() {
        this.init();
    }

    public String[] getRootNames() throws CoreException {
        if (this.db == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.SFS_DB_NOT_INITIALIZED, EMPTY, Messages.SemanticFileSystem_NotInitialized_XMSG);
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.lockForRead();
            EList<TreeRoot> roots = this.db.getRoots();
            for (TreeRoot treeRoot : roots) {
                result.add(treeRoot.getName());
            }
        }
        finally {
            this.unlockForRead();
        }
        return result.toArray(new String[0]);
    }

    public void requestFlush(boolean force) throws CoreException {
        this.needsFlush = true;
        if (!this.isDelayedFlush || force) {
            this.saveSemanticDB();
        }
    }

    public IFileStore getStore(java.net.URI uri) {
        if ("semanticfs".equals(uri.getScheme())) {
            return this.getFileStoreImplementation(uri);
        }
        return EFS.getNullFileSystem().getStore(uri);
    }

    private IFileStore getFileStoreImplementation(java.net.URI uri) {
        String pathString = uri.getPath();
        Path path = pathString != null ? new Path(null, pathString) : Path.EMPTY;
        if (this.db == null) {
            return EFS.getNullFileSystem().getStore((IPath)path);
        }
        if (path.segmentCount() > 0) {
            TreeRoot treeRoot;
            try {
                this.lockForRead();
                EList<TreeRoot> roots = this.db.getRoots();
                for (TreeRoot treeRoot2 : roots) {
                    if (!path.segment(0).equals(treeRoot2.getName())) continue;
                    if (path.segmentCount() == 1) {
                        SemanticFileStore semanticFileStore = this.getStore(treeRoot2);
                        return semanticFileStore;
                    }
                    IFileStore iFileStore = this.getFileStoreRecursive((IPath)path, treeRoot2);
                    return iFileStore;
                }
            }
            finally {
                this.unlockForRead();
            }
            try {
                this.lockForWrite();
                treeRoot = this.createRootNode(path.segment(0));
            }
            finally {
                this.unlockForWrite();
            }
            try {
                Object object;
                this.lockForRead();
                if (path.segmentCount() == 1) {
                    object = this.getStore(treeRoot);
                    return object;
                }
                object = this.getFileStoreRecursive((IPath)path, treeRoot);
                return object;
            }
            finally {
                this.unlockForRead();
            }
        }
        return EFS.getNullFileSystem().getStore((IPath)path);
    }

    private IFileStore getFileStoreRecursive(IPath path, ResourceTreeNode rootNode) {
        String[] segments = path.segments();
        ResourceTreeNode currentNode = rootNode;
        boolean ready = true;
        int i = 1;
        while (i < segments.length) {
            String name = segments[i];
            EList<ResourceTreeNode> children = currentNode.getChildren();
            boolean found = false;
            for (ResourceTreeNode resourceTreeNode : children) {
                if (!resourceTreeNode.getName().equals(name)) continue;
                currentNode = resourceTreeNode;
                found = true;
                break;
            }
            if (!found) {
                ready = false;
                break;
            }
            ++i;
        }
        if (ready) {
            return this.getStore(currentNode);
        }
        return EFS.getNullFileSystem().getStore(path);
    }

    protected SemanticFileStore getStore(ResourceTreeNode node) {
        return new SemanticFileStore(this, node);
    }

    private void init() {
        File metadataFolder = SemanticResourcesPlugin.getCacheLocation().toFile();
        metadataFolder.mkdirs();
        File metadataFile = new File(metadataFolder, METADATA_FILENAME);
        String metadataLocation = metadataFile.getAbsolutePath();
        if (!metadataFile.exists()) {
            this.initSemanticDB(metadataLocation);
        } else {
            this.loadSemanticDB(metadataLocation);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadSemanticDB(String metadataLocation) {
        block8: {
            try {
                pkg = SemanticResourceDBPackage.eINSTANCE;
                pkg.eClass();
                try {
                    this.lockForWrite();
                    resourceset = new ResourceSetImpl();
                    uri = URI.createFileURI((String)metadataLocation);
                    resourceset.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
                    this.metadataResource = resourceset.createResource(uri);
                    this.metadataResource.load(null);
                    contents = this.metadataResource.getContents();
                    for (EObject eObject : contents) {
                        if (!(eObject instanceof SemanticDB)) continue;
                        this.db = (SemanticDB)eObject;
                        break;
                    }
                }
                finally {
                    this.unlockForWrite();
                }
                this.needsFlush = false;
                break block8;
            }
            catch (IOException e) {
                ** for (diagnostic : this.metadataResource.getErrors())
            }
lbl-1000:
            // 1 sources

            {
                this.log.log(new SemanticResourceException(SemanticResourceStatusCode.SFS_INITIALIZATION_ERROR, SemanticFileSystem.EMPTY, diagnostic.getMessage()));
                continue;
            }
lbl29:
            // 1 sources

            this.log.log(new SemanticResourceException(SemanticResourceStatusCode.SFS_INITIALIZATION_ERROR, SemanticFileSystem.EMPTY, Messages.SemanticFileSystem_SFSInitError_XMSG, e));
        }
    }

    private void initSemanticDB(String metadataLocation) {
        try {
            this.lockForWrite();
            ResourceSetImpl resourceset = new ResourceSetImpl();
            URI uri = URI.createFileURI((String)metadataLocation);
            this.metadataResource = resourceset.createResource(uri);
            this.db = SemanticResourceDBFactory.eINSTANCE.createSemanticDB();
            this.metadataResource.getContents().add((Object)this.db);
            this.needsFlush = true;
        }
        finally {
            this.unlockForWrite();
        }
    }

    private TreeRoot createRootNode(String name) {
        TreeRoot root = SemanticResourceDBFactory.eINSTANCE.createTreeRoot();
        root.setName(name);
        root.setExists(false);
        root.setType(TreeNodeType.PROJECT);
        root.setParentDB(this.db);
        return root;
    }

    private void saveSemanticDB() throws CoreException {
        block6: {
            try {
                if (!this.needsFlush) break block6;
                if (SfsTraceLocation.CORE_DB.isActive()) {
                    SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.CORE_DB.getLocation());
                }
                try {
                    this.lockForWrite();
                    this.metadataResource.save(null);
                    this.needsFlush = false;
                }
                finally {
                    this.unlockForWrite();
                }
            }
            catch (IOException e) {
                SemanticResourceException ex = new SemanticResourceException(SemanticResourceStatusCode.SFS_ERROR_WRITING_METADATA, EMPTY, Messages.SemanticFileSystem_SFSUpdateError_XMSG, e);
                throw ex;
            }
        }
    }

    protected void lockForRead() {
        this.readLock.lock();
    }

    protected void unlockForRead() {
        this.readLock.unlock();
    }

    protected void lockForWrite() {
        this.writeLock.lock();
    }

    protected void unlockForWrite() {
        this.writeLock.unlock();
    }

    public String getPathToDb() {
        File metadataFolder = SemanticResourcesPlugin.getCacheLocation().toFile();
        metadataFolder.mkdirs();
        File metadataFile = new File(metadataFolder, METADATA_FILENAME);
        String metadataLocation = metadataFile.getAbsolutePath();
        return metadataLocation;
    }

    public ISemanticFileSystemLog getLog() {
        return this.log;
    }

    public ISemanticURILocatorService getURILocatorService(IProgressMonitor monitor) throws CoreException {
        try {
            this.lockForWrite();
            if (this.uriLocator == null) {
                this.uriLocator = new SemanticURILocatorService(this);
                this.uriLocator.rebuildMapping(monitor);
            }
            SemanticURILocatorService semanticURILocatorService = this.uriLocator;
            return semanticURILocatorService;
        }
        finally {
            this.unlockForWrite();
        }
    }

    public void requestURILocatorRebuild() {
        if (this.uriLocator != null) {
            this.uriLocator.requestRebuild();
        }
    }

    public SemanticURILocatorService getURILocator() {
        return this.uriLocator;
    }

    static final class SemanticURILocatorService
    implements ISemanticURILocatorService {
        private HashMap<String, ArrayList<IPath>> uri2pathMapping = new HashMap();
        final SemanticFileSystem fs;
        boolean needsRebuild;

        public SemanticURILocatorService(SemanticFileSystem fs) {
            this.fs = fs;
        }

        public IPath[] locateURI(java.net.URI uri) throws CoreException {
            try {
                ArrayList<IPath> paths;
                this.fs.lockForWrite();
                if (this.needsRebuild) {
                    this.rebuildMapping(null);
                }
                if ((paths = this.uri2pathMapping.get(uri.toString())) != null) {
                    IPath[] iPathArray = paths.toArray(new IPath[paths.size()]);
                    return iPathArray;
                }
                IPath[] iPathArray = new IPath[]{};
                return iPathArray;
            }
            finally {
                this.fs.unlockForWrite();
            }
        }

        public IPath[] locateURI(java.net.URI uri, IPath rootpath) throws CoreException {
            try {
                ArrayList<IPath> paths;
                this.fs.lockForWrite();
                if (this.needsRebuild) {
                    this.rebuildMapping(null);
                }
                if ((paths = this.uri2pathMapping.get(uri.toString())) != null) {
                    ArrayList<IPath> filteredpaths = new ArrayList<IPath>();
                    for (IPath iPath : paths) {
                        if (!rootpath.isPrefixOf(iPath)) continue;
                        filteredpaths.add(iPath);
                    }
                    IPath[] iPathArray = filteredpaths.toArray(new IPath[filteredpaths.size()]);
                    return iPathArray;
                }
                IPath[] iPathArray = new IPath[]{};
                return iPathArray;
            }
            finally {
                this.fs.unlockForWrite();
            }
        }

        public IPath getPathForNode(ResourceTreeNode node) {
            StringBuilder sb = new StringBuilder(50);
            sb.append('/');
            sb.append(node.getName());
            ResourceTreeNode parent = node.getParent();
            while (parent != null) {
                sb.insert(0, parent.getName());
                sb.insert(0, '/');
                parent = parent.getParent();
            }
            return new Path(sb.toString());
        }

        public void rebuildMapping(IProgressMonitor monitor) {
            this.uri2pathMapping.clear();
            String keyString = Util.qualifiedNameToString(ATTRIBUTE_URI);
            TreeIterator contents = this.fs.metadataResource.getAllContents();
            while (contents.hasNext()) {
                String uriString;
                ResourceTreeNode node;
                EObject eObject = (EObject)contents.next();
                if (!(eObject instanceof ResourceTreeNode) || (node = (ResourceTreeNode)eObject).getPersistentProperties() == null || (uriString = node.getPersistentProperties().get(keyString)) == null) continue;
                this.addURI(this.getPathForNode(node), uriString);
            }
            this.needsRebuild = false;
        }

        public void addURI(IPath path, String uriString) {
            ArrayList<Object> paths = this.uri2pathMapping.get(uriString);
            if (paths != null) {
                paths.add(path);
            } else {
                paths = new ArrayList();
                paths.add(path);
                this.uri2pathMapping.put(uriString, paths);
            }
        }

        public void removeURI(IPath path, String uriString) {
            ArrayList<IPath> paths = this.uri2pathMapping.get(uriString);
            paths.remove(path);
            if (paths.isEmpty()) {
                this.uri2pathMapping.remove(uriString);
            }
        }

        public void requestRebuild() {
            this.needsRebuild = true;
        }
    }
}

