/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.semantic.ISemanticFileStoreInternal;
import org.eclipse.core.internal.resources.semantic.Messages;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SemanticResourceAdapterImpl
implements ISemanticResource {
    private final IResource resource;

    SemanticResourceAdapterImpl(IResource resource, ISemanticFileSystem fileSystem) {
        this.resource = resource;
    }

    @Override
    public IResource getAdaptedResource() {
        return this.resource;
    }

    protected ISemanticFileStoreInternal getOwnStore() throws CoreException {
        URI uri = this.resource.getLocationURI();
        try {
            IFileStore store = EFS.getStore((URI)uri);
            if (store instanceof ISemanticFileStoreInternal) {
                return (ISemanticFileStoreInternal)store;
            }
            if (store.getFileSystem() == EFS.getNullFileSystem()) {
                throw new SemanticResourceException(SemanticResourceStatusCode.STORE_NOT_FOUND, this.resource.getFullPath(), Messages.SemanticResourceAdapterImpl_NullFile_XMSG);
            }
            throw new SemanticResourceException(SemanticResourceStatusCode.STORE_NOT_FOUND, this.resource.getFullPath(), NLS.bind((String)Messages.SemanticResourceAdapterImpl_NoSemanticStore_XMSG, (Object)uri.toString()));
        }
        catch (CoreException e) {
            throw new SemanticResourceException(SemanticResourceStatusCode.STORE_NOT_FOUND, this.resource.getFullPath(), null, e);
        }
    }

    protected ISchedulingRule checkCurrentRule(RuleType ruleType) throws CoreException {
        Job job = Job.getJobManager().currentJob();
        if (job != null) {
            ISchedulingRule checkRule = this.getRuleForType(ruleType, this.resource);
            ISchedulingRule rule = job.getRule();
            if (rule != null) {
                if (!rule.contains(checkRule)) {
                    throw new SemanticResourceException(SemanticResourceStatusCode.LOCK_CONFLICT, this.resource.getFullPath(), Messages.SemanticResourceAdapterImpl_OperationNotCoveredByRule_XMSG);
                }
            } else if (SfsTraceLocation.CORE.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), Messages.SemanticResourceAdapterImpl_JobNoRule_XMSG);
                SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE.getLocation());
            }
            return checkRule;
        }
        throw new SemanticResourceException(SemanticResourceStatusCode.CALLED_OUTSIDE_OF_SCHEDULING_RULE, this.resource.getFullPath(), Messages.SemanticResourceAdapterImpl_CalledOutsideRule_XMSG);
    }

    private ISchedulingRule getRuleForType(RuleType ruleType, IResource actResource) throws SemanticResourceException {
        ISchedulingRule checkRule;
        if (actResource instanceof IWorkspaceRoot) {
            return actResource;
        }
        IProject project = actResource.getProject();
        if (!project.isAccessible()) {
            throw new SemanticResourceException(SemanticResourceStatusCode.PROJECT_NOT_ACCESSIBLE, actResource.getFullPath(), NLS.bind((String)Messages.SemanticResourceAdapterImpl_ProjectNotAccessible_XMSG, (Object)project.getName()));
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
        if (provider == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.PROJECT_NOT_MAPPED, actResource.getFullPath(), NLS.bind((String)Messages.SemanticResourceAdapterImpl_ProjectNotMapped_XMSG, (Object)project.getName()));
        }
        IResourceRuleFactory rf = provider.getRuleFactory();
        switch (ruleType) {
            case DELETE: {
                checkRule = rf.deleteRule(actResource);
                break;
            }
            case CREATE: {
                checkRule = rf.createRule(actResource);
                break;
            }
            case MODIFY: {
                checkRule = rf.modifyRule(actResource);
                break;
            }
            case VALIDATE_EDIT: {
                checkRule = rf.validateEditRule(new IResource[]{actResource});
                break;
            }
            default: {
                throw new RuntimeException(Messages.SemanticResourceAdapterImpl_UnknownRuleType_XMSG);
            }
        }
        return checkRule;
    }

    protected void refreshLocalIfNeeded(RuleType ruleType, ISchedulingRule rule, int options, IProgressMonitor monitor) throws CoreException {
        if ((options & 2) == 0) {
            if (rule instanceof IResource) {
                if (SfsTraceLocation.CORE.isActive()) {
                    SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.CORE.getLocation());
                }
                ((IResource)rule).refreshLocal(2, monitor);
                return;
            }
            throw new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path(""), NLS.bind((String)Messages.SemanticResourceAdapterImpl_RuleNoResource_XMSG, (Object)ruleType.name()));
        }
    }

    @Override
    public void deleteRemotely(int options, IProgressMonitor monitor) throws CoreException {
        ISchedulingRule rule = this.checkCurrentRule(RuleType.DELETE);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.deleteRemotely(monitor);
        this.refreshLocalIfNeeded(RuleType.DELETE, rule, options, monitor);
    }

    @Override
    public void remove(int options, IProgressMonitor monitor) throws CoreException {
        ISchedulingRule rule = this.checkCurrentRule(RuleType.DELETE);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.removeFromWorkspace(monitor);
        this.refreshLocalIfNeeded(RuleType.DELETE, rule, options, monitor);
    }

    @Override
    public IStatus validateRemoteDelete(Object shell) {
        try {
            ISemanticFileStoreInternal store = this.getOwnStore();
            return store.validateRemoteDelete(shell);
        }
        catch (CoreException e) {
            if (SfsTraceLocation.CORE.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), e.getMessage(), (Throwable)e);
            }
            return e.getStatus();
        }
    }

    @Override
    public IStatus validateRemove(int options, IProgressMonitor monitor) {
        try {
            ISemanticFileStoreInternal store = this.getOwnStore();
            return store.validateRemove(options, monitor);
        }
        catch (CoreException e) {
            if (SfsTraceLocation.CORE.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), e.getMessage(), (Throwable)e);
            }
            return e.getStatus();
        }
    }

    @Override
    public void synchronizeContentWithRemote(SyncDirection direction, int options, IProgressMonitor monitor) throws CoreException {
        ISchedulingRule rule = this.checkCurrentRule(RuleType.MODIFY);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.synchronizeContentWithRemote(direction, monitor);
        this.refreshLocalIfNeeded(RuleType.MODIFY, rule, options, monitor);
    }

    @Override
    public ISemanticResourceInfo fetchResourceInfo(int options, IProgressMonitor monitor) throws CoreException {
        ISemanticFileStoreInternal store = this.getOwnStore();
        return store.fetchResourceInfo(options, monitor);
    }

    @Override
    public String getContentProviderID() throws CoreException {
        ISemanticFileStoreInternal store = this.getOwnStore();
        return store.getContentProviderID();
    }

    @Override
    public IStatus lockResource(int options, IProgressMonitor monitor) throws CoreException {
        ISchedulingRule rule = this.checkCurrentRule(RuleType.MODIFY);
        ISemanticFileStoreInternal store = this.getOwnStore();
        IStatus result = store.lockResource(monitor);
        if (result.isOK()) {
            this.refreshLocalIfNeeded(RuleType.MODIFY, rule, options, monitor);
        }
        return result;
    }

    @Override
    public IStatus unlockResource(int options, IProgressMonitor monitor) throws CoreException {
        ISchedulingRule rule = this.checkCurrentRule(RuleType.MODIFY);
        ISemanticFileStoreInternal store = this.getOwnStore();
        IStatus result = store.unlockResource(monitor);
        if (result.isOK()) {
            this.refreshLocalIfNeeded(RuleType.MODIFY, rule, options, monitor);
        }
        return result;
    }

    @Override
    public Map<QualifiedName, String> getPersistentProperties() throws CoreException {
        ISemanticFileStoreInternal store = this.getOwnStore();
        return store.getPersistentProperties();
    }

    @Override
    public String getPersistentProperty(QualifiedName key) throws CoreException {
        ISemanticFileStoreInternal store = this.getOwnStore();
        return store.getPersistentProperty(key);
    }

    @Override
    public Map<QualifiedName, Object> getSessionProperties() throws CoreException {
        ISemanticFileStoreInternal store = this.getOwnStore();
        return store.getSessionProperties();
    }

    @Override
    public Object getSessionProperty(QualifiedName key) throws CoreException {
        ISemanticFileStoreInternal store = this.getOwnStore();
        return store.getSessionProperty(key);
    }

    @Override
    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        this.checkCurrentRule(RuleType.MODIFY);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.setPersistentProperty(key, value);
    }

    @Override
    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        this.checkCurrentRule(RuleType.MODIFY);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.setSessionProperty(key, value);
    }

    @Override
    public void setRemoteURI(URI uri, int options, IProgressMonitor monitor) throws CoreException {
        ISchedulingRule rule = this.checkCurrentRule(RuleType.MODIFY);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.setRemoteURI(uri, monitor);
        this.refreshLocalIfNeeded(RuleType.MODIFY, rule, options, monitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum RuleType {
        CREATE,
        DELETE,
        MODIFY,
        VALIDATE_EDIT;

    }
}

