/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.util;

import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserTreeObject;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SFSBrowserTreeContentProvider
implements ITreeContentProvider {
    private boolean hideNonExisting;
    private ISemanticFileSystem myFs;

    public Object[] getChildren(Object parentElement) {
        try {
            SFSBrowserTreeObject parent = (SFSBrowserTreeObject)parentElement;
            IPath parentPath = parent.getPath();
            String[] childNames = parent.getStore().childNames(0, null);
            ArrayList<SFSBrowserTreeObject> resultList = new ArrayList<SFSBrowserTreeObject>();
            int i = 0;
            while (i < childNames.length) {
                SFSBrowserTreeObject ob = new SFSBrowserTreeObject((IFileSystem)this.getFs(), parentPath.append(childNames[i]));
                if (!this.getHide() || ob.getInfo().exists()) {
                    resultList.add(ob);
                }
                ++i;
            }
            return resultList.toArray();
        }
        catch (CoreException e) {
            try {
                this.getFs().getLog().log(e);
            }
            catch (CoreException coreException) {}
            return new Object[0];
        }
    }

    public Object getParent(Object element) {
        SFSBrowserTreeObject actObject = (SFSBrowserTreeObject)element;
        IPath path = actObject.getPath();
        if (path.segmentCount() > 0) {
            try {
                return new SFSBrowserTreeObject((IFileSystem)this.getFs(), path.removeLastSegments(1));
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object element) {
        ISemanticFileSystem fs;
        try {
            fs = this.getFs();
        }
        catch (CoreException coreException) {
            return false;
        }
        try {
            IFileInfo[] infos;
            if (!this.getHide()) {
                if (((IFileSystem)fs).getStore(((SFSBrowserTreeObject)element).getPath()).childInfos(0, null).length <= 0) return false;
                return true;
            }
            IFileInfo[] iFileInfoArray = infos = ((IFileSystem)fs).getStore(((SFSBrowserTreeObject)element).getPath()).childInfos(0, null);
            int n = infos.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IFileInfo info = iFileInfoArray[n2];
                if (info.exists()) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            try {
                this.getFs().getLog().log(e);
                return false;
            }
            catch (CoreException coreException) {}
            return false;
        }
    }

    public Object[] getElements(Object inputElement) {
        if (this.getHide()) {
            SFSBrowserTreeObject[] objects;
            ArrayList<SFSBrowserTreeObject> resultList = new ArrayList<SFSBrowserTreeObject>();
            SFSBrowserTreeObject[] sFSBrowserTreeObjectArray = objects = (SFSBrowserTreeObject[])inputElement;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                SFSBrowserTreeObject o = sFSBrowserTreeObjectArray[n2];
                if (o.getInfo().exists()) {
                    resultList.add(o);
                }
                ++n2;
            }
            return resultList.toArray();
        }
        return (Object[])inputElement;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setHideNonExisting(boolean value) {
        this.hideNonExisting = value;
    }

    private boolean getHide() {
        return this.hideNonExisting;
    }

    private ISemanticFileSystem getFs() throws CoreException {
        if (this.myFs == null) {
            this.myFs = (ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs");
        }
        return this.myFs;
    }
}

