/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.navigator.CustomAndExpression;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.ILinkHelperExtPtConstants;
import org.eclipse.ui.internal.navigator.extensions.SkeletonLinkHelper;
import org.eclipse.ui.navigator.ILinkHelper;

public class LinkHelperDescriptor
implements ILinkHelperExtPtConstants {
    private final IConfigurationElement configElement;
    private String id;
    private Expression editorInputEnablement;
    private Expression selectionEnablement;
    private boolean hasLinkHelperFailedCreation;

    LinkHelperDescriptor(IConfigurationElement aConfigElement) {
        Assert.isNotNull((Object)aConfigElement, (String)"LinkHelperRegistry.Descriptor objects cannot be null.");
        Assert.isLegal((boolean)"linkHelper".equals(aConfigElement.getName()), (String)"LinkHelperRegistry.Descriptor objects must have the name \"linkHelper\".");
        this.configElement = aConfigElement;
        this.init();
    }

    void init() {
        this.id = this.configElement.getAttribute("id");
        IConfigurationElement[] expressions = this.configElement.getChildren("editorInputEnablement");
        Assert.isLegal((expressions.length == 1 ? 1 : 0) != 0, (String)"The linkHelper extension point requires exactly one editorInputEnablement child.");
        this.editorInputEnablement = new CustomAndExpression(expressions[0]);
        expressions = this.configElement.getChildren("selectionEnablement");
        if (expressions.length > 0 && expressions[0].getChildren() != null && expressions[0].getChildren().length > 0) {
            this.selectionEnablement = new CustomAndExpression(expressions[0]);
        }
    }

    public String getId() {
        return this.id;
    }

    public ILinkHelper createLinkHelper() {
        if (this.hasLinkHelperFailedCreation) {
            return SkeletonLinkHelper.INSTANCE;
        }
        try {
            return (ILinkHelper)this.configElement.createExecutableExtension("class");
        }
        catch (Throwable t) {
            this.hasLinkHelperFailedCreation = true;
            NavigatorPlugin.logError(0, t.getMessage(), t);
            return SkeletonLinkHelper.INSTANCE;
        }
    }

    public boolean isEnabledFor(IEditorInput anInput) {
        if (this.editorInputEnablement == null || anInput == null) {
            return false;
        }
        IEvaluationContext context = NavigatorPlugin.getEvalContext(anInput);
        return NavigatorPlugin.safeEvaluate(this.editorInputEnablement, context) == EvaluationResult.TRUE;
    }

    public boolean isEnabledFor(Object anObject) {
        if (this.selectionEnablement == null) {
            return false;
        }
        IEvaluationContext context = NavigatorPlugin.getEvalContext(anObject);
        return NavigatorPlugin.safeEvaluate(this.selectionEnablement, context) == EvaluationResult.TRUE;
    }
}

