/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCS;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTask;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskGroup;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.ICSDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.CompCSContentProvider;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.CompCSGroupValidator;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.CompCSPage;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.Messages;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.actions.CompCSAddGroupAction;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.actions.CompCSAddTaskAction;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.actions.CompCSRemoveTaskObjectAction;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.actions.CollapseAction;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CompCSMasterTreeSection
extends TreeSection
implements ICSMaster {
    private static final int F_BUTTON_ADD_TASK = 0;
    private static final int F_BUTTON_ADD_GROUP = 1;
    private static final int F_BUTTON_REMOVE = 2;
    private static final int F_BUTTON_UP = 3;
    private static final int F_BUTTON_DOWN = 4;
    private static final int F_BUTTON_PREVIEW = 5;
    private static final int F_UP_FLAG = -1;
    private static final int F_DOWN_FLAG = 1;
    private TreeViewer fTreeViewer;
    private ICompCSModel fModel;
    private CollapseAction fCollapseAction = null;
    private CompCSRemoveTaskObjectAction fRemoveTaskObjectAction;
    private CompCSAddGroupAction fAddGroupAction = new CompCSAddGroupAction();
    private CompCSAddTaskAction fAddTaskAction = new CompCSAddTaskAction();
    private CompCSGroupValidator fGroupValidator;

    public CompCSMasterTreeSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, new String[]{Messages.CompCSMasterTreeSection_addTask, Messages.CompCSMasterTreeSection_addGroup, Messages.CompCSMasterTreeSection_Remove, Messages.CompCSMasterTreeSection_Up, Messages.CompCSMasterTreeSection_Down, Messages.CompCSMasterTreeSection_Preview});
        this.fRemoveTaskObjectAction = new CompCSRemoveTaskObjectAction();
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (ICompCSModel)this.getPage().getModel();
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createTree(container, toolkit);
        toolkit.paintBordersFor(container);
        section.setText(Messages.CompCSMasterTreeSection_Content);
        section.setDescription(Messages.CompCSMasterTreeSection_sectionDesc);
        section.setClient((Control)container);
        this.initializeTreeViewer();
        this.createSectionToolbar(section, toolkit);
    }

    private void createTree(Composite container, FormToolkit toolkit) {
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 4, 2, toolkit);
        this.fTreeViewer = treePart.getTreeViewer();
        this.fTreeViewer.setContentProvider((IContentProvider)new CompCSContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)PDEUserAssistanceUIPlugin.getDefault().getLabelProvider());
        PDEUserAssistanceUIPlugin.getDefault().getLabelProvider().connect(this);
        this.createTreeListeners();
    }

    private void createTreeListeners() {
        this.fTreeViewer.addPostSelectionChangedListener((ISelectionChangedListener)new PDEFormEditor.PDEFormEditorChangeListener(this.getPage().getPDEEditor()));
    }

    public ISelection getSelection() {
        return this.fTreeViewer.getSelection();
    }

    private void initializeTreeViewer() {
        if (this.fModel == null) {
            return;
        }
        this.fTreeViewer.setInput((Object)this.fModel);
        ICompCS cheatsheet = this.fModel.getCompCS();
        this.fGroupValidator = new CompCSGroupValidator(cheatsheet, this.getManagedForm().getForm().getForm(), Messages.CompCSMasterTreeSection_content);
        boolean addFlag = false;
        if (cheatsheet.getFieldTaskObject() == null) {
            addFlag = this.fModel.isEditable();
        }
        this.getTreePart().setButtonEnabled(0, addFlag);
        this.getTreePart().setButtonEnabled(1, addFlag);
        this.getTreePart().setButtonEnabled(2, false);
        this.getTreePart().setButtonEnabled(3, false);
        this.getTreePart().setButtonEnabled(4, false);
        this.updatePreviewButton(this.fGroupValidator.validate());
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)cheatsheet), true);
        this.fTreeViewer.expandToLevel(2);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        this.fCollapseAction = new CollapseAction((AbstractTreeViewer)this.fTreeViewer, Messages.CompCSMasterTreeSection_collapseAll, 1, (Object)this.fModel.getCompCS());
        toolBarManager.add((IAction)this.fCollapseAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAddTaskAction();
                break;
            }
            case 1: {
                this.handleAddGroupAction();
                break;
            }
            case 2: {
                this.handleDeleteAction();
                break;
            }
            case 3: {
                this.handleMoveTaskObjectAction(-1);
                break;
            }
            case 4: {
                this.handleMoveTaskObjectAction(1);
                break;
            }
            case 5: {
                this.handlePreviewAction();
            }
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.updateButtons();
    }

    public void updateButtons() {
        if (!this.fModel.isEditable()) {
            return;
        }
        Object object = ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
        ICompCSObject csObject = (ICompCSObject)object;
        boolean canAddTask = false;
        boolean canAddGroup = false;
        boolean canRemove = false;
        boolean canMoveUp = false;
        boolean canMoveDown = false;
        if (csObject != null) {
            ICompCSObject parent = csObject.getParent();
            if (csObject.getType() == 2 || csObject.getType() == 1) {
                if (parent.getType() == 0 && csObject.getType() == 1) {
                    canAddTask = true;
                    canAddGroup = true;
                } else if (parent.getType() == 1) {
                    ICompCSTaskGroup taskGroup = (ICompCSTaskGroup)parent;
                    ICompCSTaskObject taskObject = (ICompCSTaskObject)csObject;
                    if (!taskGroup.isFirstFieldTaskObject(taskObject)) {
                        canMoveUp = true;
                    }
                    if (!taskGroup.isLastFieldTaskObject(taskObject)) {
                        canMoveDown = true;
                    }
                    canRemove = this.canRemoveTaskObject((ICompCSObject)taskGroup);
                    canAddTask = true;
                    canAddGroup = true;
                }
            }
        }
        this.getTreePart().setButtonEnabled(0, canAddTask);
        this.getTreePart().setButtonEnabled(1, canAddGroup);
        this.getTreePart().setButtonEnabled(2, canRemove);
        this.getTreePart().setButtonEnabled(3, canMoveUp);
        this.getTreePart().setButtonEnabled(4, canMoveDown);
    }

    private void handleAddTaskAction() {
        ISelection sel = this.fTreeViewer.getSelection();
        Object object = ((IStructuredSelection)sel).getFirstElement();
        if (object == null) {
            return;
        }
        if (object instanceof ICompCSTaskGroup) {
            this.fAddTaskAction.setParentObject((ICompCSObject)object);
            this.fAddTaskAction.run();
        } else if (object instanceof ICompCSTask) {
            this.fAddTaskAction.setParentObject(((ICompCSObject)object).getParent());
            this.fAddTaskAction.run();
        }
    }

    private void updatePreviewButton(boolean flag) {
        this.getTreePart().setButtonEnabled(5, flag);
    }

    private void handleAddGroupAction() {
        ISelection sel = this.fTreeViewer.getSelection();
        Object object = ((IStructuredSelection)sel).getFirstElement();
        if (object == null) {
            return;
        }
        if (object instanceof ICompCSTaskGroup) {
            this.fAddGroupAction.setParentObject((ICompCSObject)object);
            this.fAddGroupAction.run();
        } else if (object instanceof ICompCSTask) {
            this.fAddGroupAction.setParentObject(((ICompCSObject)object).getParent());
            this.fAddGroupAction.run();
        }
    }

    private void handleMoveTaskObjectAction(int positionFlag) {
        ISelection sel = this.fTreeViewer.getSelection();
        Object object = ((IStructuredSelection)sel).getFirstElement();
        if (object == null) {
            return;
        }
        if (object instanceof ICompCSTaskObject) {
            ICompCSTaskObject taskObject = (ICompCSTaskObject)object;
            ICompCSTaskGroup parent = null;
            if (taskObject.getParent().getType() != 1) {
                return;
            }
            parent = (ICompCSTaskGroup)taskObject.getParent();
            parent.moveFieldTaskObject(taskObject, positionFlag);
        }
    }

    private void handlePreviewAction() {
        IEditorInput input = this.getPage().getEditorInput();
        URL url = null;
        try {
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                url = fileInput.getFile().getLocationURI().toURL();
            } else if (input instanceof IStorageEditorInput) {
                IStorageEditorInput storageInput = (IStorageEditorInput)input;
                url = storageInput.getStorage().getFullPath().toFile().toURI().toURL();
            } else {
                url = null;
            }
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            this.fModel.getCompCS().write("", writer);
            writer.flush();
            swriter.close();
            OpenCheatSheetAction openAction = new OpenCheatSheetAction(input.getName(), input.getName(), swriter.toString(), url);
            openAction.run();
        }
        catch (IOException e) {
            PDEUserAssistanceUIPlugin.logException(e);
        }
        catch (CoreException e) {
            PDEUserAssistanceUIPlugin.logException(e);
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.handleModelEventWorldChanged(event);
        } else if (event.getChangeType() == 1) {
            this.handleModelInsertType(event);
        } else if (event.getChangeType() == 2) {
            this.handleModelRemoveType(event);
        } else if (event.getChangeType() == 3) {
            this.handleModelChangeType(event);
        }
        this.updatePreviewButton(this.fGroupValidator.validate());
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ICompCSObject object = (ICompCSObject)objects[0];
        if (object == null) {
            return;
        }
        if (object.getType() == 0) {
            CompCSPage page = (CompCSPage)this.getPage();
            IDetailsPage previousDetailsPage = page.getBlock().getDetailsPart().getCurrentPage();
            this.fModel = ((ICompCS)object).getModel();
            this.fTreeViewer.setInput((Object)this.fModel);
            this.initializeTreeViewer();
            IDetailsPage currentDetailsPage = page.getBlock().getDetailsPart().getCurrentPage();
            if (currentDetailsPage.equals(previousDetailsPage) && currentDetailsPage instanceof ICSDetails) {
                ((ICSDetails)currentDetailsPage).updateFields();
            }
        }
    }

    private void handleModelInsertType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ICompCSObject object = (ICompCSObject)objects[0];
        if (object != null) {
            if (object.getType() == 2) {
                this.handleTaskObjectInsert(object);
            } else if (object.getType() == 1) {
                this.handleTaskObjectInsert(object);
                this.fGroupValidator.addGroup((ICompCSTaskGroup)object);
            }
        }
    }

    private void handleTaskObjectInsert(ICompCSObject object) {
        this.fTreeViewer.refresh((Object)object.getParent());
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)object), true);
    }

    private void handleModelRemoveType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ICompCSObject object = (ICompCSObject)objects[0];
        if (object != null) {
            if (object.getType() == 2) {
                this.handleTaskObjectRemove(object);
            } else if (object.getType() == 1) {
                this.handleTaskObjectRemove(object);
                this.fGroupValidator.removeGroup((ICompCSTaskGroup)object);
            }
        }
    }

    private void handleTaskObjectRemove(ICompCSObject object) {
        this.fTreeViewer.remove((Object)object);
        ICompCSObject csObject = this.fRemoveTaskObjectAction.getObjectToSelect();
        if (csObject == null) {
            csObject = object.getParent();
        }
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)csObject), true);
    }

    private void handleModelChangeType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ICompCSObject object = (ICompCSObject)objects[0];
        if (object != null) {
            if (object.getType() == 2) {
                this.fTreeViewer.update((Object)object, null);
            } else if (object.getType() == 1) {
                this.fTreeViewer.update((Object)object, null);
            } else if (object.getType() == 0) {
                this.fTreeViewer.update((Object)object, null);
            }
        }
    }

    public void fireSelection() {
        this.fTreeViewer.setSelection(this.fTreeViewer.getSelection());
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.fTreeViewer.getSelection();
        Object object = ((IStructuredSelection)selection).getFirstElement();
        ICompCSObject csObject = (ICompCSObject)object;
        MenuManager submenu = new MenuManager(Messages.CompCSMasterTreeSection_new);
        manager.add((IContributionItem)submenu);
        if (csObject != null && csObject.getType() != 0) {
            if (csObject.getType() == 2) {
                this.fillContextMenuRemoveAction(manager, (ICompCSTaskObject)csObject);
            } else if (csObject.getType() == 1) {
                ICompCSTaskGroup group = (ICompCSTaskGroup)csObject;
                this.fAddTaskAction.setParentObject((ICompCSObject)group);
                this.fAddTaskAction.setEnabled(this.fModel.isEditable());
                submenu.add((IAction)this.fAddTaskAction);
                this.fAddGroupAction.setParentObject((ICompCSObject)group);
                this.fAddGroupAction.setEnabled(this.fModel.isEditable());
                submenu.add((IAction)this.fAddGroupAction);
                this.fillContextMenuRemoveAction(manager, (ICompCSTaskObject)csObject);
            }
        }
    }

    private void fillContextMenuRemoveAction(IMenuManager manager, ICompCSTaskObject taskObject) {
        manager.add((IContributionItem)new Separator());
        this.fRemoveTaskObjectAction.setTaskObject(taskObject);
        manager.add((IAction)this.fRemoveTaskObjectAction);
        ICompCSObject parent = taskObject.getParent();
        if (!this.canRemoveTaskObject(parent)) {
            this.fRemoveTaskObjectAction.setEnabled(false);
        } else {
            this.fRemoveTaskObjectAction.setEnabled(this.fModel.isEditable());
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDeleteAction();
            return true;
        }
        return false;
    }

    private void handleDeleteAction() {
        ISelection sel = this.fTreeViewer.getSelection();
        Object object = ((IStructuredSelection)sel).getFirstElement();
        if (object != null) {
            if (object instanceof ICompCSTaskObject) {
                ICompCSTaskObject taskObject = (ICompCSTaskObject)object;
                ICompCSObject parent = taskObject.getParent();
                if (!this.canRemoveTaskObject(parent)) {
                    Display.getCurrent().beep();
                } else {
                    this.fRemoveTaskObjectAction.setTaskObject(taskObject);
                    this.fRemoveTaskObjectAction.run();
                }
            } else if (object instanceof ICompCS) {
                Display.getCurrent().beep();
            }
        }
    }

    private boolean canRemoveTaskObject(ICompCSObject parent) {
        return parent.getType() != 0;
    }

    public boolean setFormInput(Object object) {
        if (object instanceof ICompCSObject) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object), true);
            ISelection selection = this.fTreeViewer.getSelection();
            if (selection != null && !selection.isEmpty()) {
                return true;
            }
        }
        return false;
    }
}

