/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Activator;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileSynchronizer {
    private static final String RECONCILER_APPLICATION_ID = "org.eclipse.equinox.p2.reconciler.application";
    private static final String TIMESTAMPS_FILE_PREFIX = "timestamps";
    private static final String PROFILE_TIMESTAMP = "PROFILE";
    private static final String NO_TIMESTAMP = "-1";
    private static final String PROP_FROM_DROPINS = "org.eclipse.equinox.p2.reconciler.dropins";
    private static final String CACHE_EXTENSIONS = "org.eclipse.equinox.p2.cache.extensions";
    private static final String PIPE = "|";
    private static final String EXPLANATION = "org.eclipse.equinox.p2.director.explain";
    final IProfile profile;
    final Map<String, IMetadataRepository> repositoryMap;
    private Map<String, String> timestamps;
    private final IProvisioningAgent agent;

    public ProfileSynchronizer(IProvisioningAgent agent, IProfile profile, Collection<IMetadataRepository> repositories) {
        this.agent = agent;
        this.profile = profile;
        this.repositoryMap = new HashMap<String, IMetadataRepository>();
        for (IMetadataRepository repository : repositories) {
            this.repositoryMap.put(repository.getLocation().toString(), repository);
        }
    }

    public IStatus synchronize(IProgressMonitor monitor) {
        this.readTimestamps();
        if (this.isUpToDate()) {
            return Status.OK_STATUS;
        }
        ProvisioningContext context = this.getContext();
        context.setProperty(EXPLANATION, new Boolean(Tracing.DEBUG_RECONCILER).toString());
        boolean done = false;
        while (!done) {
            SubMonitor sub;
            ReconcilerProfileChangeRequest request;
            block12: {
                IProvisioningPlan plan;
                block11: {
                    IStatus status;
                    block10: {
                        IStatus iStatus;
                        request = this.createProfileChangeRequest(context);
                        String updatedCacheExtensions = this.synchronizeCacheExtensions();
                        if (request == null) {
                            if (updatedCacheExtensions != null) {
                                IStatus engineResult = this.setProperty(CACHE_EXTENSIONS, updatedCacheExtensions, context, null);
                                if (engineResult.getSeverity() != 4 && engineResult.getSeverity() != 8) {
                                    this.writeTimestamps();
                                }
                                return engineResult;
                            }
                            return Status.OK_STATUS;
                        }
                        if (updatedCacheExtensions != null) {
                            request.setProfileProperty(CACHE_EXTENSIONS, updatedCacheExtensions);
                        }
                        sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        try {
                            plan = this.createProvisioningPlan(request, context, (IProgressMonitor)sub.newChild(50));
                            status = plan.getStatus();
                            if (status.getSeverity() != 4 && status.getSeverity() != 8) break block10;
                            iStatus = status;
                            done = !request.isMove;
                        }
                        catch (Throwable throwable) {
                            done = !request.isMove;
                            sub.done();
                            throw throwable;
                        }
                        sub.done();
                        return iStatus;
                    }
                    this.debug(request, plan);
                    if (!plan.getAdditions().query(QueryUtil.createIUAnyQuery(), null).isEmpty() || !plan.getRemovals().query(QueryUtil.createIUAnyQuery(), null).isEmpty()) break block11;
                    this.writeTimestamps();
                    IStatus iStatus = status;
                    done = !request.isMove;
                    sub.done();
                    return iStatus;
                }
                IStatus engineResult = this.executePlan(plan, context, (IProgressMonitor)sub.newChild(50));
                if (engineResult.getSeverity() != 4 && engineResult.getSeverity() != 8) break block12;
                IStatus iStatus = engineResult;
                done = !request.isMove;
                sub.done();
                return iStatus;
            }
            done = !request.isMove;
            sub.done();
        }
        this.writeTimestamps();
        return this.applyConfiguration(false);
    }

    private void writeTimestamps() {
        this.timestamps.clear();
        this.timestamps.put(PROFILE_TIMESTAMP, Long.toString(this.profile.getTimestamp()));
        for (Map.Entry<String, IMetadataRepository> entry : this.repositoryMap.entrySet()) {
            IMetadataRepository repository = entry.getValue();
            Map props = repository.getProperties();
            String timestamp = null;
            if (props != null) {
                timestamp = (String)props.get("p2.timestamp");
            }
            if (timestamp == null) {
                timestamp = NO_TIMESTAMP;
            }
            this.timestamps.put(entry.getKey(), timestamp);
        }
        try {
            File file = Activator.getContext().getDataFile(new StringBuffer(TIMESTAMPS_FILE_PREFIX).append(this.profile.getProfileId().hashCode()).toString());
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                CollectionUtils.storeProperties(this.timestamps, (OutputStream)os, (String)new StringBuffer("Timestamps for ").append(this.profile.getProfileId()).toString());
            }
            finally {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    private boolean isUpToDate() {
        if ("true".equals(Activator.getContext().getProperty("osgi.checkConfiguration"))) {
            return false;
        }
        String lastKnownProfileTimeStamp = this.timestamps.remove(PROFILE_TIMESTAMP);
        if (lastKnownProfileTimeStamp == null) {
            return false;
        }
        if (!lastKnownProfileTimeStamp.equals(Long.toString(this.profile.getTimestamp()))) {
            return false;
        }
        for (Map.Entry<String, IMetadataRepository> entry : this.repositoryMap.entrySet()) {
            String lastKnownTimestamp;
            IMetadataRepository repository = entry.getValue();
            Map props = repository.getProperties();
            String currentTimestamp = null;
            if (props != null) {
                currentTimestamp = (String)props.get("p2.timestamp");
            }
            if (currentTimestamp == null) {
                currentTimestamp = NO_TIMESTAMP;
            }
            if ((lastKnownTimestamp = this.timestamps.remove(entry.getKey())) == null) {
                return false;
            }
            if (lastKnownTimestamp.equals(currentTimestamp)) continue;
            return false;
        }
        return this.timestamps.size() == 0;
    }

    private void readTimestamps() {
        File file = Activator.getContext().getDataFile(new StringBuffer(TIMESTAMPS_FILE_PREFIX).append(this.profile.getProfileId().hashCode()).toString());
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                this.timestamps = CollectionUtils.loadProperties((InputStream)is);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.timestamps = new HashMap<String, String>();
        }
        catch (IOException iOException) {
            this.timestamps = new HashMap<String, String>();
        }
    }

    private ProvisioningContext getContext() {
        ArrayList<URI> repoURLs = new ArrayList<URI>();
        Iterator<String> iterator = this.repositoryMap.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                repoURLs.add(new URI(iterator.next()));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        ProvisioningContext result = new ProvisioningContext(this.agent);
        result.setMetadataRepositories(repoURLs.toArray(new URI[repoURLs.size()]));
        result.setArtifactRepositories(new URI[0]);
        return result;
    }

    private String synchronizeCacheExtensions() {
        ArrayList<String> currentExtensions = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> repositories = new ArrayList<String>(this.repositoryMap.keySet());
        final String OSGiInstallArea = new StringBuffer(String.valueOf(Activator.getOSGiInstallArea().toExternalForm())).append(".eclipseextension").toString();
        Collections.sort(repositories, new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                if (OSGiInstallArea.equals(left)) {
                    return -1;
                }
                if (OSGiInstallArea.equals(right)) {
                    return 1;
                }
                return left.compareTo(right);
            }
        });
        Iterator it = repositories.iterator();
        while (it.hasNext()) {
            String repositoryId = (String)it.next();
            try {
                IArtifactRepository repository = Activator.loadArtifactRepository(new URI(repositoryId), null);
                if (!(repository instanceof IFileArtifactRepository)) continue;
                currentExtensions.add(this.escapePipe(repositoryId));
                buffer.append(repositoryId);
                if (!it.hasNext()) continue;
                buffer.append(PIPE);
            }
            catch (ProvisionException provisionException) {
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        String currentExtensionsProperty = buffer.length() == 0 ? null : buffer.toString();
        ArrayList<String> previousExtensions = new ArrayList<String>();
        String previousExtensionsProperty = this.profile.getProperty(CACHE_EXTENSIONS);
        if (previousExtensionsProperty != null) {
            StringTokenizer tokenizer = new StringTokenizer(previousExtensionsProperty, PIPE);
            while (tokenizer.hasMoreTokens()) {
                previousExtensions.add(tokenizer.nextToken());
            }
        }
        if (previousExtensions.size() == currentExtensions.size() && previousExtensions.containsAll(currentExtensions)) {
            return null;
        }
        return currentExtensionsProperty;
    }

    private String escapePipe(String location) {
        int pipeIndex;
        String result = location;
        while ((pipeIndex = result.indexOf(44)) != -1) {
            result = new StringBuffer(String.valueOf(result.substring(0, pipeIndex))).append("%7C").append(result.substring(pipeIndex + 1)).toString();
        }
        return result;
    }

    private Map<IInstallableUnit, IInstallableUnit> getProfileIUs() {
        IQueryResult profileQueryResult = this.profile.query(QueryUtil.createIUAnyQuery(), null);
        HashMap<IInstallableUnit, IInstallableUnit> result = new HashMap<IInstallableUnit, IInstallableUnit>();
        for (IInstallableUnit iu : profileQueryResult) {
            result.put(iu, iu);
        }
        return result;
    }

    private Map<IInstallableUnit, IInstallableUnit> getAvailableProfileIUs() {
        IQueryResult profileQueryResult = this.profile.available(QueryUtil.createIUAnyQuery(), null);
        HashMap<IInstallableUnit, IInstallableUnit> result = new HashMap<IInstallableUnit, IInstallableUnit>();
        for (IInstallableUnit iu : profileQueryResult) {
            result.put(iu, iu);
        }
        return result;
    }

    public ReconcilerProfileChangeRequest createProfileChangeRequest(ProvisioningContext context) {
        ReconcilerProfileChangeRequest request = new ReconcilerProfileChangeRequest(this.profile, false);
        boolean resolve = Boolean.valueOf(this.profile.getProperty("org.eclipse.equinox.p2.resolve"));
        if (resolve) {
            request.removeProfileProperty("org.eclipse.equinox.p2.resolve");
        }
        ArrayList<IInstallableUnit> toAdd = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> toRemove = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> toMove = new ArrayList<IInstallableUnit>();
        boolean foundIUsToAdd = false;
        Map<IInstallableUnit, IInstallableUnit> profileIUs = this.getProfileIUs();
        Map<IInstallableUnit, IInstallableUnit> availableProfileIUs = this.getAvailableProfileIUs();
        IQueryResult<IInstallableUnit> allIUs = this.getAllIUsFromRepos();
        for (IInstallableUnit iu : allIUs) {
            IInstallableUnit existing = profileIUs.get(iu);
            if (existing == null) {
                if (QueryUtil.isGroup((IInstallableUnit)iu)) {
                    request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
                }
                request.setInstallableUnitProfileProperty(iu, PROP_FROM_DROPINS, Boolean.TRUE.toString());
                request.setInstallableUnitInclusionRules(iu, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
                request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.lock", Integer.toString(1));
                toAdd.add(iu);
                if (foundIUsToAdd || availableProfileIUs.get(iu) != null) continue;
                foundIUsToAdd = true;
                continue;
            }
            String one = iu.getProperty("file.name");
            String two = existing.getProperty("file.name");
            if (one == null || one.equals(two)) continue;
            toMove.add(iu);
        }
        IQueryResult dropinIUs = this.profile.query((IQuery)new IUProfilePropertyQuery(PROP_FROM_DROPINS, Boolean.TRUE.toString()), null);
        Set all = allIUs.toUnmodifiableSet();
        for (IInstallableUnit iu : dropinIUs) {
            if ("STRICT".equals(this.profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.internal.inclusion.rules"))) {
                request.removeInstallableUnitProfileProperty(iu, PROP_FROM_DROPINS);
                request.removeInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.lock");
                continue;
            }
            if (all.contains(iu)) {
                toAdd.remove(iu);
                continue;
            }
            toRemove.add(iu);
        }
        if (!foundIUsToAdd && toRemove.isEmpty() && !resolve && toMove.isEmpty()) {
            if (Tracing.DEBUG_RECONCILER) {
                Tracing.debug((String)"[reconciler] Nothing to do.");
            }
            return null;
        }
        if (!toMove.isEmpty()) {
            ReconcilerProfileChangeRequest moveRequest = new ReconcilerProfileChangeRequest(this.profile, true);
            moveRequest.removeAll(toMove);
            this.debug(request);
            return moveRequest;
        }
        context.setExtraInstallableUnits(toAdd);
        request.addAll(toAdd);
        request.removeAll(toRemove);
        this.debug(request);
        return request;
    }

    private void debug(ProfileChangeRequest request, IProvisioningPlan plan) {
        if (!Tracing.DEBUG_RECONCILER) {
            return;
        }
        ArrayList toAdd = new ArrayList(request.getAdditions());
        ArrayList toRemove = new ArrayList(request.getRemovals());
        for (IInstallableUnit iu : plan.getRemovals().query(QueryUtil.createIUAnyQuery(), null)) {
            toRemove.remove(iu);
        }
        for (IInstallableUnit iu : plan.getAdditions().query(QueryUtil.createIUAnyQuery(), null)) {
            toAdd.remove(iu);
        }
        if (toAdd.size() == 0 && toRemove.size() == 0) {
            Tracing.debug((String)"[reconciler] [plan] Plan matches the request.");
        }
        if (toAdd.size() != 0) {
            Tracing.debug((String)"[reconciler] [plan] Some units will not be installed, because they are already installed or there are dependency issues:");
            for (IInstallableUnit unit : toAdd) {
                Tracing.debug((String)new StringBuffer("[reconciler] [plan] ").append(unit).toString());
            }
        }
        if (toRemove.size() != 0) {
            Tracing.debug((String)"[reconciler] [plan] Some units will not be uninstalled:");
            for (IInstallableUnit unit : toRemove) {
                Tracing.debug((String)new StringBuffer("[reconciler] [plan] ").append(unit).toString());
            }
        }
    }

    private void debug(ProfileChangeRequest request) {
        if (!Tracing.DEBUG_RECONCILER) {
            return;
        }
        Collection toAdd = request.getAdditions();
        if (toAdd == null || toAdd.size() == 0) {
            Tracing.debug((String)"[reconciler] No installable units to add.");
        } else {
            for (IInstallableUnit add : toAdd) {
                Tracing.debug((String)new StringBuffer("[reconciler] Adding IU: ").append(add.getId()).append(' ').append(add.getVersion()).toString());
            }
        }
        Map propsToAdd = request.getInstallableUnitProfilePropertiesToAdd();
        if (propsToAdd == null || propsToAdd.isEmpty()) {
            Tracing.debug((String)"[reconciler] No IU properties to add.");
        } else {
            for (Map.Entry entry : propsToAdd.entrySet()) {
                Tracing.debug((String)new StringBuffer("[reconciler] Adding IU property: ").append(entry.getKey()).append("->").append(entry.getValue()).toString());
            }
        }
        Collection toRemove = request.getRemovals();
        if (toRemove == null || toRemove.size() == 0) {
            Tracing.debug((String)"[reconciler] No installable units to remove.");
        } else {
            for (IInstallableUnit remove : toRemove) {
                Tracing.debug((String)new StringBuffer("[reconciler] Removing IU: ").append(remove.getId()).append(' ').append(remove.getVersion()).toString());
            }
        }
        Map propsToRemove = request.getInstallableUnitProfilePropertiesToRemove();
        if (propsToRemove == null || propsToRemove.isEmpty()) {
            Tracing.debug((String)"[reconciler] No IU properties to remove.");
        } else {
            for (Map.Entry entry : propsToRemove.entrySet()) {
                Tracing.debug((String)new StringBuffer("[reconciler] Removing IU property: ").append(entry.getKey()).append("->").append(entry.getValue()).toString());
            }
        }
    }

    private IQueryResult<IInstallableUnit> getAllIUsFromRepos() {
        Collector allRepos = new Collector();
        for (IMetadataRepository repository : this.repositoryMap.values()) {
            allRepos.addAll(repository.query(QueryUtil.createIUAnyQuery(), null));
        }
        return allRepos;
    }

    private IProvisioningPlan createProvisioningPlan(ProfileChangeRequest request, ProvisioningContext provisioningContext, IProgressMonitor monitor) {
        IPlanner planner = (IPlanner)this.agent.getService(IPlanner.SERVICE_NAME);
        return planner.getProvisioningPlan((IProfileChangeRequest)request, provisioningContext, monitor);
    }

    private IStatus setProperty(String key, String value, ProvisioningContext provisioningContext, IProgressMonitor monitor) {
        IEngine engine = (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
        IProvisioningPlan plan = engine.createPlan(this.profile, provisioningContext);
        plan.setProfileProperty(key, value);
        IPhaseSet phaseSet = PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{PhaseSetFactory.PHASE_PROPERTY});
        return engine.perform(plan, phaseSet, monitor);
    }

    private IStatus executePlan(IProvisioningPlan plan, ProvisioningContext provisioningContext, IProgressMonitor monitor) {
        IEngine engine = (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
        IPhaseSet phaseSet = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{PhaseSetFactory.PHASE_COLLECT, PhaseSetFactory.PHASE_CHECK_TRUST});
        if (plan.getInstallerPlan() != null) {
            IStatus installerPlanStatus = engine.perform(plan.getInstallerPlan(), phaseSet, monitor);
            if (!installerPlanStatus.isOK()) {
                return installerPlanStatus;
            }
            this.applyConfiguration(true);
        }
        return engine.perform(plan, phaseSet, monitor);
    }

    private IStatus applyConfiguration(boolean isInstaller) {
        Class<?> clazz;
        if (!isInstaller && ProfileSynchronizer.isReconciliationApplicationRunning()) {
            return Status.OK_STATUS;
        }
        BundleContext context = Activator.getContext();
        try {
            clazz = Class.forName("org.eclipse.equinox.internal.provisional.configurator.Configurator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        Configurator configurator = (Configurator)context.getService(reference);
        try {
            try {
                configurator.applyConfiguration();
            }
            catch (IOException e) {
                Status status = new Status(4, PROP_FROM_DROPINS, "Unexpected failure applying configuration", (Throwable)e);
                context.ungetService(reference);
                return status;
            }
        }
        finally {
            context.ungetService(reference);
        }
        return Status.OK_STATUS;
    }

    static boolean isReconciliationApplicationRunning() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        EnvironmentInfo info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)clazz.getName());
        if (info == null) {
            return false;
        }
        String[] args = info.getCommandLineArgs();
        if (args == null) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] != null && RECONCILER_APPLICATION_ID.equals(args[i].trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static class ReconcilerProfileChangeRequest
    extends ProfileChangeRequest {
        boolean isMove = false;

        public ReconcilerProfileChangeRequest(IProfile profile, boolean isMove) {
            super(profile);
            this.isMove = isMove;
        }
    }
}

