/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MModelComponent;
import org.eclipse.e4.ui.model.application.MModelComponents;
import org.eclipse.e4.workbench.modeling.IModelExtension;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.osgi.framework.Bundle;

public class ModelExtensionProcessor {
    private static final String extensionPointID = "org.eclipse.e4.workbench.model";
    private MApplication e4Window;

    public ModelExtensionProcessor(MApplication e4Window) {
        this.e4Window = e4Window;
    }

    private Object findDefaultParent(String parentID) {
        MApplicationElement defaultElement = null;
        if (parentID != null && (defaultElement = this.findElementById((MApplicationElement)this.e4Window, parentID)) != null) {
            return defaultElement;
        }
        return null;
    }

    public void addModelExtensions() {
        IExtension[] extensions;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(extensionPointID);
        IExtension[] iExtensionArray = extensions = extPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] ces;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ces = extension.getConfigurationElements();
            int n3 = ces.length;
            int n4 = 0;
            while (n4 < n3) {
                block22: {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if ("snippet".equals(ce.getName())) {
                        IContributor contributor = ce.getContributor();
                        String attrURI = ce.getAttribute("uri");
                        if (attrURI == null) {
                            this.log("Unable to find location for the model extension \"{0}\"", contributor.getName());
                        } else {
                            Resource resource;
                            URI uri;
                            String bundleName = contributor.getName();
                            String path = String.valueOf(bundleName) + '/' + attrURI;
                            try {
                                uri = URI.createPlatformPluginURI((String)path, (boolean)false);
                            }
                            catch (RuntimeException e) {
                                this.log("Model extension has invalid location", e);
                                break block22;
                            }
                            try {
                                resource = new ResourceSetImpl().getResource(uri, true);
                            }
                            catch (RuntimeException e) {
                                this.log("Unable to read model extension", e);
                                break block22;
                            }
                            EList contents = resource.getContents();
                            if (!contents.isEmpty()) {
                                Object extensionRoot = contents.get(0);
                                if (!(extensionRoot instanceof MModelComponents)) {
                                    this.log("Unable to create model extension \"{0}\"", contributor.getName());
                                } else {
                                    EList snippets = ((MModelComponents)extensionRoot).getComponents();
                                    for (MModelComponent snippet : snippets) {
                                        Object parentElement = this.findDefaultParent(snippet.getParentID());
                                        if (parentElement == null) {
                                            this.log("Unable to find parent with ID \"{0}\" for extension \"{1}\"", snippet.getParentID(), contributor.getName());
                                            continue;
                                        }
                                        EObject parentObject = (EObject)parentElement;
                                        if (snippet.getProcessor() != null && snippet.getProcessor().length() > 0) {
                                            Bundle bundle = Activator.getDefault().getBundleForName(contributor.getName());
                                            if (bundle == null) continue;
                                            try {
                                                Class pc = bundle.loadClass(snippet.getProcessor());
                                                IModelExtension me = (IModelExtension)pc.newInstance();
                                                me.processElement(parentObject);
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                            continue;
                                        }
                                        Object[] elements = ((EObject)snippet).eContents().toArray();
                                        int i = 0;
                                        while (i < elements.length) {
                                            EStructuralFeature sourceFeature = ((EObject)elements[i]).eContainingFeature();
                                            EStructuralFeature destinationFeature = parentObject.eClass().getEStructuralFeature(sourceFeature.getName());
                                            if (destinationFeature == null) {
                                                this.log("Unable to find feature named \"{0}\"", sourceFeature.getName());
                                            } else {
                                                Object oldValue = parentObject.eGet(destinationFeature);
                                                if (oldValue instanceof EList) {
                                                    ((EList)oldValue).add(elements[i]);
                                                } else {
                                                    parentObject.eSet(destinationFeature, elements[i]);
                                                }
                                            }
                                            ++i;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void log(String msg, Exception e) {
        e.printStackTrace();
    }

    private void log(String msg, String arg) {
        System.err.println(MessageFormat.format((String)msg, (Object[])new Object[]{arg}));
    }

    private void log(String msg, String arg, String arg2) {
        System.err.println(MessageFormat.format((String)msg, (Object[])new Object[]{arg, arg2}));
    }

    private MApplicationElement findElementById(MApplicationElement element, String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        if (id.equals(element.getId())) {
            return element;
        }
        EList elements = ((EObject)element).eContents();
        for (EObject childElement : elements) {
            MApplicationElement result;
            if (!(childElement instanceof MApplicationElement) || (result = this.findElementById((MApplicationElement)childElement, id)) == null) continue;
            return result;
        }
        return null;
    }
}

