/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Shell;

public class ResizableShellSupport {
    private static final int TRIM_SIZE = 4;
    private static final int CORNER_SIZE = 22;

    public static void makeResizable(final Shell shell) {
        if ((shell.getStyle() & 0x10) != 0) {
            return;
        }
        GridLayout layout = (GridLayout)shell.getLayout();
        layout.marginWidth += 4;
        layout.marginHeight += 4;
        MouseListenerMix listenerMix = new MouseListenerMix(shell);
        shell.addMouseMoveListener((MouseMoveListener)listenerMix);
        shell.addMouseTrackListener((MouseTrackListener)listenerMix);
        shell.addMouseListener((MouseListener)listenerMix);
        shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle clientArea = shell.getClientArea();
                int gap = -2;
                Geometry.expand((Rectangle)clientArea, (int)gap, (int)(gap - 1), (int)gap, (int)(gap - 1));
                e.gc.setLineWidth(4);
                e.gc.setForeground(e.display.getSystemColor(19));
                e.gc.drawRectangle(clientArea);
            }
        });
    }

    private static class MouseListenerMix
    extends MouseTrackAdapter
    implements MouseListener,
    MouseMoveListener {
        private final Shell fShell;
        private final int fMinShellWidth;
        private final int fMinShellHeight;
        private int fCurrentEdges;
        private Cursor fOriginalCursor;
        private Point fOriginalMouseLoc;
        private Rectangle fOriginalShellBounds;

        public MouseListenerMix(Shell shell) {
            this.fShell = shell;
            Rectangle trim = shell.computeTrim(0, 0, 0, 0);
            this.fMinShellWidth = trim.width + 8;
            this.fMinShellHeight = trim.height + 8;
        }

        public void mouseMove(MouseEvent e) {
            if (this.fOriginalMouseLoc != null) {
                Point mouse = this.fShell.toDisplay(e.x, e.y);
                int dx = mouse.x - this.fOriginalMouseLoc.x;
                int dy = mouse.y - this.fOriginalMouseLoc.y;
                Rectangle sb = Geometry.copy((Rectangle)this.fOriginalShellBounds);
                if ((this.fCurrentEdges & 0x4000) != 0) {
                    int w = Math.max(sb.width - dx, this.fMinShellWidth);
                    sb.x += sb.width - w;
                    sb.width = w;
                }
                if ((this.fCurrentEdges & 0x20000) != 0) {
                    sb.width = Math.max(sb.width + dx, this.fMinShellWidth);
                }
                if ((this.fCurrentEdges & 0x80) != 0) {
                    int h = Math.max(sb.height - dy, this.fMinShellHeight);
                    sb.y += sb.height - h;
                    sb.height = h;
                }
                if ((this.fCurrentEdges & 0x400) != 0) {
                    sb.height = Math.max(sb.height + dy, this.fMinShellHeight);
                }
                this.fShell.setBounds(sb);
            } else {
                int edges = this.computeEdges(e);
                this.setEdgesAndCursor(edges);
            }
        }

        public void mouseExit(MouseEvent e) {
            this.setEdgesAndCursor(0);
        }

        public void mouseDown(MouseEvent e) {
            if (this.fCurrentEdges != 0) {
                this.fOriginalMouseLoc = this.fShell.toDisplay(e.x, e.y);
                this.fOriginalShellBounds = this.fShell.getBounds();
            }
        }

        public void mouseUp(MouseEvent e) {
            this.fOriginalMouseLoc = null;
            this.fOriginalShellBounds = null;
            this.fShell.setFocus();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        private int computeEdges(MouseEvent e) {
            Rectangle sb = this.fShell.getClientArea();
            int edges = 0;
            if (sb.contains(e.x, e.y)) {
                int bottom = sb.y + sb.height - e.y;
                int top = e.y - sb.y;
                int right = sb.x + sb.width - e.x;
                int left = e.x - sb.x;
                if (bottom <= 4) {
                    edges |= 0x400;
                } else if (top <= 4) {
                    edges |= 0x80;
                }
                if (right <= 4) {
                    edges |= 0x20000;
                } else if (left <= 4) {
                    edges |= 0x4000;
                }
                if ((edges & 0x400) != 0) {
                    edges = MouseListenerMix.enlargeCorner(1024, right, 131072, left, 16384);
                } else if ((edges & 0x20000) != 0) {
                    edges = MouseListenerMix.enlargeCorner(131072, bottom, 1024, top, 128);
                } else if ((edges & 0x4000) != 0) {
                    edges = MouseListenerMix.enlargeCorner(16384, bottom, 1024, top, 128);
                } else if ((edges & 0x80) != 0) {
                    edges = MouseListenerMix.enlargeCorner(128, right, 131072, left, 16384);
                }
            }
            return edges;
        }

        private static int enlargeCorner(int edge, int distance1, int edge1, int distance2, int edge2) {
            int edges = edge;
            if (distance1 <= 22) {
                edges |= edge1;
            } else if (distance2 <= 22) {
                edges |= edge2;
            }
            return edges;
        }

        private void setEdgesAndCursor(int edges) {
            if (edges == this.fCurrentEdges) {
                return;
            }
            if (edges == 0) {
                this.fShell.setCursor(this.fOriginalCursor);
                this.fOriginalCursor = null;
                this.fCurrentEdges = edges;
                this.fOriginalMouseLoc = null;
                this.fOriginalShellBounds = null;
                return;
            }
            if (this.fCurrentEdges == 0) {
                this.fOriginalCursor = this.fShell.getCursor();
            }
            this.fCurrentEdges = edges;
            int style = 0;
            if ((edges & 0x80) != 0) {
                style = (edges & 0x4000) != 0 ? 17 : ((edges & 0x20000) != 0 ? 14 : 10);
            } else if ((edges & 0x400) != 0) {
                style = (edges & 0x4000) != 0 ? 16 : ((edges & 0x20000) != 0 ? 15 : 11);
            } else if ((edges & 0x4000) != 0) {
                style = 13;
            } else if ((edges & 0x20000) != 0) {
                style = 12;
            }
            Cursor cursor = this.fShell.getDisplay().getSystemCursor(style);
            this.fShell.setCursor(cursor);
        }
    }
}

