/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.NameVersionDescriptor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.pde.internal.ui.shared.FilteredCheckboxTree;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.BundleException;

public class TargetContentsGroup {
    private CachedCheckboxTreeViewer fTree;
    private MenuManager fMenuManager;
    private Button fSelectButton;
    private Button fDeselectButton;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Button fSelectRequiredButton;
    private Label fModeLabel;
    private Button fPluginModeButton;
    private Button fFeaureModeButton;
    private Label fShowLabel;
    private Button fShowSourceButton;
    private Button fShowPluginsButton;
    private Label fCountLabel;
    private Label fGroupLabel;
    private Combo fGroupCombo;
    private ComboPart fGroupComboPart;
    private ViewerFilter fSourceFilter;
    private ViewerFilter fPluginFilter;
    private ITargetDefinition fTargetDefinition;
    private Map fFileBundleMapping;
    private List fMissingFeatures;
    private static final NameVersionDescriptor OTHER_CATEGORY = new NameVersionDescriptor(Messages.TargetContentsGroup_OtherPluginsParent, null);
    private List fAllBundles = new ArrayList();
    private int fGrouping;
    private static final int GROUP_BY_NONE = 0;
    private static final int GROUP_BY_FILE_LOC = 1;
    private static final int GROUP_BY_CONTAINER = 2;
    private ListenerList fChangeListeners = new ListenerList();

    public static TargetContentsGroup createInForm(Composite parent, FormToolkit toolkit) {
        TargetContentsGroup contentTable = new TargetContentsGroup();
        contentTable.createFormContents(parent, toolkit);
        return contentTable;
    }

    public static TargetContentsGroup createInDialog(Composite parent) {
        TargetContentsGroup contentTable = new TargetContentsGroup();
        contentTable.createDialogContents(parent);
        return contentTable;
    }

    protected TargetContentsGroup() {
    }

    public void addTargetChangedListener(ITargetChangedListener listener) {
        this.fChangeListeners.add((Object)listener);
    }

    public void contentChanged() {
        Object[] listeners = this.fChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITargetChangedListener)listeners[i]).contentsChanged(this.fTargetDefinition, this, false, false);
            ++i;
        }
    }

    public void dispose() {
        if (this.fMenuManager != null) {
            this.fMenuManager.dispose();
        }
    }

    protected void createFormContents(Composite parent, FormToolkit toolkit) {
        this.fGrouping = 0;
        Composite comp = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        this.createTree(comp, toolkit);
        this.createButtons(comp, toolkit);
        this.fCountLabel = toolkit.createLabel(comp, "");
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.fCountLabel.setLayoutData((Object)data);
        this.updateButtons();
        this.initializeFilters();
    }

    protected void createDialogContents(Composite parent) {
        this.fGrouping = 0;
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808, 0, 0);
        this.createTree(comp, null);
        this.createButtons(comp, null);
        this.fCountLabel = SWTFactory.createLabel(comp, "", 2);
        this.updateButtons();
        this.initializeFilters();
    }

    private TreeViewer createTree(Composite parent, FormToolkit toolkit) {
        FilteredCheckboxTree tree = new FilteredCheckboxTree(parent, toolkit);
        tree.setLayoutData(new GridData(1808));
        tree.getPatternFilter().setIncludeLeadingWildcard(true);
        this.fTree = tree.getCheckboxTreeViewer();
        ((GridData)this.fTree.getControl().getLayoutData()).heightHint = 300;
        this.fTree.setUseHashlookup(true);
        this.fTree.setContentProvider((IContentProvider)new TreeContentProvider());
        this.fTree.setLabelProvider((IBaseLabelProvider)new StyledBundleLabelProvider(true, false));
        this.fTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object first = selection.getFirstElement();
                TargetContentsGroup.this.fTree.setChecked(first, !TargetContentsGroup.this.fTree.getChecked(first));
                TargetContentsGroup.this.saveIncludedBundleState();
                TargetContentsGroup.this.contentChanged();
                TargetContentsGroup.this.updateButtons();
                TargetContentsGroup.this.fTree.update(TargetContentsGroup.this.fTargetDefinition.getBundleContainers(), new String[]{"org.eclipse.jface.text"});
            }
        });
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TargetContentsGroup.this.saveIncludedBundleState();
                TargetContentsGroup.this.contentChanged();
                TargetContentsGroup.this.updateButtons();
                TargetContentsGroup.this.fTree.update(TargetContentsGroup.this.fTargetDefinition.getBundleContainers(), new String[]{"org.eclipse.jface.text"});
            }
        });
        this.fTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetContentsGroup.this.updateButtons();
            }
        });
        this.fTree.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (TargetContentsGroup.this.fFeaureModeButton.getSelection()) {
                    if (e1 == OTHER_CATEGORY) {
                        return 1;
                    }
                    if (e2 == OTHER_CATEGORY) {
                        return -1;
                    }
                }
                if (e1 instanceof IResolvedBundle && !(e2 instanceof IResolvedBundle)) {
                    return -1;
                }
                if (e2 instanceof IResolvedBundle && !(e1 instanceof IResolvedBundle)) {
                    return 1;
                }
                if (e1 instanceof IResolvedBundle && e2 instanceof IResolvedBundle) {
                    IStatus status1 = ((IResolvedBundle)e1).getStatus();
                    IStatus status2 = ((IResolvedBundle)e2).getStatus();
                    if (!status1.isOK() && status2.isOK()) {
                        return -1;
                    }
                    if (status1.isOK() && !status2.isOK()) {
                        return 1;
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fMenuManager = new MenuManager();
        this.fMenuManager.add((IAction)new Action(Messages.TargetContentsGroup_collapseAll, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL")){

            public void run() {
                TargetContentsGroup.this.fTree.collapseAll();
            }
        });
        Menu contextMenu = this.fMenuManager.createContextMenu((Control)tree);
        tree.setMenu(contextMenu);
        return this.fTree;
    }

    private void createButtons(Composite parent, FormToolkit toolkit) {
        Composite buttonComp;
        if (toolkit != null) {
            buttonComp = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            buttonComp.setLayout((Layout)layout);
            buttonComp.setLayoutData((Object)new GridData(1040));
            this.fSelectButton = toolkit.createButton(buttonComp, Messages.IncludedBundlesTree_0, 8);
            this.fSelectButton.setLayoutData((Object)new GridData(768));
            this.fDeselectButton = toolkit.createButton(buttonComp, Messages.IncludedBundlesTree_1, 8);
            this.fDeselectButton.setLayoutData((Object)new GridData(768));
            Label emptySpace = new Label(buttonComp, 0);
            GridData gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectAllButton = toolkit.createButton(buttonComp, Messages.IncludedBundlesTree_2, 8);
            this.fSelectAllButton.setLayoutData((Object)new GridData(768));
            this.fDeselectAllButton = toolkit.createButton(buttonComp, Messages.IncludedBundlesTree_3, 8);
            this.fDeselectAllButton.setLayoutData((Object)new GridData(768));
            emptySpace = new Label(buttonComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectRequiredButton = toolkit.createButton(buttonComp, Messages.TargetContentsGroup_4, 8);
            this.fSelectRequiredButton.setLayoutData((Object)new GridData(768));
            Composite filterComp = toolkit.createComposite(buttonComp);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            filterComp.setLayout((Layout)layout);
            filterComp.setLayoutData((Object)new GridData(16384, 1024, true, true));
            this.fModeLabel = toolkit.createLabel(filterComp, Messages.TargetContentsGroup_ManageUsing);
            this.fPluginModeButton = toolkit.createButton(filterComp, Messages.TargetContentsGroup_PluginMode, 16);
            this.fPluginModeButton.setSelection(true);
            this.fFeaureModeButton = toolkit.createButton(filterComp, Messages.TargetContentsGroup_FeatureMode, 16);
            this.fFeaureModeButton.setSelection(true);
            emptySpace = new Label(filterComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fShowLabel = toolkit.createLabel(filterComp, Messages.BundleContainerTable_9);
            this.fShowPluginsButton = toolkit.createButton(filterComp, Messages.BundleContainerTable_14, 32);
            this.fShowPluginsButton.setSelection(true);
            this.fShowSourceButton = toolkit.createButton(filterComp, Messages.BundleContainerTable_15, 32);
            this.fShowSourceButton.setSelection(true);
            emptySpace = new Label(filterComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fGroupLabel = toolkit.createLabel(filterComp, Messages.TargetContentsGroup_0);
            this.fGroupComboPart = new ComboPart();
            this.fGroupComboPart.createControl(filterComp, toolkit, 2060);
            gd = new GridData(768);
            gd.horizontalIndent = 10;
            this.fGroupComboPart.getControl().setLayoutData((Object)gd);
            this.fGroupComboPart.setItems(new String[]{Messages.TargetContentsGroup_1, Messages.TargetContentsGroup_2, Messages.TargetContentsGroup_3});
            this.fGroupComboPart.setVisibleItemCount(30);
            this.fGroupComboPart.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TargetContentsGroup.this.handleGroupChange();
                }
            });
            this.fGroupComboPart.select(0);
        } else {
            buttonComp = SWTFactory.createComposite(parent, 1, 1, 1040, 0, 0);
            this.fSelectButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_0, null);
            this.fDeselectButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_1, null);
            Label emptySpace = new Label(buttonComp, 0);
            GridData gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectAllButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_2, null);
            this.fDeselectAllButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_3, null);
            emptySpace = new Label(buttonComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectRequiredButton = SWTFactory.createPushButton(buttonComp, Messages.TargetContentsGroup_4, null);
            Composite filterComp = SWTFactory.createComposite(buttonComp, 1, 1, 0, 0, 0);
            filterComp.setLayoutData((Object)new GridData(16384, 1024, true, true));
            this.fModeLabel = SWTFactory.createLabel(filterComp, Messages.TargetContentsGroup_ManageUsing, 1);
            this.fPluginModeButton = SWTFactory.createRadioButton(filterComp, Messages.TargetContentsGroup_PluginMode);
            this.fFeaureModeButton = SWTFactory.createRadioButton(filterComp, Messages.TargetContentsGroup_FeatureMode);
            emptySpace = new Label(filterComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fShowLabel = SWTFactory.createLabel(filterComp, Messages.BundleContainerTable_9, 1);
            this.fShowPluginsButton = SWTFactory.createCheckButton(filterComp, Messages.BundleContainerTable_14, null, true, 1);
            this.fShowSourceButton = SWTFactory.createCheckButton(filterComp, Messages.BundleContainerTable_15, null, true, 1);
            emptySpace = new Label(filterComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fGroupLabel = SWTFactory.createLabel(filterComp, Messages.TargetContentsGroup_0, 1);
            this.fGroupCombo = SWTFactory.createCombo(filterComp, 8, 1, new String[]{Messages.TargetContentsGroup_1, Messages.TargetContentsGroup_2, Messages.TargetContentsGroup_3});
            gd = new GridData(768);
            gd.horizontalIndent = 10;
            this.fGroupCombo.setLayoutData((Object)gd);
            this.fGroupCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TargetContentsGroup.this.handleGroupChange();
                }
            });
            this.fGroupCombo.select(0);
        }
        this.fSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TargetContentsGroup.this.fTree.getSelection().isEmpty()) {
                    Object[] selected = ((IStructuredSelection)TargetContentsGroup.this.fTree.getSelection()).toArray();
                    int i = 0;
                    while (i < selected.length) {
                        TargetContentsGroup.this.fTree.setChecked(selected[i], true);
                        ++i;
                    }
                    TargetContentsGroup.this.saveIncludedBundleState();
                    TargetContentsGroup.this.contentChanged();
                    TargetContentsGroup.this.updateButtons();
                    TargetContentsGroup.this.fTree.update(TargetContentsGroup.this.fTargetDefinition.getBundleContainers(), new String[]{"org.eclipse.jface.text"});
                }
            }
        });
        this.fDeselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TargetContentsGroup.this.fTree.getSelection().isEmpty()) {
                    Object[] selected = ((IStructuredSelection)TargetContentsGroup.this.fTree.getSelection()).toArray();
                    int i = 0;
                    while (i < selected.length) {
                        TargetContentsGroup.this.fTree.setChecked(selected[i], false);
                        ++i;
                    }
                    TargetContentsGroup.this.saveIncludedBundleState();
                    TargetContentsGroup.this.contentChanged();
                    TargetContentsGroup.this.updateButtons();
                    TargetContentsGroup.this.fTree.update(TargetContentsGroup.this.fTargetDefinition.getBundleContainers(), new String[]{"org.eclipse.jface.text"});
                }
            }
        });
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetContentsGroup.this.fTree.setAllChecked(true);
                TargetContentsGroup.this.saveIncludedBundleState();
                TargetContentsGroup.this.contentChanged();
                TargetContentsGroup.this.updateButtons();
                TargetContentsGroup.this.fTree.update(TargetContentsGroup.this.fTargetDefinition.getBundleContainers(), new String[]{"org.eclipse.jface.text"});
            }
        });
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetContentsGroup.this.fTree.setAllChecked(false);
                TargetContentsGroup.this.saveIncludedBundleState();
                TargetContentsGroup.this.contentChanged();
                TargetContentsGroup.this.updateButtons();
                TargetContentsGroup.this.fTree.update(TargetContentsGroup.this.fTargetDefinition.getBundleContainers(), new String[]{"org.eclipse.jface.text"});
            }
        });
        this.fSelectRequiredButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] allChecked = TargetContentsGroup.this.fTree.getCheckedLeafElements();
                Object[] required = null;
                required = TargetContentsGroup.this.fFeaureModeButton.getSelection() ? TargetContentsGroup.this.getRequiredFeatures(((TargetDefinition)TargetContentsGroup.this.fTargetDefinition).getAllFeatures(), allChecked) : TargetContentsGroup.this.getRequiredPlugins(TargetContentsGroup.this.fAllBundles, allChecked);
                int i = 0;
                while (i < required.length) {
                    TargetContentsGroup.this.fTree.setChecked(required[i], true);
                    ++i;
                }
                TargetContentsGroup.this.saveIncludedBundleState();
                TargetContentsGroup.this.contentChanged();
                TargetContentsGroup.this.updateButtons();
                TargetContentsGroup.this.fTree.update(TargetContentsGroup.this.fTargetDefinition.getBundleContainers(), new String[]{"org.eclipse.jface.text"});
            }
        });
        this.fPluginModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((TargetDefinition)TargetContentsGroup.this.fTargetDefinition).setUIMode(0);
                TargetContentsGroup.this.contentChanged();
                TargetContentsGroup.this.fTargetDefinition.setIncluded(null);
                TargetContentsGroup.this.fGroupLabel.setEnabled(true);
                if (TargetContentsGroup.this.fGroupCombo != null) {
                    TargetContentsGroup.this.fGroupCombo.setEnabled(true);
                } else {
                    TargetContentsGroup.this.fGroupComboPart.getControl().setEnabled(true);
                }
                TargetContentsGroup.this.fTree.getControl().setRedraw(false);
                TargetContentsGroup.this.fTree.refresh(false);
                TargetContentsGroup.this.fTree.expandAll();
                TargetContentsGroup.this.updateCheckState();
                TargetContentsGroup.this.updateButtons();
                TargetContentsGroup.this.fTree.getControl().setRedraw(true);
            }
        });
        this.fPluginModeButton.setSelection(true);
        GridData gd = new GridData();
        gd.horizontalIndent = 10;
        this.fPluginModeButton.setLayoutData((Object)gd);
        this.fFeaureModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((TargetDefinition)TargetContentsGroup.this.fTargetDefinition).setUIMode(1);
                TargetContentsGroup.this.contentChanged();
                TargetContentsGroup.this.fTargetDefinition.setIncluded(null);
                TargetContentsGroup.this.fGroupLabel.setEnabled(false);
                if (TargetContentsGroup.this.fGroupCombo != null) {
                    TargetContentsGroup.this.fGroupCombo.setEnabled(false);
                } else {
                    TargetContentsGroup.this.fGroupComboPart.getControl().setEnabled(false);
                }
                TargetContentsGroup.this.fTree.getControl().setRedraw(false);
                TargetContentsGroup.this.fTree.refresh(false);
                TargetContentsGroup.this.fTree.expandAll();
                TargetContentsGroup.this.updateCheckState();
                TargetContentsGroup.this.updateButtons();
                TargetContentsGroup.this.fTree.getControl().setRedraw(true);
            }
        });
        this.fFeaureModeButton.setSelection(false);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.fFeaureModeButton.setLayoutData((Object)gd);
        this.fShowPluginsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TargetContentsGroup.this.fShowPluginsButton.getSelection()) {
                    TargetContentsGroup.this.fTree.addFilter(TargetContentsGroup.this.fPluginFilter);
                } else {
                    TargetContentsGroup.this.fTree.removeFilter(TargetContentsGroup.this.fPluginFilter);
                    TargetContentsGroup.this.fTree.expandAll();
                    TargetContentsGroup.this.updateCheckState();
                }
                TargetContentsGroup.this.updateButtons();
            }
        });
        this.fShowPluginsButton.setSelection(true);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.fShowPluginsButton.setLayoutData((Object)gd);
        this.fShowSourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TargetContentsGroup.this.fShowSourceButton.getSelection()) {
                    TargetContentsGroup.this.fTree.addFilter(TargetContentsGroup.this.fSourceFilter);
                } else {
                    TargetContentsGroup.this.fTree.removeFilter(TargetContentsGroup.this.fSourceFilter);
                    TargetContentsGroup.this.fTree.expandAll();
                    TargetContentsGroup.this.updateCheckState();
                }
                TargetContentsGroup.this.updateButtons();
            }
        });
        this.fShowSourceButton.setSelection(true);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.fShowSourceButton.setLayoutData((Object)gd);
    }

    private void initializeFilters() {
        this.fSourceFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IResolvedBundle) || !((IResolvedBundle)element).isSourceBundle();
            }
        };
        this.fPluginFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IResolvedBundle) || ((IResolvedBundle)element).isSourceBundle();
            }
        };
    }

    private IPath getParentPath(IResolvedBundle bundle) {
        URI location = bundle.getBundleInfo().getLocation();
        if (location == null) {
            return new Path(Messages.TargetContentsGroup_8);
        }
        Path path = new Path(URIUtil.toUnencodedString((URI)location));
        path = path.removeLastSegments(1);
        return path;
    }

    protected Map loadManifest(File bundleLocation) throws IOException {
        ZipFile jarFile = null;
        InputStream manifestStream = null;
        String extension = new Path(bundleLocation.getName()).getFileExtension();
        try {
            if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
                if (file.exists()) {
                    manifestStream = new FileInputStream(file);
                }
            }
            if (manifestStream == null) {
                return null;
            }
            Map map = ManifestElement.parseBundleManifest((InputStream)manifestStream, new Hashtable(10));
            return map;
        }
        catch (BundleException e) {
            PDEPlugin.log(e);
        }
        finally {
            try {
                if (manifestStream != null) {
                    manifestStream.close();
                }
            }
            catch (IOException e) {
                PDEPlugin.log(e);
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                PDEPlugin.log(e);
            }
        }
        return null;
    }

    private Object[] getRequiredPlugins(final Collection allBundles, final Object[] checkedBundles) {
        final HashSet dependencies = new HashSet();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.TargetContentsGroup_5, 150);
                    ArrayList<URL> allLocations = new ArrayList<URL>(allBundles.size());
                    Iterator iterator = allBundles.iterator();
                    while (iterator.hasNext()) {
                        IResolvedBundle current = (IResolvedBundle)iterator.next();
                        try {
                            URI location = current.getBundleInfo().getLocation();
                            if (location == null) continue;
                            allLocations.add(new File(location).toURL());
                        }
                        catch (MalformedURLException e) {
                            PDEPlugin.log(e);
                            monitor.setCanceled(true);
                            monitor.done();
                            return;
                        }
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.worked(20);
                    PDEState state = new PDEState(allLocations.toArray(new URL[allLocations.size()]), true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IPluginModelBase[] models = state.getTargetModels();
                    ArrayList<IPluginModelBase> checkedModels = new ArrayList<IPluginModelBase>(checkedBundles.length);
                    int i = 0;
                    while (i < checkedBundles.length) {
                        if (checkedBundles[i] instanceof IResolvedBundle) {
                            BundleInfo bundle = ((IResolvedBundle)checkedBundles[i]).getBundleInfo();
                            int j = 0;
                            while (j < models.length) {
                                if (models[j].getBundleDescription().getSymbolicName().equals(bundle.getSymbolicName()) && models[j].getBundleDescription().getVersion().toString().equals(bundle.getVersion())) {
                                    checkedModels.add(models[j]);
                                    break;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    monitor.worked(20);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    NameVersionDescriptor[] implicitDependencies = TargetContentsGroup.this.fTargetDefinition.getImplicitDependencies();
                    ArrayList<String> implicitIDs = new ArrayList<String>();
                    if (implicitDependencies != null) {
                        int i2 = 0;
                        while (i2 < implicitDependencies.length) {
                            implicitIDs.add(implicitDependencies[i2].getId());
                            ++i2;
                        }
                    }
                    monitor.worked(10);
                    dependencies.addAll(DependencyManager.getDependencies((Object[])checkedModels.toArray(), (String[])implicitIDs.toArray(new String[implicitIDs.size()]), (State)state.getState(), (String[])new String[]{"org.eclipse.ui.workbench.compatibility"}));
                    monitor.worked(50);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.fTree.getControl().getShell()).run(true, true, op);
            HashSet<String> checkedNames = new HashSet<String>(checkedBundles.length);
            int i = 0;
            while (i < checkedBundles.length) {
                if (checkedBundles[i] instanceof IResolvedBundle) {
                    checkedNames.add(((IResolvedBundle)checkedBundles[i]).getBundleInfo().getSymbolicName());
                }
                ++i;
            }
            ArrayList<IResolvedBundle> toCheck = new ArrayList<IResolvedBundle>();
            Iterator iterator = this.fAllBundles.iterator();
            while (iterator.hasNext()) {
                IResolvedBundle bundle = (IResolvedBundle)iterator.next();
                if (bundle.isSourceBundle()) {
                    String name = bundle.getSourceTarget().getSymbolicName();
                    if (name == null || !dependencies.contains(name) && !checkedNames.contains(name)) continue;
                    toCheck.add(bundle);
                    continue;
                }
                if (!dependencies.contains(bundle.getBundleInfo().getSymbolicName())) continue;
                toCheck.add(bundle);
            }
            return toCheck.toArray();
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
        return new Object[0];
    }

    private Object[] getRequiredFeatures(IFeatureModel[] allFeatures, Object[] checkedFeatures) {
        ArrayList required = new ArrayList();
        int j = 0;
        while (j < checkedFeatures.length) {
            if (checkedFeatures[j] instanceof IFeatureModel) {
                this.getFeatureDependencies((IFeatureModel)checkedFeatures[j], allFeatures, required);
            }
            ++j;
        }
        return required.toArray();
    }

    private void getFeatureDependencies(IFeatureModel model, IFeatureModel[] allFeatures, ArrayList requiredFeatureList) {
        IFeature feature = model.getFeature();
        IFeatureImport[] featureImports = feature.getImports();
        int i = 0;
        while (i < featureImports.length) {
            if (featureImports[i].getType() == 1) {
                int j = 0;
                while (j < allFeatures.length) {
                    if (allFeatures[j].getFeature().getId().equals(featureImports[i].getId())) {
                        requiredFeatureList.add(allFeatures[j]);
                        this.getFeatureDependencies(allFeatures[j], allFeatures, requiredFeatureList);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        IFeatureChild[] featureIncludes = feature.getIncludedFeatures();
        int i2 = 0;
        while (i2 < featureIncludes.length) {
            requiredFeatureList.add(featureIncludes[i2].getId());
            int j = 0;
            while (j < allFeatures.length) {
                if (allFeatures[j].getFeature().getId().equals(featureIncludes[i2].getId())) {
                    requiredFeatureList.add(allFeatures[j]);
                    this.getFeatureDependencies(allFeatures[j], allFeatures, requiredFeatureList);
                    break;
                }
                ++j;
            }
            ++i2;
        }
    }

    private void handleGroupChange() {
        int index = this.fGroupCombo != null ? this.fGroupCombo.getSelectionIndex() : this.fGroupComboPart.getSelectionIndex();
        if (index != this.fGrouping) {
            this.fGrouping = index;
            this.fTree.getControl().setRedraw(false);
            this.fTree.refresh(false);
            this.fTree.expandAll();
            this.updateCheckState();
            this.updateButtons();
            this.fTree.getControl().setRedraw(true);
        }
    }

    private void updateButtons() {
        if (this.fTargetDefinition != null && !this.fTree.getSelection().isEmpty()) {
            Object[] selection = ((IStructuredSelection)this.fTree.getSelection()).toArray();
            boolean hasResolveBundle = false;
            boolean hasParent = false;
            boolean allSelected = true;
            boolean noneSelected = true;
            int i = 0;
            while (i < selection.length) {
                boolean checked;
                if (!hasResolveBundle || !hasParent) {
                    if (selection[i] instanceof IResolvedBundle) {
                        hasResolveBundle = true;
                    } else {
                        hasParent = true;
                    }
                }
                if (checked = this.fTree.getChecked(selection[i])) {
                    noneSelected = false;
                } else {
                    allSelected = false;
                }
                ++i;
            }
            this.fSelectButton.setEnabled(!allSelected && (!hasResolveBundle || !hasParent));
            this.fDeselectButton.setEnabled(!noneSelected && (!hasResolveBundle || !hasParent));
        } else {
            this.fSelectButton.setEnabled(false);
            this.fDeselectButton.setEnabled(false);
        }
        int total = this.fAllBundles.size();
        if (this.fFeaureModeButton.getSelection()) {
            total = ((TargetDefinition)this.fTargetDefinition).getAllFeatures().length;
            total += ((TargetDefinition)this.fTargetDefinition).getOtherBundles().length;
        }
        this.fSelectAllButton.setEnabled(this.fTargetDefinition != null && this.fTree.getCheckedLeafCount() != total);
        this.fDeselectAllButton.setEnabled(this.fTargetDefinition != null && this.fTree.getCheckedLeafCount() != 0);
        this.fSelectRequiredButton.setEnabled(this.fTargetDefinition != null && this.fTree.getCheckedLeafCount() > 0 && this.fTree.getCheckedLeafCount() != total);
        if (this.fTargetDefinition != null) {
            this.fCountLabel.setText(MessageFormat.format((String)Messages.TargetContentsGroup_9, (Object[])new String[]{Integer.toString(this.fTree.getCheckedLeafCount()), Integer.toString(total)}));
        } else {
            this.fCountLabel.setText("");
        }
    }

    public void setInput(ITargetDefinition input) {
        this.fTargetDefinition = input;
        this.fFileBundleMapping = null;
        this.fAllBundles.clear();
        if (input == null || !input.isResolved()) {
            this.fTree.setInput(Messages.TargetContentsGroup_10);
            this.setEnabled(false);
            return;
        }
        IResolvedBundle[] allResolvedBundles = input.getAllBundles();
        if (allResolvedBundles == null || allResolvedBundles.length == 0) {
            this.fTree.setInput(Messages.TargetContentsGroup_11);
            this.setEnabled(false);
            return;
        }
        int i = 0;
        while (i < allResolvedBundles.length) {
            this.fAllBundles.add(allResolvedBundles[i]);
            ++i;
        }
        boolean isFeatureMode = ((TargetDefinition)this.fTargetDefinition).getUIMode() == 1;
        this.fFeaureModeButton.setSelection(isFeatureMode);
        this.fPluginModeButton.setSelection(!isFeatureMode);
        this.fGroupLabel.setEnabled(!isFeatureMode);
        this.fTree.getControl().setRedraw(false);
        this.fTree.setInput(this.fTargetDefinition);
        this.fTree.expandAll();
        this.updateCheckState();
        this.updateButtons();
        this.setEnabled(true);
        this.fTree.getControl().setRedraw(true);
    }

    private void updateCheckState() {
        if (this.fFeaureModeButton.getSelection()) {
            ArrayList result = new ArrayList();
            result.addAll(((TargetDefinition)this.fTargetDefinition).getFeaturesAndBundles());
            if (this.fMissingFeatures != null) {
                result.addAll(this.fMissingFeatures);
            }
            this.fTree.setCheckedElements(result.toArray());
        } else {
            this.fTree.setCheckedElements(this.fTargetDefinition.getBundles());
        }
    }

    public void setCancelled() {
        this.fTargetDefinition = null;
        this.fTree.setInput(Messages.TargetContentsGroup_resolveCancelled);
        this.setEnabled(false);
    }

    private Map getFileBundleMapping() {
        if (this.fFileBundleMapping != null) {
            return this.fFileBundleMapping;
        }
        this.fFileBundleMapping = new HashMap();
        Iterator iterator = this.fAllBundles.iterator();
        while (iterator.hasNext()) {
            IResolvedBundle currentBundle = (IResolvedBundle)iterator.next();
            IPath parentPath = this.getParentPath(currentBundle);
            ArrayList<IResolvedBundle> bundles = (ArrayList<IResolvedBundle>)this.fFileBundleMapping.get(parentPath);
            if (bundles == null) {
                bundles = new ArrayList<IResolvedBundle>();
                bundles.add(currentBundle);
                this.fFileBundleMapping.put(parentPath, bundles);
                continue;
            }
            bundles.add(currentBundle);
        }
        return this.fFileBundleMapping;
    }

    private Object[] getBundleChildren(Object parent) {
        Object[] result = null;
        if (parent == null) {
            result = this.fAllBundles.toArray();
        } else {
            List bundles;
            if (this.fFeaureModeButton.getSelection() && parent == OTHER_CATEGORY) {
                return ((TargetDefinition)this.fTargetDefinition).getOtherBundles();
            }
            if (this.fGrouping == 2 && parent instanceof IBundleContainer) {
                IBundleContainer container = (IBundleContainer)parent;
                return container.getBundles();
            }
            if (this.fGrouping == 1 && parent instanceof IPath && (bundles = (List)this.getFileBundleMapping().get(parent)) != null && bundles.size() > 0) {
                result = bundles.toArray();
            }
        }
        if (result == null) {
            return new Object[0];
        }
        return result;
    }

    public void setEnabled(boolean enabled) {
        this.fTree.getControl().setEnabled(enabled);
        if (enabled) {
            this.updateButtons();
        } else {
            this.fSelectButton.setEnabled(false);
            this.fSelectAllButton.setEnabled(false);
            this.fDeselectButton.setEnabled(false);
            this.fDeselectAllButton.setEnabled(false);
            this.fSelectRequiredButton.setEnabled(false);
            this.fCountLabel.setText("");
        }
        this.fModeLabel.setEnabled(enabled);
        this.fPluginModeButton.setEnabled(enabled);
        this.fFeaureModeButton.setEnabled(enabled);
        this.fShowLabel.setEnabled(enabled);
        this.fShowPluginsButton.setEnabled(enabled);
        this.fShowSourceButton.setEnabled(enabled);
        boolean isPluginMode = !this.fFeaureModeButton.getSelection();
        this.fGroupLabel.setEnabled(enabled && isPluginMode);
        if (this.fGroupCombo != null) {
            this.fGroupCombo.setEnabled(enabled && isPluginMode);
        } else {
            this.fGroupComboPart.setEnabled(enabled && isPluginMode);
        }
    }

    public void saveIncludedBundleState() {
        if (this.fFeaureModeButton.getSelection()) {
            ArrayList<NameVersionDescriptor> included = new ArrayList<NameVersionDescriptor>();
            Object[] checked = this.fTree.getCheckedLeafElements();
            int i = 0;
            while (i < checked.length) {
                if (checked[i] instanceof IFeatureModel) {
                    included.add(new NameVersionDescriptor(((IFeatureModel)checked[i]).getFeature().getId(), null, "feature"));
                }
                if (checked[i] instanceof IResolvedBundle) {
                    if (((IResolvedBundle)checked[i]).getStatus().getCode() == 100) {
                        included.add(new NameVersionDescriptor(((IResolvedBundle)checked[i]).getBundleInfo().getSymbolicName(), null, "feature"));
                    } else {
                        included.add(new NameVersionDescriptor(((IResolvedBundle)checked[i]).getBundleInfo().getSymbolicName(), null));
                    }
                }
                ++i;
            }
            if (included == null || included.size() == 0) {
                this.fTargetDefinition.setIncluded(new NameVersionDescriptor[0]);
            } else if (included.size() == ((TargetDefinition)this.fTargetDefinition).getAllFeatures().length + ((TargetDefinition)this.fTargetDefinition).getOtherBundles().length) {
                this.fTargetDefinition.setIncluded(null);
            } else {
                this.fTargetDefinition.setIncluded(included.toArray(new NameVersionDescriptor[included.size()]));
            }
        } else {
            HashSet<String> multi = new HashSet<String>();
            HashSet<String> all = new HashSet<String>();
            Iterator iterator = this.fAllBundles.iterator();
            while (iterator.hasNext()) {
                IResolvedBundle rb = (IResolvedBundle)iterator.next();
                if (all.add(rb.getBundleInfo().getSymbolicName())) continue;
                multi.add(rb.getBundleInfo().getSymbolicName());
            }
            ArrayList<NameVersionDescriptor> included = new ArrayList<NameVersionDescriptor>();
            Object[] checked = this.fTree.getCheckedLeafElements();
            int i = 0;
            while (i < checked.length) {
                if (checked[i] instanceof IResolvedBundle) {
                    String bsn = ((IResolvedBundle)checked[i]).getBundleInfo().getSymbolicName();
                    NameVersionDescriptor info = null;
                    info = multi.contains(bsn) ? new NameVersionDescriptor(bsn, ((IResolvedBundle)checked[i]).getBundleInfo().getVersion()) : new NameVersionDescriptor(bsn, null);
                    included.add(info);
                }
                ++i;
            }
            if (included == null || included.size() == 0) {
                this.fTargetDefinition.setIncluded(new NameVersionDescriptor[0]);
            } else if (included.size() == this.fAllBundles.size()) {
                this.fTargetDefinition.setIncluded(null);
            } else {
                this.fTargetDefinition.setIncluded(included.toArray(new NameVersionDescriptor[included.size()]));
            }
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return TargetContentsGroup.this.getBundleChildren(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (TargetContentsGroup.this.fFeaureModeButton.getSelection() && element == OTHER_CATEGORY) {
                return true;
            }
            if (TargetContentsGroup.this.fGrouping == 0 || element instanceof IResolvedBundle) {
                return false;
            }
            if (element instanceof IBundleContainer || element instanceof IPath) {
                return TargetContentsGroup.this.getBundleChildren(element).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ITargetDefinition) {
                if (TargetContentsGroup.this.fFeaureModeButton.getSelection()) {
                    ArrayList<Object> result = new ArrayList<Object>();
                    IFeatureModel[] features = ((TargetDefinition)TargetContentsGroup.this.fTargetDefinition).getAllFeatures();
                    result.addAll(Arrays.asList(features));
                    if (((TargetDefinition)TargetContentsGroup.this.fTargetDefinition).getOtherBundles().length > 0) {
                        result.add(OTHER_CATEGORY);
                    }
                    if (TargetContentsGroup.this.fMissingFeatures == null) {
                        TargetContentsGroup.this.fMissingFeatures = new ArrayList();
                    } else {
                        TargetContentsGroup.this.fMissingFeatures.clear();
                    }
                    IResolvedBundle[] bundles = TargetContentsGroup.this.fTargetDefinition.getBundles();
                    int i = 0;
                    while (i < bundles.length) {
                        if (!bundles[i].getStatus().isOK()) {
                            TargetContentsGroup.this.fMissingFeatures.add(bundles[i]);
                            result.add(bundles[i]);
                        }
                        ++i;
                    }
                    return result.toArray();
                }
                if (TargetContentsGroup.this.fGrouping == 2) {
                    return TargetContentsGroup.this.fTargetDefinition.getBundleContainers();
                }
                if (TargetContentsGroup.this.fGrouping == 0) {
                    return TargetContentsGroup.this.fTargetDefinition.getAllBundles();
                }
                return TargetContentsGroup.this.getFileBundleMapping().keySet().toArray();
            }
            return new Object[]{inputElement};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

