/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.imports.BaseImportWizardSecondPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportLabelProvider;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PluginImportWizardExpressPage
extends BaseImportWizardSecondPage {
    private TablePart fTablePart;
    private IStructuredSelection fInitialSelection;
    private Label fCounterLabel;

    public PluginImportWizardExpressPage(String pageName, PluginImportWizardFirstPage page, IStructuredSelection selection) {
        super(pageName, page);
        this.fInitialSelection = selection;
        this.setTitle(PDEUIMessages.ImportWizard_expressPage_title);
        this.setMessage(PDEUIMessages.ImportWizard_expressPage_desc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createTablePart(container);
        this.createImportPart(container);
        this.createButtons(container);
        Composite optionsComp = SWTFactory.createComposite(container, 1, 2, 768, 5, 0);
        this.createComputationsOption(optionsComp);
        this.fAddFragmentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardExpressPage.this.pageChanged();
            }
        });
        this.initialize();
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.plugin_import_express_page");
        Dialog.applyDialogFont((Control)container);
    }

    private void createButtons(Composite container) {
        Composite buttonComp = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginBottom = 10;
        layout.verticalSpacing = 0;
        layout.marginRight = 4;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(768));
        Button selectAll = new Button(buttonComp, 8);
        selectAll.setLayoutData((Object)new GridData(768));
        selectAll.setText(PDEUIMessages.WizardCheckboxTablePart_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardExpressPage.this.fTablePart.handleSelectAll(true);
                PluginImportWizardExpressPage.this.pageChanged();
            }
        });
        Button deselectAll = new Button(buttonComp, 8);
        deselectAll.setLayoutData((Object)new GridData(768));
        deselectAll.setText(PDEUIMessages.WizardCheckboxTablePart_deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardExpressPage.this.fTablePart.handleSelectAll(false);
                PluginImportWizardExpressPage.this.pageChanged();
            }
        });
    }

    private Composite createTablePart(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.fTablePart = new TablePart(PDEUIMessages.ImportWizard_expressPage_nonBinary, new String[0]);
        this.fTablePart.createControl(container);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        gd.heightHint = 200;
        this.fTablePart.getControl().setLayoutData((Object)gd);
        CheckboxTableViewer viewer = this.fTablePart.getTableViewer();
        viewer.setLabelProvider((IBaseLabelProvider)new PluginImportLabelProvider());
        viewer.setContentProvider((IContentProvider)new PluginContentProvider());
        viewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        viewer.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        return container;
    }

    private void createImportPart(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.createImportList(container);
        this.fCounterLabel = new Label(container, 0);
        this.fCounterLabel.setLayoutData((Object)new GridData(768));
    }

    private void initialize() {
        Object[] items = this.fInitialSelection.toArray();
        ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < items.length) {
            IPluginModelBase model;
            IProject project;
            Object item = items[i];
            if (item instanceof IJavaProject) {
                item = ((IJavaProject)item).getProject();
            }
            if (item instanceof IProject && WorkspaceModelManager.isPluginProject((IProject)(project = (IProject)item)) && !WorkspaceModelManager.isBinaryProject((IProject)project) && (model = PluginRegistry.findModel((IProject)project)) != null) {
                list.add(model);
            }
            ++i;
        }
        this.fTablePart.setSelection(list.toArray());
    }

    private void computeModelsToImport() {
        this.fImportListViewer.getTable().removeAll();
        ArrayList result = new ArrayList();
        Object[] wModels = this.fTablePart.getSelection();
        int i = 0;
        while (i < wModels.length) {
            IPluginModelBase model = (IPluginModelBase)wModels[i];
            this.addDependencies(model, result, this.fAddFragmentsButton.getSelection());
            this.addExtraPrerequisites(model, result);
            ++i;
        }
        if (wModels.length > 0) {
            this.removeSharedModels(result);
        }
        this.fImportListViewer.add(result.toArray());
    }

    private void removeSharedModels(ArrayList result) {
        IPluginModelBase[] smodels = result.toArray(new IPluginModelBase[result.size()]);
        int i = 0;
        while (i < smodels.length) {
            IProject project;
            IResource resource;
            String id = smodels[i].getPluginBase().getId();
            IPluginModelBase model = PluginRegistry.findModel((String)id);
            if (model != null && (resource = model.getUnderlyingResource()) != null && !WorkspaceModelManager.isUnsharedProject((IProject)(project = resource.getProject()))) {
                result.remove(smodels[i]);
            }
            ++i;
        }
    }

    private void addExtraPrerequisites(IPluginModelBase model, ArrayList result) {
        try {
            IFile buildFile;
            IBuildModel buildModel = model.getBuildModel();
            if (buildModel == null && (buildFile = PDEProject.getBuildProperties((IProject)model.getUnderlyingResource().getProject())).exists()) {
                buildModel = new WorkspaceBuildModel(buildFile);
                buildModel.load();
            }
            if (buildModel == null) {
                return;
            }
            IBuildEntry entry = buildModel.getBuild().getEntry("jars.extra.classpath");
            if (entry == null) {
                return;
            }
            String[] tokens = entry.getTokens();
            int i = 0;
            while (i < tokens.length) {
                Path path = new Path(tokens[i]);
                if (path.segmentCount() >= 2 && path.segment(0).equals("..")) {
                    int j = 0;
                    while (j < this.fModels.length) {
                        if (this.fModels[j].getPluginBase().getId().equals(path.segment(1)) && !result.contains(this.fModels[j])) {
                            result.add(this.fModels[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    protected void refreshPage() {
        this.pageChanged();
    }

    protected void pageChanged() {
        this.computeModelsToImport();
        this.updateCount();
        this.setPageComplete(this.fImportListViewer.getTable().getItemCount() > 0);
    }

    private void updateCount() {
        this.fCounterLabel.setText(NLS.bind((String)PDEUIMessages.ImportWizard_expressPage_total, (Object)new Integer(this.fImportListViewer.getTable().getItemCount()).toString()));
        this.fCounterLabel.getParent().layout();
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            IProject[] projects = PDEPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
            int i = 0;
            while (i < projects.length) {
                IPluginModelBase model;
                if (WorkspaceModelManager.isPluginProject((IProject)projects[i]) && !WorkspaceModelManager.isBinaryProject((IProject)projects[i]) && (model = PluginRegistry.findModel((IProject)projects[i])) != null) {
                    result.add(model);
                }
                ++i;
            }
            return result.toArray();
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel, String[] buttonLabels) {
            super(mainLabel, buttonLabels);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            return viewer;
        }

        protected void elementChecked(Object element, boolean checked) {
            super.elementChecked(element, checked);
            PluginImportWizardExpressPage.this.pageChanged();
        }

        protected void handleSelectAll(boolean select) {
            super.handleSelectAll(select);
            PluginImportWizardExpressPage.this.pageChanged();
        }
    }
}

