/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.services.internal.events;

import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.PreDestroy;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.services.Activator;
import org.eclipse.e4.ui.internal.services.ServiceMessages;
import org.eclipse.e4.ui.services.internal.events.UIEventHandler;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class EventBroker
implements IEventBroker {
    private Map<EventHandler, ServiceRegistration> registrations = new HashMap<EventHandler, ServiceRegistration>();
    @Inject
    Logger logger;

    static {
        EventAdmin eventAdmin = Activator.getDefault().getEventAdmin();
        if (eventAdmin == null) {
            Bundle[] bundles;
            Bundle[] bundleArray = bundles = Activator.getDefault().getBundleContext().getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if ("org.eclipse.equinox.event".equals(bundle.getSymbolicName())) {
                    try {
                        bundle.start(1);
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++n2;
            }
        }
    }

    public boolean send(String topic, Object data) {
        Event event = this.constructEvent(topic, data);
        EventAdmin eventAdmin = Activator.getDefault().getEventAdmin();
        if (eventAdmin == null) {
            this.logger.error(NLS.bind((String)ServiceMessages.NO_EVENT_ADMIN, (Object)event.toString()));
            return false;
        }
        eventAdmin.sendEvent(event);
        return true;
    }

    public boolean post(String topic, Object data) {
        Event event = this.constructEvent(topic, data);
        EventAdmin eventAdmin = Activator.getDefault().getEventAdmin();
        if (eventAdmin == null) {
            this.logger.error(NLS.bind((String)ServiceMessages.NO_EVENT_ADMIN, (Object)event.toString()));
            return false;
        }
        eventAdmin.postEvent(event);
        return true;
    }

    private Event constructEvent(String topic, Object data) {
        Event event;
        if (data instanceof Dictionary) {
            event = new Event(topic, (Dictionary)data);
        } else if (data instanceof Map) {
            event = new Event(topic, (Map)data);
        } else {
            Hashtable<String, Object> d = new Hashtable<String, Object>(2);
            ((Dictionary)d).put("event.topics", topic);
            if (data != null) {
                ((Dictionary)d).put("org.eclipse.e4.data", data);
            }
            event = new Event(topic, d);
        }
        return event;
    }

    public boolean subscribe(String topic, EventHandler eventHandler) {
        return this.subscribe(topic, null, eventHandler, false);
    }

    public boolean subscribe(String topic, String filter, EventHandler eventHandler, boolean headless) {
        BundleContext bundleContext = Activator.getDefault().getBundleContext();
        if (bundleContext == null) {
            this.logger.error(NLS.bind((String)ServiceMessages.NO_BUNDLE_CONTEXT, (Object)topic));
            return false;
        }
        String[] topics = new String[]{topic};
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        ((Dictionary)d).put("event.topics", topics);
        if (filter != null) {
            ((Dictionary)d).put("event.filter", filter);
        }
        UIEventHandler wrappedHandler = new UIEventHandler(eventHandler, headless);
        ServiceRegistration registration = bundleContext.registerService(EventHandler.class.getName(), (Object)wrappedHandler, d);
        this.registrations.put(eventHandler, registration);
        return true;
    }

    public boolean unsubscribe(EventHandler eventHandler) {
        ServiceRegistration registration = this.registrations.remove(eventHandler);
        if (registration == null) {
            return false;
        }
        registration.unregister();
        return true;
    }

    @PreDestroy
    void dispose() {
        Collection<ServiceRegistration> values = this.registrations.values();
        ServiceRegistration[] array = values.toArray(new ServiceRegistration[values.size()]);
        this.registrations.clear();
        int i = 0;
        while (i < array.length) {
            array[i].unregister();
            ++i;
        }
    }
}

